/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re.ui;

import com.intellij.javaee.jpa.jpb.model.db.IdeaDataStore;
import com.intellij.jpa.jpb.model.config.JpaBuddyIdeaProjectConfig;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.core.model.DataStore;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.dbdrivers.DbDriversManager;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.ui.component.DataSourceField;
import com.intellij.liquibase.core.msg.LiquibaseResourceBundle;
import com.intellij.liquibase.orm.DiffGeneratorErrorDialog;
import com.intellij.liquibase.orm.gui.RefreshableDataSourceField;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.re.DbSnapshotGenerator;
import com.intellij.re.DbSnapshotModel;
import com.intellij.re.UltimateDbSnapshotGenerator;
import com.intellij.re.util.NotificationUtilsKt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import liquibase.structure.core.Relation;
import liquibase.structure.core.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\u001dH\u0016J\u0012\u0010(\u001a\u00020\u001d2\b\b\u0002\u0010)\u001a\u00020\u0007H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020\u0017H\u0004J\u0016\u0010.\u001a\u00020\u001d2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020,0+H\u0014J\u0014\u00100\u001a\u00020\u001d2\n\u00101\u001a\u000602j\u0002`3H\u0002J\b\u00104\u001a\u0004\u0018\u000105J\b\u00106\u001a\u0004\u0018\u00010&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u00067"}, d2={"Lcom/intellij/re/ui/DbTablesLoaderPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "project", "Lcom/intellij/openapi/project/Project;", "ormFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "isInitDbConnectionListener", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectConfig", "Lcom/intellij/jpa/jpb/model/config/JpaBuddyIdeaProjectConfig;", "getProjectConfig", "()Lcom/intellij/jpa/jpb/model/config/JpaBuddyIdeaProjectConfig;", "dbSnapshotGenerator", "Lcom/intellij/re/DbSnapshotGenerator;", "dbConnectionsField", "Lcom/intellij/jpa/jpb/model/ui/component/DataSourceField;", "getDbConnectionsField", "()Lcom/intellij/jpa/jpb/model/ui/component/DataSourceField;", "dbSnapshotModel", "Lcom/intellij/re/DbSnapshotModel;", "getDbSnapshotModel", "()Lcom/intellij/re/DbSnapshotModel;", "setDbSnapshotModel", "(Lcom/intellij/re/DbSnapshotModel;)V", "initFieldValues", "", "initDataStore", "Lcom/intellij/jpa/jpb/model/core/model/DataStore;", "initTableName", "", "createDbConnectionComponent", "Ljavax/swing/JComponent;", "hasDriver", "dataStore", "Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;", "saveSettings", "updateTablesField", "refreshSnapshot", "getSortedRelations", "", "Lliquibase/structure/core/Relation;", "loadedModel", "afterLoadedTables", "relations", "showConnectionErrorDialog", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getSelectedDbProperties", "Lcom/intellij/jpa/jpb/model/core/model/dbprop/DbProperties;", "getSelectedDataStore", "intellij.javaee.reverseEngineering"})
@SourceDebugExtension(value={"SMAP\nDbTablesLoaderPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbTablesLoaderPanel.kt\ncom/intellij/re/ui/DbTablesLoaderPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n1#2:126\n13#3:127\n*S KotlinDebug\n*F\n+ 1 DbTablesLoaderPanel.kt\ncom/intellij/re/ui/DbTablesLoaderPanel\n*L\n116#1:127\n*E\n"})
public class DbTablesLoaderPanel
extends BorderLayoutPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final JpaBuddyIdeaProjectConfig projectConfig;
    @NotNull
    private final DbSnapshotGenerator dbSnapshotGenerator;
    @NotNull
    private final DataSourceField dbConnectionsField;
    @NotNull
    private DbSnapshotModel dbSnapshotModel;

    public DbTablesLoaderPanel(@NotNull Project project, @NotNull OrmFramework ormFramework, boolean isInitDbConnectionListener) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ormFramework, (String)"ormFramework");
        this.project = project;
        this.projectConfig = JpaBuddyIdeaProjectConfig.Companion.getInstance(this.project);
        UltimateDbSnapshotGenerator ultimateDbSnapshotGenerator = UltimateDbSnapshotGenerator.Companion.getInstance(this.project);
        Intrinsics.checkNotNull((Object)ultimateDbSnapshotGenerator);
        this.dbSnapshotGenerator = ultimateDbSnapshotGenerator;
        this.dbConnectionsField = new DataSourceField(this.project, ormFramework, false, 4, null);
        this.dbSnapshotModel = DbSnapshotModel.Companion.getEMPTY_MODEL();
        if (isInitDbConnectionListener) {
            this.dbConnectionsField.getField().addActionListener(arg_0 -> DbTablesLoaderPanel._init_$lambda$0(this, arg_0));
        }
    }

    public /* synthetic */ DbTablesLoaderPanel(Project project, OrmFramework ormFramework, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(project, ormFramework, bl);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final JpaBuddyIdeaProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    @NotNull
    public final DataSourceField getDbConnectionsField() {
        return this.dbConnectionsField;
    }

    @NotNull
    public final DbSnapshotModel getDbSnapshotModel() {
        return this.dbSnapshotModel;
    }

    public final void setDbSnapshotModel(@NotNull DbSnapshotModel dbSnapshotModel) {
        Intrinsics.checkNotNullParameter((Object)dbSnapshotModel, (String)"<set-?>");
        this.dbSnapshotModel = dbSnapshotModel;
    }

    public void initFieldValues(@Nullable DataStore initDataStore, @Nullable String initTableName) {
        if (initDataStore != null && initDataStore instanceof AbstractRdbmsStore && !this.hasDriver((AbstractRdbmsStore)initDataStore)) {
            DataSourceField.initItems$default((DataSourceField)this.dbConnectionsField, null, (boolean)false, null, (int)4, null);
        } else {
            DataSourceField.initItems$default((DataSourceField)this.dbConnectionsField, (DataStore)initDataStore, (boolean)false, null, (int)4, null);
        }
        if (initDataStore == null) {
            AbstractRdbmsStore lastSelectedDs;
            this.dbConnectionsField.getField().setSelectedItem(null);
            String lastDbConnectionId = this.projectConfig.getReverseEngineeringLastDbConnectionId();
            CharSequence charSequence = lastDbConnectionId;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && (lastSelectedDs = this.dbConnectionsField.findDataSourceById(lastDbConnectionId)) != null && this.hasDriver(lastSelectedDs)) {
                this.dbConnectionsField.getField().setSelectedItem((Object)lastSelectedDs);
            }
        }
    }

    @NotNull
    public final JComponent createDbConnectionComponent() {
        return RefreshableDataSourceField.Companion.wrapToRefreshableIfNeeded(this.dbConnectionsField, () -> DbTablesLoaderPanel.createDbConnectionComponent$lambda$0(this));
    }

    private final boolean hasDriver(AbstractRdbmsStore dataStore) {
        boolean bl;
        if (dataStore instanceof IdeaDataStore) {
            return true;
        }
        DbDriversManager dbDriversManager = DbDriversManager.Companion.getInstance(this.project);
        DbProperties dbProperties = dataStore.getDbProperties();
        if (dbProperties != null && (dbProperties = dbProperties.getType()) != null) {
            DbProperties it = dbProperties;
            boolean bl2 = false;
            bl = dbDriversManager.hasDriver((DbType)it);
        } else {
            bl = false;
        }
        return bl;
    }

    public void saveSettings() {
        AbstractRdbmsStore abstractRdbmsStore = this.getSelectedDataStore();
        String selectedDsId = abstractRdbmsStore != null ? abstractRdbmsStore.getId() : null;
        this.projectConfig.setReverseEngineeringLastDbConnectionId(selectedDsId);
    }

    public void updateTablesField(boolean refreshSnapshot) {
        DbSnapshotModel loadedModel;
        DbSnapshotModel dbSnapshotModel;
        this.dbSnapshotModel = DbSnapshotModel.Companion.getEMPTY_MODEL();
        AbstractRdbmsStore abstractRdbmsStore = this.getSelectedDataStore();
        if (abstractRdbmsStore == null) {
            return;
        }
        AbstractRdbmsStore selectedDataSource = abstractRdbmsStore;
        try {
            dbSnapshotModel = this.dbSnapshotGenerator.loadModel(selectedDataSource);
        }
        catch (Exception e) {
            this.showConnectionErrorDialog(e);
            return;
        }
        this.dbSnapshotModel = loadedModel = dbSnapshotModel;
        List<Relation> relations = this.getSortedRelations(loadedModel);
        this.afterLoadedTables(relations);
    }

    public static /* synthetic */ void updateTablesField$default(DbTablesLoaderPanel dbTablesLoaderPanel, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateTablesField");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        dbTablesLoaderPanel.updateTablesField(bl);
    }

    @NotNull
    protected final List<Relation> getSortedRelations(@NotNull DbSnapshotModel loadedModel) {
        Intrinsics.checkNotNullParameter((Object)loadedModel, (String)"loadedModel");
        Function1[] function1Array = new Function1[]{DbTablesLoaderPanel::getSortedRelations$lambda$0, DbTablesLoaderPanel::getSortedRelations$lambda$1};
        return CollectionsKt.sortedWith((Iterable)loadedModel.getRelations(), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
    }

    protected void afterLoadedTables(@NotNull List<? extends Relation> relations) {
        Intrinsics.checkNotNullParameter(relations, (String)"relations");
    }

    private final void showConnectionErrorDialog(Exception exception) {
        if (exception instanceof CancellationException) {
            String string = LiquibaseResourceBundle.message((String)"loading.database.model.canceled", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            NotificationUtilsKt.showReGroupNotification(this.project, string, NotificationType.WARNING);
            return;
        }
        Throwable throwable = ExceptionUtil.getRootCause((Throwable)exception);
        Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getRootCause(...)");
        Throwable rootCause = throwable;
        if (rootCause instanceof ProcessCanceledException) {
            return;
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DbTablesLoaderPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Exception when loading database model", (Throwable)exception);
        DbProperties dbProperties = this.getSelectedDbProperties();
        DbType dbType = dbProperties != null ? dbProperties.getType() : null;
        String string = LiquibaseResourceBundle.message((String)"loading.database.model.error", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        DiffGeneratorErrorDialog.Companion.show(this.project, exception, dbType, string);
    }

    @Nullable
    public final DbProperties getSelectedDbProperties() {
        AbstractRdbmsStore abstractRdbmsStore = this.getSelectedDataStore();
        return abstractRdbmsStore != null ? abstractRdbmsStore.getDbProperties() : null;
    }

    @Nullable
    public final AbstractRdbmsStore getSelectedDataStore() {
        DataStore dataStore = this.dbConnectionsField.getSelectedDataSource();
        return dataStore instanceof AbstractRdbmsStore ? (AbstractRdbmsStore)dataStore : null;
    }

    private static final void _init_$lambda$0(DbTablesLoaderPanel this$0, ActionEvent it) {
        DbTablesLoaderPanel.updateTablesField$default(this$0, false, 1, null);
    }

    private static final void createDbConnectionComponent$lambda$0(DbTablesLoaderPanel this$0) {
        this$0.updateTablesField(true);
    }

    private static final Comparable getSortedRelations$lambda$0(Relation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Boolean.valueOf(it instanceof View);
    }

    private static final Comparable getSortedRelations$lambda$1(Relation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getName());
    }
}

