/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.unified;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SshUiData
implements MutableRemoteCredentials,
Cloneable {
    @NotNull
    private SshConfig myConfig;
    @NotNull
    private SshConfig.AuthData myAuthData;

    public SshUiData(@NotNull SshConfig config) {
        if (config == null) {
            SshUiData.g(0);
        }
        this(config, true);
    }

    public SshUiData(@NotNull SshConfig config, boolean initAuthDataFromPasswordSafe) {
        if (config == null) {
            SshUiData.g(1);
        }
        this(config, SshUiData.g(config, initAuthDataFromPasswordSafe));
    }

    private static @NotNull SshConfig.AuthData g(@NotNull SshConfig sshConfig, boolean bl) {
        if (sshConfig == null) {
            SshUiData.g(2);
        }
        AccessToken accessToken = SlowOperations.knownIssue((String)"IJPL-162828");
        SshConfig.AuthData authData = bl ? sshConfig.getAuthDataFromForPasswordSafe() : new SshConfig.AuthData();
        SshConfig.AuthData authData2 = authData;
        if (authData2 == null) {
            SshUiData.g(3);
        }
        return authData2;
        finally {
            if (accessToken != null) {
                accessToken.close();
            }
        }
    }

    public SshUiData(@NotNull SshConfig config, @NotNull SshConfig.AuthData data) {
        if (config == null) {
            SshUiData.g(4);
        }
        if (data == null) {
            SshUiData.g(5);
        }
        this.myConfig = config;
        this.myAuthData = data;
        this.myConfig.setConnectionConfigPatchAuthData();
    }

    public String getName() {
        return this.myConfig.getName();
    }

    @NotNull
    public SshConfig getConfig() {
        SshConfig sshConfig = this.myConfig;
        if (sshConfig == null) {
            SshUiData.g(6);
        }
        return sshConfig;
    }

    public SshUiData clone() {
        try {
            SshUiData sshUiData = (SshUiData)super.clone();
            sshUiData.myConfig = this.myConfig.clone();
            sshUiData.myAuthData = this.myAuthData.clone();
            return sshUiData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    public SshUiData copy() {
        try {
            SshUiData sshUiData = (SshUiData)super.clone();
            sshUiData.myConfig = this.myConfig.clone();
            sshUiData.myAuthData = this.myAuthData.clone();
            return sshUiData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    public void setHost(@Nullable String host) {
        this.myConfig.setHost(host);
    }

    public void setPort(int port) {
        this.myConfig.setPort(port);
    }

    public void setLiteralPort(@Nullable String portText) {
        this.myConfig.setLiteralPort(portText);
    }

    public void setAuthType(@NotNull AuthType authType) {
        if (authType == null) {
            SshUiData.g(7);
        }
        this.myConfig.setAuthType(authType);
    }

    public boolean isOpenSshConfigUsageForced() {
        return this.myConfig.isOpenSshConfigUsageForced();
    }

    public void setOpenSshConfigUsageForced(boolean useOpenSSHConfig) {
        this.myConfig.setOpenSshConfigUsageForced(useOpenSSHConfig);
    }

    @NotNull
    public String getHost() {
        String string = this.myConfig.getHost();
        if (string == null) {
            SshUiData.g(8);
        }
        return string;
    }

    public int getPort() {
        return this.myConfig.getPort();
    }

    @NotNull
    public String getLiteralPort() {
        String string = this.myConfig.getLiteralPort();
        if (string == null) {
            SshUiData.g(9);
        }
        return string;
    }

    @NotNull
    public AuthType getAuthType() {
        AuthType authType = this.myConfig.getAuthType();
        if (authType == null) {
            SshUiData.g(10);
        }
        return authType;
    }

    @Nullable
    public String getPassword() {
        return this.myAuthData.getPassword();
    }

    public void setPassword(@Nullable String password) {
        this.myAuthData.setPassword(password);
    }

    public boolean isStorePassword() {
        return this.myAuthData.isSavePassword();
    }

    public void setStorePassword(boolean savePassword) {
        this.myAuthData.setSavePassword(savePassword);
    }

    @NotNull
    public String getPrivateKeyFile() {
        String string = this.myConfig.getKeyPath();
        if (string == null) {
            SshUiData.g(11);
        }
        return string;
    }

    public void setPrivateKeyFile(@Nullable String keyPath) {
        this.myConfig.setKeyPath(keyPath);
    }

    @Nullable
    public String getPassphrase() {
        return this.myAuthData.getPassphrase();
    }

    public void setPassphrase(@Nullable String passphrase) {
        this.myAuthData.setPassphrase(passphrase);
    }

    public boolean isStorePassphrase() {
        return this.myAuthData.isSavePassphrase();
    }

    public void setStorePassphrase(boolean savePassphrase) {
        this.myAuthData.setSavePassphrase(savePassphrase);
    }

    public void setUserName(@Nullable String userName) {
        this.myConfig.setUsername(userName);
    }

    @NotNull
    public String getUserName() {
        String string = this.myConfig.getUsername();
        if (string == null) {
            SshUiData.g(12);
        }
        return string;
    }

    @Nullable
    public SshConnectionConfigPatch getConnectionConfigPatch() {
        return this.myConfig.getConnectionConfigPatch();
    }

    public void setConnectionConfigPatch(@Nullable SshConnectionConfigPatch patch) {
        this.myConfig.setConnectionConfigPatch(patch);
    }

    public void mergeAndSaveAuthData(SshConfig.AuthData data, boolean retainedExistingKeyPath, boolean retainedRegisteredKeyPath) {
        Pair<String, Boolean> pair = SshUiData.g(this.getPassword(), this.isStorePassword(), data.getPassword(), data.isSavePassword());
        this.setPassword((String)pair.first);
        this.setStorePassword((Boolean)pair.second);
        if (retainedExistingKeyPath && retainedRegisteredKeyPath) {
            Pair<String, Boolean> pair2 = SshUiData.g(this.getPassphrase(), this.isStorePassphrase(), data.getPassphrase(), data.isSavePassphrase());
            this.setPassphrase((String)pair2.first);
            this.setStorePassphrase((Boolean)pair2.second);
        } else if (retainedRegisteredKeyPath) {
            this.setPassphrase(data.getPassphrase());
            this.setStorePassphrase(data.isSavePassphrase());
        }
        this.saveAuthDataToPasswordSafe();
    }

    @NotNull
    public RemoteCredentials copyToCredentials() {
        RemoteCredentialsHolder remoteCredentialsHolder = new RemoteCredentialsHolder();
        remoteCredentialsHolder.copyFrom((RemoteCredentials)this);
        RemoteCredentialsHolder remoteCredentialsHolder2 = remoteCredentialsHolder;
        if (remoteCredentialsHolder2 == null) {
            SshUiData.g(13);
        }
        return remoteCredentialsHolder2;
    }

    @NotNull
    private static @NotNull Pair<String, @NotNull Boolean> g(String string, boolean bl, String string2, boolean bl2) {
        if (StringUtil.isEmpty((String)string) && StringUtil.isEmpty((String)string2)) {
            return new Pair((Object)string, (Object)(bl || bl2 ? 1 : 0));
        }
        if (!StringUtil.isEmpty((String)string) && StringUtil.isEmpty((String)string2)) {
            return new Pair((Object)string, (Object)bl);
        }
        if (StringUtil.isEmpty((String)string) && !StringUtil.isEmpty((String)string2)) {
            return new Pair((Object)string2, (Object)bl2);
        }
        if (bl) {
            return new Pair((Object)string, (Object)true);
        }
        if (bl2) {
            return new Pair((Object)string2, (Object)true);
        }
        return new Pair((Object)string, (Object)false);
    }

    public boolean hasNoCredentials() {
        return this.myAuthData.hasNoCredentials(this.myConfig.getAuthType(), this.myConfig.getKeyPath());
    }

    public String toString() {
        return "SshUiData{ myConfig='" + this.myConfig.getName() + "', myAuthData=" + String.valueOf(this.myAuthData) + "}";
    }

    @Nullable
    public static SshUiData findById(List<SshUiData> items, @NotNull String id) {
        if (id == null) {
            SshUiData.g(14);
        }
        return (SshUiData)ContainerUtil.find(items, sshUiData -> id.equals(sshUiData.getConfig().getId()));
    }

    @Nullable
    public static SshUiData findByName(List<SshUiData> items, @NotNull String name) {
        if (name == null) {
            SshUiData.g(15);
        }
        return (SshUiData)ContainerUtil.find(items, sshUiData -> name.equals(sshUiData.getName()));
    }

    @NotNull
    public @NotNull Pair<@NotNull Credentials, @NotNull Boolean> getCredentialsAndMemoryOnly() {
        Pair pair = switch (this.getAuthType()) {
            default -> throw new MatchException(null, null);
            case AuthType.OPEN_SSH -> Pair.create((Object)new Credentials(this.getUserName(), (String)null), (Object)true);
            case AuthType.PASSWORD -> Pair.create((Object)new Credentials(this.getUserName(), this.getPassword()), (Object)this.isStorePassword());
            case AuthType.KEY_PAIR -> Pair.create((Object)new Credentials(this.getUserName(), this.getPassphrase()), (Object)this.isStorePassphrase());
        };
        if (pair == null) {
            SshUiData.g(16);
        }
        return pair;
    }

    public void setCredentials(@Nullable Credentials authCredentials, boolean saveCredentialsInPermanentStore, boolean applyToPasswordSafe) {
        this.myConfig.setUsername(authCredentials == null || authCredentials.getUserName() == null ? "" : authCredentials.getUserName());
        this.myAuthData = SshConfig.AuthData.create(this.getAuthType(), authCredentials, saveCredentialsInPermanentStore);
        if (applyToPasswordSafe) {
            this.myConfig.saveAuthDataToPasswordSafe(this.myAuthData);
            ((SshConfigManager.SshConfigAuthListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConfigManager.SSH_CONFIG_AUTH)).sshConfigAuthDataChanged(this.myConfig);
        }
    }

    public void loadFromCredentials(@NotNull RemoteCredentials remoteCredentials) {
        if (remoteCredentials == null) {
            SshUiData.g(17);
        }
        RemoteCredentialsHolder.copyRemoteCredentials((RemoteCredentials)remoteCredentials, (MutableRemoteCredentials)this);
    }

    public void reloadAuthDataFromPasswordSafe() {
        this.myAuthData = this.myConfig.getAuthDataFromForPasswordSafe();
    }

    public void enforceEmptyCredentials() {
        switch (this.getAuthType()) {
            case OPEN_SSH: {
                break;
            }
            case PASSWORD: {
                if (this.getPassword() != null) break;
                this.setPassword("");
                this.saveAuthDataToPasswordSafe();
                break;
            }
            case KEY_PAIR: {
                if (this.getPassphrase() != null) break;
                this.setPassphrase("");
                this.saveAuthDataToPasswordSafe();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected auth type " + String.valueOf(this.getAuthType()));
            }
        }
    }

    public void saveAuthDataToPasswordSafe() {
        this.myConfig.saveAuthDataToPasswordSafe(this.myAuthData);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SshUiData sshUiData = (SshUiData)o;
        return this.myConfig.equals(sshUiData.myConfig) && this.myAuthData.equals(sshUiData.myAuthData);
    }

    public int hashCode() {
        return Objects.hash(this.myConfig, this.myAuthData);
    }

    @NotNull
    public static SshUiData createData(@NotNull String name, @Nullable String id, @NotNull SshConfigVisibility visibility) {
        if (name == null) {
            SshUiData.g(18);
        }
        if (visibility == null) {
            SshUiData.g(19);
        }
        SshConfig sshConfig = new SshConfig(true);
        if (id != null) {
            sshConfig.setId(id);
        }
        sshConfig.setProjectLevel(visibility == SshConfigVisibility.Project);
        SshConfig.parseContent(name, sshConfig);
        return new SshUiData(sshConfig, false);
    }

    private static /* synthetic */ void g(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 8, 9, 10, 11, 12, 13, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/ui/unified/SshUiData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteCredentials";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/ui/unified/SshUiData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralPort";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrivateKeyFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToCredentials";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentialsAndMemoryOnly";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAuthData";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setAuthType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadFromCredentials";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 8, 9, 10, 11, 12, 13, 16 -> new IllegalStateException(string);
        };
    }
}

