/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.target;

import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.internal.consumer.AbstractLongRunningOperation;
import org.gradle.tooling.internal.consumer.BlockingResultHandler;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.target.GradleServerRunner;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.execution.target.GradleToolingProxyClassloaderHolder;
import org.jetbrains.plugins.gradle.execution.target.TargetProjectConnection;
import org.jetbrains.plugins.gradle.tooling.proxy.TargetBuildParameters;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u0000*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0000*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b\"\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ#\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001fH\u0016\u00a2\u0006\u0002\u0010 J\u0017\u0010!\u001a\u00028\u00002\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010$J\r\u0010%\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u00020(2\u000e\u0010)\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010*H\u0004J\u0018\u0010+\u001a\u00020(2\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010,0*H\u0002J\f\u0010-\u001a\u00020#*\u00020.H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/AbstractTargetBuildOperation;", "This", "R", "Lorg/gradle/tooling/internal/consumer/AbstractLongRunningOperation;", "connection", "Lorg/jetbrains/plugins/gradle/execution/target/TargetProjectConnection;", "entryPoint", "", "<init>", "(Lorg/jetbrains/plugins/gradle/execution/target/TargetProjectConnection;Ljava/lang/String;)V", "targetBuildParametersBuilder", "Lorg/jetbrains/plugins/gradle/tooling/proxy/TargetBuildParameters$Builder;", "getTargetBuildParametersBuilder", "()Lorg/jetbrains/plugins/gradle/tooling/proxy/TargetBuildParameters$Builder;", "buildActions", "", "Lorg/gradle/tooling/BuildAction;", "getBuildActions", "()Ljava/util/List;", "prepareTaskState", "", "getPrepareTaskState", "()Z", "addProgressListener", "listener", "Lorg/gradle/tooling/events/ProgressListener;", "operationTypes", "", "Lorg/gradle/tooling/events/OperationType;", "(Lorg/gradle/tooling/events/ProgressListener;[Lorg/gradle/tooling/events/OperationType;)Lorg/jetbrains/plugins/gradle/execution/target/AbstractTargetBuildOperation;", "eventTypes", "", "(Lorg/gradle/tooling/events/ProgressListener;Ljava/util/Set;)Lorg/jetbrains/plugins/gradle/execution/target/AbstractTargetBuildOperation;", "setJavaHome", "javaHome", "Ljava/io/File;", "(Ljava/io/File;)Lorg/jetbrains/plugins/gradle/execution/target/AbstractTargetBuildOperation;", "runAndGetResult", "()Ljava/lang/Object;", "runWithHandler", "", "handler", "Lorg/gradle/tooling/ResultHandler;", "runWithUncheckedHandler", "", "asNativeFile", "Ljava/nio/file/Path;", "intellij.gradle"})
public abstract class AbstractTargetBuildOperation<This extends AbstractTargetBuildOperation<This, R>, R>
extends AbstractLongRunningOperation<This> {
    @NotNull
    private final TargetProjectConnection connection;
    @NotNull
    private final List<BuildAction<?>> buildActions;
    private final boolean prepareTaskState;

    public AbstractTargetBuildOperation(@NotNull TargetProjectConnection connection, @NotNull String entryPoint) {
        Intrinsics.checkNotNullParameter((Object)((Object)connection), (String)"connection");
        Intrinsics.checkNotNullParameter((Object)entryPoint, (String)"entryPoint");
        super(connection.getParameters().getConnectionParameters());
        this.connection = connection;
        this.buildActions = CollectionsKt.emptyList();
        this.operationParamsBuilder.setEntryPoint(entryPoint);
    }

    @NotNull
    protected abstract TargetBuildParameters.Builder<?> getTargetBuildParametersBuilder();

    @NotNull
    protected List<BuildAction<?>> getBuildActions() {
        return this.buildActions;
    }

    protected boolean getPrepareTaskState() {
        return this.prepareTaskState;
    }

    @NotNull
    public This addProgressListener(@NotNull ProgressListener listener2, OperationType ... operationTypes) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)operationTypes, (String)"operationTypes");
        this.getTargetBuildParametersBuilder().withSubscriptions(ArraysKt.asIterable((Object[])operationTypes));
        AbstractLongRunningOperation abstractLongRunningOperation = super.addProgressListener(listener2, Arrays.copyOf(operationTypes, operationTypes.length));
        Intrinsics.checkNotNullExpressionValue((Object)abstractLongRunningOperation, (String)"addProgressListener(...)");
        return (This)((Object)((AbstractTargetBuildOperation)abstractLongRunningOperation));
    }

    @NotNull
    public This addProgressListener(@NotNull ProgressListener listener2, @NotNull Set<OperationType> eventTypes) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter(eventTypes, (String)"eventTypes");
        this.getTargetBuildParametersBuilder().withSubscriptions((Iterable<OperationType>)eventTypes);
        AbstractLongRunningOperation abstractLongRunningOperation = super.addProgressListener(listener2, eventTypes);
        Intrinsics.checkNotNullExpressionValue((Object)abstractLongRunningOperation, (String)"addProgressListener(...)");
        return (This)((Object)((AbstractTargetBuildOperation)abstractLongRunningOperation));
    }

    @NotNull
    public This setJavaHome(@Nullable File javaHome) {
        if (javaHome == null) {
            AbstractLongRunningOperation abstractLongRunningOperation = this.getThis();
            Intrinsics.checkNotNullExpressionValue((Object)abstractLongRunningOperation, (String)"getThis(...)");
            return (This)((Object)((AbstractTargetBuildOperation)abstractLongRunningOperation));
        }
        Path javaHomePath = javaHome.toPath();
        if (!Files.isDirectory(javaHomePath, new LinkOption[0])) {
            AbstractLongRunningOperation abstractLongRunningOperation = this.getThis();
            Intrinsics.checkNotNullExpressionValue((Object)abstractLongRunningOperation, (String)"getThis(...)");
            return (This)((Object)((AbstractTargetBuildOperation)abstractLongRunningOperation));
        }
        Field builderField = AbstractLongRunningOperation.class.getDeclaredField("operationParamsBuilder");
        builderField.setAccessible(true);
        Class<?> builderFieldType = builderField.getType();
        Field javaHomeField = builderFieldType.getDeclaredField("javaHome");
        javaHomeField.setAccessible(true);
        Object object = builderField.get(this.getThis());
        Intrinsics.checkNotNull((Object)javaHomePath);
        javaHomeField.set(object, this.asNativeFile(javaHomePath));
        AbstractLongRunningOperation abstractLongRunningOperation = this.getThis();
        Intrinsics.checkNotNullExpressionValue((Object)abstractLongRunningOperation, (String)"getThis(...)");
        return (This)((Object)((AbstractTargetBuildOperation)abstractLongRunningOperation));
    }

    protected final R runAndGetResult() {
        BlockingResultHandler resultHandler = new BlockingResultHandler(Object.class);
        this.runWithUncheckedHandler((ResultHandler<Object>)((ResultHandler)resultHandler));
        return (R)resultHandler.getResult();
    }

    protected final void runWithHandler(@NotNull ResultHandler<? super R> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.runWithUncheckedHandler(handler);
    }

    private final void runWithUncheckedHandler(ResultHandler<Object> handler) {
        String gradleUserHome;
        String gradleHome = GradleTargetUtil.maybeGetTargetValue(this.connection.getDistribution().getGradleHome());
        if (gradleHome != null) {
            this.getTargetBuildParametersBuilder().useInstallation(gradleHome);
        }
        if ((gradleUserHome = GradleTargetUtil.maybeGetTargetValue(this.connection.getParameters().getGradleUserHome())) != null) {
            this.getTargetBuildParametersBuilder().useGradleUserHome(gradleUserHome);
        }
        GradleToolingProxyClassloaderHolder classloaderHolder = new GradleToolingProxyClassloaderHolder();
        for (BuildAction<?> buildAction : this.getBuildActions()) {
            classloaderHolder.add(buildAction);
        }
        ConsumerOperationParameters consumerOperationParameters = this.getConsumerOperationParameters();
        Intrinsics.checkNotNullExpressionValue((Object)consumerOperationParameters, (String)"getConsumerOperationParameters(...)");
        GradleServerRunner serverRunner = new GradleServerRunner(this.connection, consumerOperationParameters, this.getPrepareTaskState());
        serverRunner.run(classloaderHolder, this.getTargetBuildParametersBuilder(), handler);
    }

    private final File asNativeFile(Path $this$asNativeFile) {
        EelPath asEelPath = EelNioBridgeServiceKt.asEelPath((Path)$this$asNativeFile);
        String toString = asEelPath.toString();
        return new File(toString);
    }
}

