/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.properties;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.properties.GradleProperties;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesImpl;
import org.jetbrains.plugins.gradle.properties.models.Property;
import org.jetbrains.plugins.gradle.properties.models.PropertyKt;
import org.jetbrains.plugins.gradle.service.execution.GradleUserHomeUtil;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J*\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u0013\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/gradle/properties/GradlePropertiesFile;", "", "<init>", "()V", "getProperties", "Lorg/jetbrains/plugins/gradle/properties/GradleProperties;", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "Ljava/nio/file/Path;", "serviceDirectory", "", "getPropertyPaths", "", "gradleHome", "getPropertyPathInGradleUserHome", "getPropertyPathInGradleProjectRoot", "getPropertyPathInGradleHome", "resolveGradleProjectRoot", "loadAndMergeProperties", "propertyPaths", "loadGradleProperties", "propertiesPath", "mergeGradleProperties", "most", "other", "EMPTY", "Lorg/jetbrains/plugins/gradle/properties/GradlePropertiesImpl;", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradlePropertiesFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradlePropertiesFile.kt\norg/jetbrains/plugins/gradle/properties/GradlePropertiesFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,135:1\n1586#2:136\n1661#2,3:137\n1313#3,3:140\n*S KotlinDebug\n*F\n+ 1 GradlePropertiesFile.kt\norg/jetbrains/plugins/gradle/properties/GradlePropertiesFile\n*L\n62#1:136\n62#1:137,3\n104#1:140,3\n*E\n"})
public final class GradlePropertiesFile {
    @NotNull
    public static final GradlePropertiesFile INSTANCE = new GradlePropertiesFile();
    @NotNull
    private static final GradlePropertiesImpl EMPTY = new GradlePropertiesImpl(null, null, null, null, null);

    private GradlePropertiesFile() {
    }

    @JvmStatic
    @NotNull
    public static final GradleProperties getProperties(@NotNull Project project, @NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        List<Path> propertyPaths = GradlePropertiesFile.getPropertyPaths(project, projectPath);
        return INSTANCE.loadAndMergeProperties(propertyPaths);
    }

    @JvmStatic
    @NotNull
    public static final GradleProperties getProperties(@Nullable String serviceDirectory, @NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        List<Path> propertyPaths = INSTANCE.getPropertyPaths(serviceDirectory, projectPath, null);
        return INSTANCE.loadAndMergeProperties(propertyPaths);
    }

    @JvmStatic
    @NotNull
    public static final List<Path> getPropertyPaths(@NotNull Project project, @NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        String linkedProjectPath = NioPathUtil.toCanonicalPath((Path)INSTANCE.resolveGradleProjectRoot(projectPath));
        String serviceDirectory = GradleSettings.getInstance(project).getServiceDirectoryPath();
        String gradleHome = GradleLocalSettings.getInstance(project).getGradleHome(linkedProjectPath);
        return INSTANCE.getPropertyPaths(serviceDirectory, projectPath, gradleHome);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> getPropertyPaths(String serviceDirectory, Path projectPath, String gradleHome) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = new Path[]{this.getPropertyPathInGradleUserHome(serviceDirectory), this.getPropertyPathInGradleProjectRoot(projectPath), this.getPropertyPathInGradleHome(gradleHome)};
        object = CollectionsKt.listOfNotNull((Object[])object);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toAbsolutePath().normalize());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final Path getPropertyPathInGradleUserHome(@Nullable String serviceDirectory) {
        String gradleUserHome;
        String string = serviceDirectory;
        if (string == null) {
            string = GradleUserHomeUtil.gradleUserHomeDir().getPath();
        }
        if ((gradleUserHome = string) != null) {
            String[] stringArray = new String[]{"gradle.properties"};
            return Paths.get(gradleUserHome, stringArray);
        }
        return null;
    }

    private final Path getPropertyPathInGradleProjectRoot(Path projectPath) {
        Path path = this.resolveGradleProjectRoot(projectPath).resolve("gradle.properties");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final Path getPropertyPathInGradleHome(String gradleHome) {
        if (gradleHome != null) {
            String[] stringArray = new String[]{"gradle.properties"};
            return Paths.get(gradleHome, stringArray);
        }
        return null;
    }

    private final Path resolveGradleProjectRoot(Path projectPath) {
        for (Path buildRoot = projectPath; buildRoot != null; buildRoot = buildRoot.getParent()) {
            Intrinsics.checkNotNullExpressionValue((Object)GradleConstants.KNOWN_GRADLE_SETTINGS_FILES, (String)"KNOWN_GRADLE_SETTINGS_FILES");
            for (String settingsFileName : GradleConstants.KNOWN_GRADLE_SETTINGS_FILES) {
                Path settingsFile = buildRoot.resolve(settingsFileName);
                Intrinsics.checkNotNull((Object)settingsFile);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(settingsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                return buildRoot;
            }
        }
        return projectPath;
    }

    /*
     * WARNING - void declaration
     */
    private final GradleProperties loadAndMergeProperties(List<? extends Path> propertyPaths) {
        void $this$fold$iv;
        Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)propertyPaths), (Function1)((Function1)new Function1<Path, GradleProperties>((Object)this){

            public final GradleProperties invoke(Path p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GradlePropertiesFile.access$loadGradleProperties((GradlePropertiesFile)this.receiver, p0);
            }
        }));
        GradlePropertiesImpl initial$iv = EMPTY;
        boolean $i$f$fold = false;
        GradleProperties accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            GradleProperties gradleProperties = (GradleProperties)element$iv;
            GradleProperties p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = this.mergeGradleProperties(p0, (GradleProperties)p1);
        }
        return accumulator$iv;
    }

    private final GradleProperties loadGradleProperties(Path propertiesPath) {
        Properties properties = GradleUtil.readGradleProperties(propertiesPath);
        if (properties == null) {
            return null;
        }
        Properties properties2 = properties;
        return new GradlePropertiesImpl(PropertyKt.getStringProperty(properties2, "org.gradle.java.home", propertiesPath), PropertyKt.getStringProperty(properties2, "org.gradle.logging.level", propertiesPath), PropertyKt.getBooleanProperty(properties2, "org.gradle.parallel", propertiesPath), PropertyKt.getBooleanProperty(properties2, "org.gradle.unsafe.isolated-projects", propertiesPath), PropertyKt.getStringProperty(properties2, "org.gradle.jvmargs", propertiesPath));
    }

    private final GradleProperties mergeGradleProperties(GradleProperties most, GradleProperties other) {
        Property<String> property;
        Property<Boolean> property2;
        Property<Boolean> property3;
        Property<String> property4;
        Property<String> property5 = most.getJavaHomeProperty();
        if (property5 == null) {
            property5 = other.getJavaHomeProperty();
        }
        if ((property4 = most.getLogLevel()) == null) {
            property4 = other.getLogLevel();
        }
        if ((property3 = most.getParallel()) == null) {
            property3 = other.getParallel();
        }
        if ((property2 = most.getIsolatedProjects()) == null) {
            property2 = other.getIsolatedProjects();
        }
        if ((property = most.getJvmOptions()) == null) {
            property = other.getJvmOptions();
        }
        return new GradlePropertiesImpl(property5, property4, property3, property2, property);
    }

    public static final /* synthetic */ GradleProperties access$loadGradleProperties(GradlePropertiesFile $this, Path propertiesPath) {
        return $this.loadGradleProperties(propertiesPath);
    }
}

