/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionContext;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0000\u00a2\u0006\u0004\b\r\u0010\u0010B!\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionContextImpl;", "Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionContext;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "projectPath", "", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "listener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "cancellationToken", "Lorg/gradle/tooling/CancellationToken;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;Lorg/gradle/tooling/CancellationToken;)V", "context", "(Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionContextImpl;)V", "(Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionContextImpl;Ljava/lang/String;Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;)V", "getProjectPath", "()Ljava/lang/String;", "getTaskId", "()Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "getSettings", "()Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "getListener", "()Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "getCancellationToken", "()Lorg/gradle/tooling/CancellationToken;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "_buildEnvironment", "Lorg/gradle/tooling/model/build/BuildEnvironment;", "value", "buildEnvironment", "getBuildEnvironment", "()Lorg/gradle/tooling/model/build/BuildEnvironment;", "setBuildEnvironment", "(Lorg/gradle/tooling/model/build/BuildEnvironment;)V", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "getGradleVersion", "()Lorg/gradle/util/GradleVersion;", "intellij.gradle"})
@ApiStatus.Internal
public class GradleExecutionContextImpl
extends UserDataHolderBase
implements GradleExecutionContext {
    @NotNull
    private final String projectPath;
    @NotNull
    private final ExternalSystemTaskId taskId;
    @NotNull
    private final GradleExecutionSettings settings;
    @NotNull
    private final ExternalSystemTaskNotificationListener listener;
    @NotNull
    private final CancellationToken cancellationToken;
    @Nullable
    private BuildEnvironment _buildEnvironment;

    public GradleExecutionContextImpl(@NotNull String projectPath, @NotNull ExternalSystemTaskId taskId, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull CancellationToken cancellationToken) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)cancellationToken, (String)"cancellationToken");
        this.projectPath = projectPath;
        this.taskId = taskId;
        this.settings = settings;
        this.listener = listener2;
        this.cancellationToken = cancellationToken;
    }

    @Override
    @NotNull
    public String getProjectPath() {
        return this.projectPath;
    }

    @Override
    @NotNull
    public ExternalSystemTaskId getTaskId() {
        return this.taskId;
    }

    @Override
    @NotNull
    public GradleExecutionSettings getSettings() {
        return this.settings;
    }

    @Override
    @NotNull
    public ExternalSystemTaskNotificationListener getListener() {
        return this.listener;
    }

    @Override
    @NotNull
    public CancellationToken getCancellationToken() {
        return this.cancellationToken;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.getTaskId().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    @Override
    @NotNull
    public BuildEnvironment getBuildEnvironment() {
        BuildEnvironment buildEnvironment = this._buildEnvironment;
        if (buildEnvironment == null) {
            boolean bl = false;
            String string = "The Gradle Daemon connection wasn't acquired for " + this.getTaskId() + ".\nSee [org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper#execute] from more details.";
            throw new IllegalStateException(string.toString());
        }
        return buildEnvironment;
    }

    public void setBuildEnvironment(@NotNull BuildEnvironment value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._buildEnvironment = value;
    }

    @Override
    @NotNull
    public GradleVersion getGradleVersion() {
        GradleVersion gradleVersion = GradleVersion.version((String)this.getBuildEnvironment().getGradle().getGradleVersion());
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"version(...)");
        return gradleVersion;
    }

    public GradleExecutionContextImpl(@NotNull GradleExecutionContextImpl context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, context.getProjectPath(), new GradleExecutionSettings(context.getSettings()));
    }

    public GradleExecutionContextImpl(@NotNull GradleExecutionContextImpl context, @NotNull String projectPath, @NotNull GradleExecutionSettings settings) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        this(projectPath, context.getTaskId(), settings, context.getListener(), context.getCancellationToken());
        context.copyUserDataTo(this);
        this._buildEnvironment = context._buildEnvironment;
    }
}

