/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.LazyExtension;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorTabColorProvider;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.UniqueNameEditorTabTitleProviderKt;
import com.intellij.openapi.project.DumbKt;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Color;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J#\u0010\u000b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0087@\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\r\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J%\u0010\u000e\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0087@\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorTabPresentationUtil;", "", "<init>", "()V", "getEditorTabTitle", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getEditorTabTitleAsync", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCustomEditorTabTitle", "getCustomEditorTabTitleAsync", "getUniqueEditorTabTitle", "getEditorTabBackgroundColor", "Ljava/awt/Color;", "getFileBackgroundColor", "intellij.platform.ide.core.impl"})
@SourceDebugExtension(value={"SMAP\nEditorTabPresentationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorTabPresentationUtil.kt\ncom/intellij/openapi/fileEditor/impl/EditorTabPresentationUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n23#2:93\n1#3:94\n*S KotlinDebug\n*F\n+ 1 EditorTabPresentationUtil.kt\ncom/intellij/openapi/fileEditor/impl/EditorTabPresentationUtil\n*L\n60#1:93\n*E\n"})
public final class EditorTabPresentationUtil {
    @NotNull
    public static final EditorTabPresentationUtil INSTANCE = new EditorTabPresentationUtil();

    private EditorTabPresentationUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = EditorTabPresentationUtil.getCustomEditorTabTitle(project, file);
        if (string == null && (string = UniqueNameEditorTabTitleProviderKt.doGetUniqueNameEditorTabTitle(project, file)) == null) {
            String string2 = file.getPresentableName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableName(...)");
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @ApiStatus.Experimental
    @Nullable
    public final Object getEditorTabTitleAsync(@NotNull Project project, @NotNull VirtualFile file, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof getEditorTabTitleAsync.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ EditorTabPresentationUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getEditorTabTitleAsync(null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = project;
                $continuation.L$1 = file;
                $continuation.label = 1;
                v0 = this.getCustomEditorTabTitleAsync(project, file, (Continuation<? super String>)$continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                file = (VirtualFile)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                v1 = (String)v0;
                if (v1 != null) {
                    it = v1;
                    $i$a$-let-EditorTabPresentationUtil$getEditorTabTitleAsync$2 = false;
                    return it;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = file;
                $continuation.label = 2;
                v2 = UniqueNameEditorTabTitleProviderKt.getUniqueNameEditorTabTitleAsync(project, file, (Continuation<? super String>)$continuation);
                if (v2 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl41
            }
            case 2: {
                file = (VirtualFile)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl41:
                // 2 sources

                if ((v3 = (String)v2) == null) {
                    v4 = file.getPresentableName();
                    v3 = v4;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getPresentableName(...)");
                }
                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @JvmStatic
    @Nullable
    public static final String getCustomEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        for (EditorTabTitleProvider provider : EditorTabTitleProvider.EP_NAME.lazySequence()) {
            CharSequence charSequence;
            try {
                charSequence = provider.getEditorTabTitle(project, file);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                continue;
            }
            CharSequence result = charSequence;
            if ((charSequence = (CharSequence)result) == null || charSequence.length() == 0) continue;
            return result;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @ApiStatus.Experimental
    @Nullable
    public final Object getCustomEditorTabTitleAsync(@NotNull Project project, @NotNull VirtualFile file, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof getCustomEditorTabTitleAsync.1)) ** GOTO lbl-1000
        var13_4 = $completion;
        if ((var13_4.label & -2147483648) != 0) {
            var13_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ EditorTabPresentationUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getCustomEditorTabTitleAsync(null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_7 = EditorTabTitleProvider.EP_NAME.filterableLazySequence().iterator();
lbl13:
                // 4 sources

                while (var4_7.hasNext()) {
                    extension = (LazyExtension)var4_7.next();
                    if ((EditorTabTitleProvider)extension.getInstance() == null) continue;
                    $continuation.L$0 = project;
                    $continuation.L$1 = file;
                    $continuation.L$2 = var4_7;
                    $continuation.L$3 = extension;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)provider);
                    $continuation.label = 1;
                    v0 = provider.getEditorTabTitleAsync(project, file, (Continuation<? super String>)$continuation);
                    ** if (v0 != var14_6) goto lbl27
lbl26:
                    // 1 sources

                    return var14_6;
lbl27:
                    // 1 sources

                    ** GOTO lbl39
                }
                break;
            }
            case 1: {
                provider = (EditorTabTitleProvider)$continuation.L$4;
                extension = (LazyExtension)$continuation.L$3;
                var4_7 = (Iterator)$continuation.L$2;
                file = (VirtualFile)$continuation.L$1;
                project = (Project)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl39:
                    // 2 sources

                    var8_11 = (String)v0;
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Throwable e) {
                    $this$thisLogger$iv = this;
                    $i$f$thisLogger = false;
                    v1 = Logger.getInstance(EditorTabPresentationUtil.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                    v1.error((Throwable)new PluginException(e, extension.getPluginDescriptor().getPluginId()));
                    ** GOTO lbl13
                }
                result /* !! */  = var8_11;
                if ((var8_11 = (CharSequence)result /* !! */ ) == null || var8_11.length() == 0) ** GOTO lbl13
                return result /* !! */ ;
            }
        }
        return null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @JvmStatic
    @NotNull
    public static final String getUniqueEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String name = EditorTabPresentationUtil.getEditorTabTitle(project, file);
        if (Intrinsics.areEqual((Object)name, (Object)file.getPresentableName())) {
            String string2 = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUniqueVirtualFilePath(...)");
        } else {
            string = name;
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final Color getEditorTabBackgroundColor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ExtensionPointName<EditorTabColorProvider> extensionPointName = EditorTabColorProvider.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"EP_NAME");
        for (EditorTabColorProvider provider : DumbKt.lazyDumbAwareExtensions(extensionPointName, (Project)project)) {
            Color color = provider.getEditorTabColor(project, file);
            if (color == null) continue;
            Color it = color;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @JvmStatic
    @Nullable
    public static final Color getFileBackgroundColor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ExtensionPointName<EditorTabColorProvider> extensionPointName = EditorTabColorProvider.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"EP_NAME");
        for (EditorTabColorProvider provider : DumbKt.lazyDumbAwareExtensions(extensionPointName, (Project)project)) {
            Color color = provider.getProjectViewColor(project, file);
            if (color == null) continue;
            Color it = color;
            boolean bl = false;
            return it;
        }
        return null;
    }
}

