/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiEditorUtilBaseKt;
import com.intellij.psi.util.PsiUtilCore;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/psi/util/PsiEditorUtilBase;", "Lcom/intellij/psi/util/PsiEditorUtil;", "<init>", "()V", "findEditorByPsiElement", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.platform.lang"})
public class PsiEditorUtilBase
implements PsiEditorUtil {
    @Nullable
    public Editor findEditorByPsiElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        if (IntentionPreviewUtils.isPreviewElement((PsiElement)((PsiElement)psiFile))) {
            return IntentionPreviewUtils.getPreviewEditor();
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (virtualFile2.isInLocalFileSystem() || virtualFile2.getFileSystem() instanceof NonPhysicalFileSystem) {
            FileEditor[] fileEditorManager;
            FileEditor[] fileEditorArray = fileEditorManager = FileEditorManager.getInstance((Project)project2);
            if (fileEditorManager == null || (fileEditorArray = fileEditorArray.getEditors(virtualFile2)) == null) {
                fileEditorArray = new FileEditor[]{};
            }
            for (FileEditor editor : fileEditorArray) {
                if (!(editor instanceof TextEditor)) continue;
                return ((TextEditor)editor).getEditor();
            }
        }
        Promise promise = DataManager.getInstance().getDataContextFromFocusAsync();
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getDataContextFromFocusAsync(...)");
        Promise asyncResult = promise;
        if (asyncResult.isSucceeded()) {
            Document cachedDocument;
            Editor editor = null;
            try {
                Object object = asyncResult.blockingGet(-1);
                if (object == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                editor = (Editor)CommonDataKeys.EDITOR.getData((DataContext)object);
            }
            catch (TimeoutException e) {
                PsiEditorUtilBaseKt.access$getLOG().error((Throwable)e);
            }
            catch (ExecutionException e) {
                PsiEditorUtilBaseKt.access$getLOG().error((Throwable)e);
            }
            if (editor != null && (cachedDocument = PsiDocumentManager.getInstance((Project)project2).getCachedDocument(psiFile)) == editor.getDocument()) {
                return editor;
            }
        }
        return null;
    }
}

