/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import org.jetbrains.annotations.NotNull;

public abstract class DelimitedListProcessor {
    private final String myDelimiters;

    public DelimitedListProcessor(String delimiters) {
        this.myDelimiters = delimiters;
    }

    public void processText(@NotNull String text) {
        if (text == null) {
            DelimitedListProcessor.$$$reportNull$$$0(0);
        }
        int pos = 0;
        do {
            int start = pos;
            if ((pos = this.skipDelimiters(text, pos)) == text.length()) {
                this.processToken(start, pos, true);
                break;
            }
            start = pos;
            while (++pos < text.length() && !this.isDelimiter(text.charAt(pos))) {
            }
            this.processToken(start, pos, false);
        } while (++pos < text.length());
    }

    protected abstract void processToken(int var1, int var2, boolean var3);

    protected int skipDelimiters(String s, int pos) {
        char ch;
        while (pos < s.length() && this.isDelimiter(ch = s.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    protected boolean isDelimiter(char ch) {
        return ch < ' ' || this.myDelimiters.indexOf(ch) != -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/DelimitedListProcessor", "processText"));
    }
}

