/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.editor;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.psi.UtilKt;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.properties.ApplicationPropertiesAutoCompletionListProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.ide.documentation.ActionsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootPropertyValueCompletionUtils;
import com.intellij.spring.boot.run.editor.additionalParams.SimpleSpringBootAdditionalParamsTableView;
import com.intellij.spring.boot.run.editor.additionalParams.columns.SimplePropertyNameColumn;
import com.intellij.spring.boot.run.editor.additionalParams.columns.SimplePropertyValueColumn;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SpringBootAdditionalParamsTableView
extends SimpleSpringBootAdditionalParamsTableView
implements UiDataProvider {
    @Nullable
    private Module myModule;
    private List<? extends MetaConfigKey> myKeys;

    public SpringBootAdditionalParamsTableView(@NotNull Project project, @NotNull Disposable parent) {
        if (project == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(1);
        }
        super(project, parent);
        this.myKeys = Collections.emptyList();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        List selectedParams;
        if (sink == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(2);
        }
        String configName = (selectedParams = this.getSelectedObjects()).isEmpty() ? null : ((SpringBootAdditionalParameter)selectedParams.getFirst()).getName();
        sink.set(ActionsKt.DOCUMENTATION_TARGETS, this.getDocumentationTarget(configName));
    }

    @NotNull
    protected ColumnInfo<SpringBootAdditionalParameter, String> getPropertyNameColumn() {
        return new PropertyNameColumn(this.myProject);
    }

    @NotNull
    protected ColumnInfo<SpringBootAdditionalParameter, String> getPropertyValueColumn() {
        return new PropertyValueColumn(this.myProject);
    }

    public void setModule(@Nullable Module module) {
        this.myModule = module;
        if (module == null) {
            this.myKeys = Collections.emptyList();
        } else {
            ReadAction.nonBlocking(() -> SpringBootApplicationMetaConfigKeyManager.getInstance().getAllMetaConfigKeys(module)).finishOnUiThread(ModalityState.any(), keys -> {
                this.myKeys = keys;
            }).coalesceBy(new Object[]{this}).inSmartMode(this.myProject).expireWith(this.myParent).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    private List<Object> getKeyCompletionVariants(@NotNull Module module) {
        if (module == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(3);
        }
        ArrayList<? extends MetaConfigKey> variants = new ArrayList<MetaConfigKey>(this.myKeys);
        for (MetaConfigKey metaConfigKey : this.myKeys) {
            if (!metaConfigKey.isAccessType(MetaConfigKey.AccessType.MAP_GROUP)) continue;
            String prefix = metaConfigKey.getName() + ".";
            PsiElement dummyKeyNode = SpringBootAdditionalParamsTableView.createDummyKeyNode(module, prefix);
            TextRange textRange = TextRange.from((int)prefix.length(), (int)0);
            Object[] references = SpringBootHintReferencesProvider.getInstance().getKeyReferences(metaConfigKey, dummyKeyNode, textRange, new ProcessingContext());
            PsiReference reference = (PsiReference)ArrayUtil.getFirstElement((Object[])references);
            SmartList hints = new SmartList();
            if (reference != null) {
                for (Object variant : reference.getVariants()) {
                    if (!(variant instanceof LookupElement)) continue;
                    hints.add(prefix + ((LookupElement)variant).getLookupString());
                }
            }
            if (hints.isEmpty()) {
                hints.add(prefix);
            }
            variants.remove(metaConfigKey);
            for (String hint : hints) {
                variants.add((MetaConfigKey)metaConfigKey.getPresentation().getLookupElement(hint));
            }
        }
        return variants;
    }

    @Nullable
    private MetaConfigKey findMetaConfigKey(SpringBootAdditionalParameter parameter) {
        return this.findMetaConfigKey(parameter.getName());
    }

    @Nullable
    private MetaConfigKey findMetaConfigKey(String configKey) {
        Module module = this.myModule;
        if (module == null) {
            return null;
        }
        MetaConfigKey exact = (MetaConfigKey)ContainerUtil.find(this.myKeys, SpringBootAdditionalParamsTableView.createNormalAccessTypeMatchingCondition(configKey));
        if (exact != null) {
            return exact;
        }
        MetaConfigKeyManager.ConfigKeyNameBinder binder = SpringBootApplicationMetaConfigKeyManager.getInstance().getConfigKeyNameBinder(module);
        return (MetaConfigKey)ContainerUtil.find(this.myKeys, key -> binder.bindsTo(key, configKey));
    }

    @NotNull
    private static Condition<MetaConfigKey> createNormalAccessTypeMatchingCondition(@NotNull String configKey) {
        if (configKey == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(4);
        }
        Condition condition = key -> key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL}) && Comparing.equal((String)key.getName(), (String)configKey, (boolean)false);
        if (condition == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(5);
        }
        return condition;
    }

    @NotNull
    private static PsiElement createDummyKeyNode(@NotNull Module module, @NotNull String prefix) {
        if (module == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(6);
        }
        if (prefix == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(7);
        }
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)module.getProject()).createFileFromText("application.properties", (FileType)PropertiesFileType.INSTANCE, (CharSequence)prefix);
        dummyFile.putUserData(ModuleUtilCore.KEY_MODULE, (Object)module);
        PropertiesFile propertiesFile = (PropertiesFile)dummyFile;
        IProperty dummyKey = propertiesFile.findPropertyByKey(prefix);
        assert (dummyKey != null);
        PropertyImpl dummyProperty = (PropertyImpl)dummyKey.getPsiElement();
        ASTNode keyNode = dummyProperty.getKeyNode();
        assert (keyNode != null);
        PsiElement psiElement = keyNode.getPsi();
        if (psiElement == null) {
            SpringBootAdditionalParamsTableView.$$$reportNull$$$0(8);
        }
        return psiElement;
    }

    private List<DocumentationTarget> getDocumentationTarget(@Nullable String configKey) {
        MetaConfigKey key;
        Module module = this.myModule;
        MetaConfigKey metaConfigKey = key = module == null || configKey == null ? null : this.findMetaConfigKey(configKey);
        if (key == null) {
            PsiFile psiFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText((Language)PlainTextLanguage.INSTANCE, (CharSequence)"");
            return UtilKt.psiDocumentationTargets((PsiElement)psiFile, null);
        }
        PsiElement propertyElement = SpringBootAdditionalParamsTableView.createDummyKeyNode(module, key.getName()).getParent();
        propertyElement.getContainingFile().putUserData(SpringBootApplicationMetaConfigKeyManager.ELEMENT_IN_EXTERNAL_CONTEXT, (Object)Boolean.TRUE);
        return UtilKt.psiDocumentationTargets((PsiElement)propertyElement, (PsiElement)propertyElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNormalAccessTypeMatchingCondition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyKeyNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getKeyCompletionVariants";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNormalAccessTypeMatchingCondition";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDummyKeyNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8 -> new IllegalStateException(string);
        };
    }

    private class PropertyNameColumn
    extends SimplePropertyNameColumn {
        private PropertyNameColumn(Project project) {
            super(project);
        }

        public TableCellEditor getEditor(SpringBootAdditionalParameter parameter) {
            if (SpringBootAdditionalParamsTableView.this.myModule == null || DumbService.isDumb((Project)SpringBootAdditionalParamsTableView.this.myModule.getProject())) {
                return super.getEditor(parameter);
            }
            return new MySpringBootNameTableCellEditor(SpringBootAdditionalParamsTableView.this.myModule);
        }

        public TableCellRenderer getCustomizedRenderer(SpringBootAdditionalParameter o, TableCellRenderer renderer) {
            Shortcut[] quickDocShortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"QuickJavaDoc").getShortcuts();
            String quickDocShortcutText = quickDocShortcuts.length == 0 ? null : "Full documentation available (" + KeymapUtil.getShortcutText((Shortcut)quickDocShortcuts[0]) + ")";
            MetaConfigKey key = SpringBootAdditionalParamsTableView.this.findMetaConfigKey(o);
            if (key != null) {
                @NlsSafe Object toolTipText = key.getDescriptionText().getFullText();
                if (quickDocShortcutText != null) {
                    toolTipText = !((String)toolTipText).isEmpty() ? (String)toolTipText + "\n\n" + quickDocShortcutText : quickDocShortcutText;
                }
                ((JComponent)((Object)renderer)).setToolTipText((String)toolTipText);
            }
            return renderer;
        }
    }

    private class PropertyValueColumn
    extends SimplePropertyValueColumn {
        private PropertyValueColumn(Project project) {
            super(project);
        }

        public TableCellEditor getEditor(SpringBootAdditionalParameter parameter) {
            MetaConfigKey key = SpringBootAdditionalParamsTableView.this.findMetaConfigKey(parameter);
            if (key == null) {
                return SimpleSpringBootAdditionalParamsTableView.createDefaultParameterEditor((Project)this.myProject, (String)parameter.getValue());
            }
            return this.createValueTableCellEditor(parameter, key);
        }

        @NotNull
        private TableCellEditor createValueTableCellEditor(SpringBootAdditionalParameter parameter, MetaConfigKey key) {
            assert (SpringBootAdditionalParamsTableView.this.myModule != null);
            ApplicationPropertiesAutoCompletionListProvider provider = new ApplicationPropertiesAutoCompletionListProvider(Collections.emptyList());
            String keyText = parameter.getName();
            Module module = SpringBootAdditionalParamsTableView.this.myModule;
            ReadAction.nonBlocking(() -> SpringBootPropertyValueCompletionUtils.getValueCompletionVariants(key, module, keyText)).finishOnUiThread(ModalityState.any(), variants -> provider.setItems((Collection)variants)).coalesceBy(new Object[]{this}).inSmartMode(this.myProject).expireWith(SpringBootAdditionalParamsTableView.this.myParent).submit((Executor)AppExecutorUtil.getAppExecutorService());
            final TextFieldWithAutoCompletion field = new TextFieldWithAutoCompletion(SpringBootAdditionalParamsTableView.this.myModule.getProject(), (TextFieldWithAutoCompletionListProvider)provider, true, parameter.getValue());
            return new AbstractTableCellEditor(){

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    return field;
                }

                public Object getCellEditorValue() {
                    return field.getText();
                }
            };
        }
    }

    private class MySpringBootNameTableCellEditor
    extends AbstractTableCellEditor {
        private final TextFieldWithAutoCompletion<Object> myTextField;

        MySpringBootNameTableCellEditor(Module module) {
            if (module == null) {
                MySpringBootNameTableCellEditor.$$$reportNull$$$0(0);
            }
            ApplicationPropertiesAutoCompletionListProvider provider = new ApplicationPropertiesAutoCompletionListProvider(Collections.emptyList());
            ReadAction.nonBlocking(() -> SpringBootAdditionalParamsTableView.this.getKeyCompletionVariants(module)).finishOnUiThread(ModalityState.any(), variants -> provider.setItems((Collection)variants)).coalesceBy(new Object[]{this}).inSmartMode(SpringBootAdditionalParamsTableView.this.myProject).expireWith(SpringBootAdditionalParamsTableView.this.myParent).submit((Executor)AppExecutorUtil.getAppExecutorService());
            this.myTextField = new TextFieldWithAutoCompletion<Object>(module.getProject(), (TextFieldWithAutoCompletionListProvider)provider, true, null){

                public void uiDataSnapshot(@NotNull DataSink sink) {
                    if (sink == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.uiDataSnapshot(sink);
                    String configKey = MySpringBootNameTableCellEditor.this.myTextField.getText();
                    sink.lazy(ActionsKt.DOCUMENTATION_TARGETS, () -> SpringBootAdditionalParamsTableView.this.getDocumentationTarget(configKey));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView$MySpringBootNameTableCellEditor$1", "uiDataSnapshot"));
                }
            };
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.myTextField.setText((String)value);
            return this.myTextField;
        }

        public Object getCellEditorValue() {
            return this.myTextField.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/run/editor/SpringBootAdditionalParamsTableView$MySpringBootNameTableCellEditor", "<init>"));
        }
    }
}

