/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.configuration;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.profiles.SpringProfileTarget;
import org.jetbrains.annotations.NotNull;

class SpringBootProfileRefactoringListener
implements RefactoringElementListener {
    private final String myProfile;
    private final SpringBootApplicationRunConfiguration myConfiguration;

    SpringBootProfileRefactoringListener(SpringBootApplicationRunConfiguration configuration, String profile) {
        this.myProfile = profile;
        this.myConfiguration = configuration;
    }

    public void elementMoved(@NotNull PsiElement newElement) {
        if (newElement == null) {
            SpringBootProfileRefactoringListener.$$$reportNull$$$0(0);
        }
    }

    public void elementRenamed(@NotNull PsiElement newElement) {
        String newName;
        if (newElement == null) {
            SpringBootProfileRefactoringListener.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmptyOrSpaces((String)(newName = SpringBootProfileRefactoringListener.getProfileName(newElement)))) {
            return;
        }
        String profiles = this.myConfiguration.getActiveProfiles();
        StringBuilder result = new StringBuilder();
        int partStart = 0;
        while (partStart < profiles.length()) {
            String part;
            int partEnd = profiles.indexOf(44, partStart);
            if (partEnd < 0) {
                partEnd = profiles.length();
            }
            if ((part = profiles.substring(partStart, partEnd)).trim().equals(this.myProfile)) {
                result.append(part.replace(this.myProfile, newName));
            } else {
                result.append(part);
            }
            if (partEnd != profiles.length()) {
                result.append(',');
            }
            partStart = partEnd + 1;
        }
        this.myConfiguration.setActiveProfiles(result.toString());
    }

    static String getProfileName(PsiElement psiElement) {
        if (!(psiElement instanceof PomTargetPsiElement)) {
            return null;
        }
        PomTarget target = ((PomTargetPsiElement)psiElement).getTarget();
        if (!(target instanceof SpringProfileTarget)) {
            return null;
        }
        return ((SpringProfileTarget)target).getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "newElement";
        objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/configuration/SpringBootProfileRefactoringListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "elementMoved";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "elementRenamed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

