/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.appearance;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.executor.JupyterExecutionManagerExtensionsKt;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterTaskPriority;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSessionId;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.colorThemes.JupyterThemeChangedEvent;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.colorThemes.ThemeChangedListener;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.kotlin.jupyter.core.util.ColorSchemeChangeKt;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.libraries.ColorScheme;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R9\u0010\u0004\u001a-\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/appearance/KotlinNotebookEditorColorsListener;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/colorThemes/ThemeChangedListener;", "<init>", "()V", "sessionToTheme", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSessionId;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/ColorScheme;", "themeChanged", "", "event", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/colorThemes/JupyterThemeChangedEvent;", "(Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/colorThemes/JupyterThemeChangedEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getActualTheme", "session", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookEditorColorsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookEditorColorsListener.kt\ncom/intellij/kotlin/jupyter/core/editor/appearance/KotlinNotebookEditorColorsListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,68:1\n1#2:69\n1#2:72\n72#3,2:70\n13#4:73\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookEditorColorsListener.kt\ncom/intellij/kotlin/jupyter/core/editor/appearance/KotlinNotebookEditorColorsListener\n*L\n48#1:72\n48#1:70,2\n65#1:73\n*E\n"})
public final class KotlinNotebookEditorColorsListener
implements ThemeChangedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<JupyterNotebookSessionId, AtomicReference<ColorScheme>> sessionToTheme;
    @NotNull
    private static final Logger LOG;

    public KotlinNotebookEditorColorsListener() {
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.sessionToTheme = concurrentMap;
    }

    @Nullable
    public Object themeChanged(@NotNull JupyterThemeChangedEvent event, @NotNull Continuation<? super Unit> $completion) {
        String string;
        JupyterNotebookSession jupyterNotebookSession = event.getSession();
        if (jupyterNotebookSession == null) {
            return Unit.INSTANCE;
        }
        JupyterNotebookSession session = jupyterNotebookSession;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)event.getEditor());
        if (backedNotebookVirtualFile == null) {
            return Unit.INSTANCE;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        Editor editor = event.getEditor();
        Project project = editor.getProject();
        if (project == null) {
            return Unit.INSTANCE;
        }
        Project project2 = project;
        if (project2.isDisposed()) {
            return Unit.INSTANCE;
        }
        if (!IsKotlinNotebookKt.isKotlinNotebookSession(session)) {
            return Unit.INSTANCE;
        }
        ColorScheme colorScheme = this.getActualTheme(session);
        if (colorScheme == null) {
            return Unit.INSTANCE;
        }
        ColorScheme theme = colorScheme;
        String it = string = ColorSchemeChangeKt.generateColorSchemeChangeCode(theme);
        boolean bl = false;
        String string2 = !StringsKt.isBlank((CharSequence)it) ? string : null;
        if (string2 == null) {
            return Unit.INSTANCE;
        }
        String changeCode = string2;
        Object object = JupyterExecutionManagerExtensionsKt.submitSilentTask-FHKeTTw$default((JupyterExecutionManager)JupyterExecutionManager.Companion.getInstance(project2, notebookFile), (String)changeCode, (JupyterTaskPriority)JupyterTaskPriority.Companion.getHIGH(), null, null, $completion, (int)12, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final ColorScheme getActualTheme(JupyterNotebookSession session) {
        ColorScheme colorScheme;
        ColorScheme current;
        ColorScheme previous;
        void $this$getOrPut$iv;
        String id = session.getSessionId-PaPw8_s();
        ConcurrentMap<JupyterNotebookSessionId, AtomicReference<ColorScheme>> concurrentMap = this.sessionToTheme;
        JupyterNotebookSessionId key$iv = JupyterNotebookSessionId.box-impl((String)id);
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            Disposer.register((Disposable)((Disposable)session), () -> KotlinNotebookEditorColorsListener.getActualTheme$lambda$0$0(this, id));
            AtomicReference<Object> default$iv = new AtomicReference<Object>(null);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        AtomicReference theme = (AtomicReference)object;
        while (!theme.compareAndSet(previous = (ColorScheme)((Object)theme.get()), current = ColorSchemeChangeKt.getNotebookTheme())) {
        }
        ColorScheme it = colorScheme = current;
        boolean bl = false;
        return it != previous ? colorScheme : null;
    }

    private static final void getActualTheme$lambda$0$0(KotlinNotebookEditorColorsListener this$0, String $id) {
        this$0.sessionToTheme.remove(JupyterNotebookSessionId.box-impl((String)$id));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KotlinNotebookEditorColorsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/appearance/KotlinNotebookEditorColorsListener$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

