/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.ws;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.protocol.api.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;
import org.jetbrains.kotlinx.jupyter.ws.WsMessageHandler;
import org.slf4j.Logger;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J*\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\"H\u0016J\u0018\u0010%\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'H\u0016J\"\u0010(\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u000e\u0010)\u001a\n\u0018\u00010*j\u0004\u0018\u0001`+H\u0016J\b\u0010,\u001a\u00020\nH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013 \u0014*\u0012\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlinx/jupyter/ws/JupyterWsServer;", "Lorg/java_websocket/server/WebSocketServer;", "address", "Ljava/net/InetSocketAddress;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;", "onMessageReceive", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/JupyterSocketType;", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "", "<init>", "(Ljava/net/InetSocketAddress;Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;Lkotlin/jvm/functions/Function2;)V", "logger", "Lorg/slf4j/Logger;", "messageHandler", "Lorg/jetbrains/kotlinx/jupyter/ws/WsMessageHandler;", "_currentWebSockets", "", "Lorg/java_websocket/WebSocket;", "kotlin.jvm.PlatformType", "", "currentWebSockets", "", "getCurrentWebSockets", "()Ljava/lang/Iterable;", "onOpen", "conn", "handshake", "Lorg/java_websocket/handshake/ClientHandshake;", "onClose", "code", "", "reason", "", "remote", "", "onMessage", "message", "Ljava/nio/ByteBuffer;", "onError", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onStart", "ws-server"})
final class JupyterWsServer
extends WebSocketServer {
    @NotNull
    private final Logger logger;
    @NotNull
    private final WsMessageHandler messageHandler;
    private final Set<WebSocket> _currentWebSockets;

    public JupyterWsServer(@Nullable InetSocketAddress address, @NotNull KernelLoggerFactory loggerFactory, @NotNull Function2<? super JupyterSocketType, ? super RawMessage, Unit> onMessageReceive) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter(onMessageReceive, (String)"onMessageReceive");
        super(address);
        this.logger = KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)loggerFactory, (KClass)Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()));
        this.messageHandler = new WsMessageHandler(this.logger, onMessageReceive);
        this._currentWebSockets = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @NotNull
    public final Iterable<WebSocket> getCurrentWebSockets() {
        Set<WebSocket> set = this._currentWebSockets;
        Intrinsics.checkNotNullExpressionValue(set, (String)"_currentWebSockets");
        return set;
    }

    public void onOpen(@NotNull WebSocket conn, @NotNull ClientHandshake handshake) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)handshake, (String)"handshake");
        this._currentWebSockets.add(conn);
    }

    public void onClose(@NotNull WebSocket conn, int code, @Nullable String reason, boolean remote) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        this._currentWebSockets.remove(conn);
    }

    public void onMessage(@NotNull WebSocket conn, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.messageHandler.onMessage(message);
    }

    public void onMessage(@NotNull WebSocket conn, @NotNull ByteBuffer message) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.messageHandler.onMessage(message);
    }

    public void onError(@Nullable WebSocket conn, @Nullable Exception ex) {
        this.logger.error("Error in WebSocket connection", (Throwable)ex);
    }

    public void onStart() {
    }
}

