/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ParametersConnection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.login.LoginPerformerImpl;
import org.jetbrains.idea.perforce.perforce.login.LoginState;
import org.jetbrains.idea.perforce.perforce.login.LoginSupport;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/perforce/perforce/connections/TestLoginManager;", "Lorg/jetbrains/idea/perforce/perforce/login/LoginSupport;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lorg/jetbrains/idea/perforce/perforce/PerforceSettings;", "connectionManager", "Lorg/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManagerI;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/idea/perforce/perforce/PerforceSettings;Lorg/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManagerI;)V", "silentLogin", "", "connection", "Lorg/jetbrains/idea/perforce/perforce/connections/P4Connection;", "notLogged", "", "intellij.vcs.perforce"})
public final class TestLoginManager
implements LoginSupport {
    @NotNull
    private final Project project;
    @NotNull
    private final PerforceSettings settings;
    @NotNull
    private final PerforceConnectionManagerI connectionManager;

    public TestLoginManager(@NotNull Project project, @NotNull PerforceSettings settings, @NotNull PerforceConnectionManagerI connectionManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
        this.project = project;
        this.settings = settings;
        this.connectionManager = connectionManager;
    }

    @Override
    public boolean silentLogin(@NotNull P4Connection connection) throws VcsException {
        LoginState login;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        String password = connection instanceof P4ParametersConnection ? ((P4ParametersConnection)connection).getParameters().getPassword() : this.settings.getPasswd();
        LoginPerformerImpl loginPerformer = new LoginPerformerImpl(this.project, connection, this.connectionManager);
        if (password != null && loginPerformer.login(password).isSuccess()) {
            return true;
        }
        do {
            if ((password = this.settings.requestForPassword(this.settings.useP4CONFIG ? connection : null)) != null) continue;
            return false;
        } while (!(login = loginPerformer.login(password)).isSuccess());
        PerforceConnectionManager.getInstance(this.project).updateConnections();
        return true;
    }

    @Override
    public void notLogged(@NotNull P4Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
    }
}

