/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlAccessor;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.ConfigurationValueSearchParams;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

final class SpringBootYamlScanner {
    private final MetaConfigKeyManager.ConfigKeyNameBinder binder;
    private final boolean enableBooleanVersion2_2;

    public SpringBootYamlScanner(MetaConfigKeyManager.ConfigKeyNameBinder binder, boolean enableBooleanVersion2_2) {
        this.binder = binder;
        this.enableBooleanVersion2_2 = enableBooleanVersion2_2;
    }

    public List<Pair<String, Integer>> collectImports(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            SpringBootYamlScanner.$$$reportNull$$$0(0);
        }
        SmartList results = new SmartList();
        Project project = psiFile.getProject();
        YAMLFile yamlFile = (YAMLFile)psiFile;
        MetaConfigKey configKey = SpringBootApplicationMetaConfigKeyManager.getInstance().createFakeConfigKey(project, "spring.config.import", MetaConfigKey.AccessType.NORMAL);
        List documents = yamlFile.getDocuments();
        if (!documents.isEmpty()) {
            for (int documentId = documents.size() - 1; documentId >= 0; --documentId) {
                YAMLDocument document = (YAMLDocument)documents.get(documentId);
                this.processDocument(document, documentId, null, configKey, null, null, false, true, arg_0 -> SpringBootYamlScanner.lambda$collectImports$0((List)results, arg_0));
            }
        }
        return results;
    }

    public boolean processDocument(@NotNull YAMLDocument document, int documentId, @Nullable String profileText, ConfigurationValueSearchParams params, Consumer<ConfigurationValueResult> results) {
        boolean multipleOccurrencesPossible;
        if (document == null) {
            SpringBootYamlScanner.$$$reportNull$$$0(1);
        }
        boolean processParts = (multipleOccurrencesPossible = params.getConfigKey().isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.ENUM_MAP, MetaConfigKey.AccessType.MAP, MetaConfigKey.AccessType.INDEXED})) && (params.getKeyIndex() != null || params.getKeyProperty() != null);
        return this.processDocument(document, documentId, profileText, params.getConfigKey(), params.getKeyIndex(), params.getKeyProperty(), processParts, params.getCheckRelaxedNames(), results);
    }

    private boolean processDocument(@NotNull YAMLDocument document, int documentId, @Nullable String profileText, MetaConfigKey configKey, String keyIndex, String keyProperty, boolean processParts, boolean checkRelaxedNames, Consumer<ConfigurationValueResult> results) {
        if (document == null) {
            SpringBootYamlScanner.$$$reportNull$$$0(2);
        }
        String keyName = configKey.getName();
        Processor processor = keyValue -> {
            ProgressManager.checkCanceled();
            String qualifiedKeyName = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)keyValue);
            if (qualifiedKeyName.equals(keyName)) {
                if (processParts) {
                    if (configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED})) {
                        return this.processIndexedKeyValue(configKey, keyIndex, keyProperty, (YAMLKeyValue)keyValue, documentId, profileText, results);
                    }
                    return true;
                }
                this.processYamlKeyValue(configKey, keyProperty, results, (YAMLKeyValue)keyValue, null, documentId, profileText);
                return false;
            }
            if (!checkRelaxedNames && !qualifiedKeyName.startsWith(keyName)) {
                return true;
            }
            if (processParts) {
                String keyIndexText = this.binder.bindsToKeyProperty(configKey, keyProperty, qualifiedKeyName);
                if (keyIndexText != null && (StringUtil.isEmpty((String)keyIndex) || keyIndexText.equals(keyIndex))) {
                    this.processYamlKeyValue(configKey, keyProperty, results, (YAMLKeyValue)keyValue, keyIndexText, documentId, profileText);
                    return true;
                }
            } else if (this.binder.bindsTo(configKey, qualifiedKeyName)) {
                this.processYamlKeyValue(configKey, keyProperty, results, (YAMLKeyValue)keyValue, null, documentId, profileText);
                return false;
            }
            return true;
        };
        return ConfigYamlAccessor.processAllKeys((YAMLPsiElement)document, (Processor)processor, (boolean)true);
    }

    private static PsiType getBeanPropertyValueType(YAMLKeyValue yamlKeyValue) {
        ConfigKeyPathReference configKeyPathReference = ConfigYamlUtils.getLastConfigKeyPathReference((YAMLKeyValue)yamlKeyValue);
        return configKeyPathReference != null ? configKeyPathReference.getValueElementType() : null;
    }

    private void processYamlKeyValue(MetaConfigKey configKey, String keyProperty, Consumer<ConfigurationValueResult> results, YAMLKeyValue yamlKeyValue, String keyIndexText, int documentId, @Nullable String profileText) {
        PsiElement keyElement = yamlKeyValue.getKey();
        if (keyElement == null) {
            return;
        }
        YAMLValue valueElement = yamlKeyValue.getValue();
        if (valueElement instanceof YAMLSequence) {
            YAMLSequence sequence = (YAMLSequence)valueElement;
            for (YAMLSequenceItem item : ContainerUtil.reverse((List)sequence.getItems())) {
                YAMLValue itemValue = item.getValue();
                String valueText = itemValue instanceof YAMLScalar ? ((YAMLScalar)itemValue).getTextValue() : "";
                results.accept(new YamlConfigurationValueResult(yamlKeyValue, keyElement, keyIndexText, (PsiElement)itemValue, valueText, documentId, configKey, keyProperty, this.enableBooleanVersion2_2, profileText));
            }
            return;
        }
        if (valueElement instanceof YAMLMapping) {
            YAMLMapping mapping = (YAMLMapping)valueElement;
            for (YAMLKeyValue mapKeyValue : ContainerUtil.reverse(new ArrayList(mapping.getKeyValues()))) {
                if (mapKeyValue.getKey() == null) continue;
                results.accept(new YamlConfigurationValueResult(mapKeyValue, mapKeyValue.getKey(), keyIndexText, (PsiElement)mapKeyValue.getValue(), mapKeyValue.getValueText(), documentId, configKey, keyProperty, this.enableBooleanVersion2_2, profileText));
            }
            return;
        }
        results.accept(new YamlConfigurationValueResult(yamlKeyValue, keyElement, keyIndexText, (PsiElement)valueElement, yamlKeyValue.getValueText(), documentId, configKey, keyProperty, this.enableBooleanVersion2_2, profileText));
    }

    private boolean processIndexedKeyValue(MetaConfigKey configKey, String keyIndex, String keyProperty, YAMLKeyValue yamlKeyValue, int documentId, @Nullable String profileText, Consumer<ConfigurationValueResult> results) {
        PsiElement keyElement = yamlKeyValue.getKey();
        if (keyElement == null) {
            return true;
        }
        if (keyIndex == null || keyProperty != null) {
            return true;
        }
        YAMLValue valueElement = yamlKeyValue.getValue();
        if (valueElement instanceof YAMLScalar) {
            this.processYamlKeyValue(configKey, keyProperty, results, yamlKeyValue, null, documentId, profileText);
            return false;
        }
        if (!(valueElement instanceof YAMLSequence)) {
            return true;
        }
        YAMLSequence sequence = (YAMLSequence)valueElement;
        try {
            List values;
            if (StringUtil.isEmpty((String)keyIndex)) {
                values = ContainerUtil.mapNotNull((Collection)sequence.getItems(), item -> {
                    YAMLValue value = item.getValue();
                    return value instanceof YAMLScalar ? value : null;
                });
            } else {
                int index = Integer.parseInt(keyIndex);
                List items = sequence.getItems();
                if (index < 0 || index >= items.size()) {
                    return true;
                }
                YAMLSequenceItem item2 = (YAMLSequenceItem)items.get(index);
                YAMLValue value = item2.getValue();
                if (!(value instanceof YAMLScalar)) {
                    return true;
                }
                values = new SmartList((Object)value);
            }
            for (YAMLValue value : values) {
                results.accept(new YamlConfigurationValueResult(yamlKeyValue, keyElement, keyIndex, (PsiElement)value, value.getText(), documentId, configKey, keyProperty, this.enableBooleanVersion2_2, profileText));
            }
            return false;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    private static /* synthetic */ void lambda$collectImports$0(List results, ConfigurationValueResult item) {
        results.add(new Pair((Object)item.getValueText(), (Object)item.getDocumentId()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootYamlScanner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectImports";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processDocument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class YamlConfigurationValueResult
    extends ConfigurationValueResult {
        @NotNull
        private final YAMLKeyValue myValue;

        YamlConfigurationValueResult(@NotNull YAMLKeyValue yamlKeyValue, @NotNull PsiElement keyElement, @Nullable String keyIndexText, @Nullable PsiElement valueElement, @Nullable String valueText, int documentId, MetaConfigKey configKey, String keyProperty, boolean enableBooleanVersion2_2, @Nullable String profileText) {
            if (yamlKeyValue == null) {
                YamlConfigurationValueResult.$$$reportNull$$$0(0);
            }
            if (keyElement == null) {
                YamlConfigurationValueResult.$$$reportNull$$$0(1);
            }
            super(keyElement, keyIndexText, valueElement, YamlConfigurationValueResult.convertValue(yamlKeyValue, valueText, configKey, keyProperty, enableBooleanVersion2_2), documentId, configKey, profileText);
            this.myValue = yamlKeyValue;
        }

        @NotNull
        public MetaConfigKeyReference<?> getMetaConfigKeyReference() {
            MetaConfigKeyReference metaConfigKeyReference = (MetaConfigKeyReference)ContainerUtil.findInstance((Object[])this.myValue.getReferences(), MetaConfigKeyReference.class);
            if (metaConfigKeyReference == null) {
                String referencesText = StringUtil.join((Collection)ContainerUtil.map((Object[])this.myValue.getReferences(), ref -> ref.getClass().getName()), (String)"|");
                throw new IllegalStateException(String.valueOf(this.myValue.getClass()) + " - " + this.myValue.getText() + " - " + referencesText);
            }
            MetaConfigKeyReference metaConfigKeyReference2 = metaConfigKeyReference;
            if (metaConfigKeyReference2 == null) {
                YamlConfigurationValueResult.$$$reportNull$$$0(2);
            }
            return metaConfigKeyReference2;
        }

        private static String convertValue(YAMLKeyValue yamlKeyValue, String valueText, MetaConfigKey configKey, String keyProperty, boolean enableBooleanVersion2_2) {
            String sanitizedValue = ConfigYamlUtils.sanitizeNumberValueIfNeeded((String)valueText, () -> YamlConfigurationValueResult.getEffectiveValueType(yamlKeyValue, configKey, keyProperty));
            if (sanitizedValue != null) {
                return sanitizedValue;
            }
            if (StringUtil.isEmpty((String)valueText)) {
                return valueText;
            }
            char first = valueText.charAt(0);
            if (first != 'o' && first != 'O') {
                return valueText;
            }
            String aliasOf = null;
            if (StringUtil.equalsIgnoreCase((CharSequence)valueText, (CharSequence)"on")) {
                aliasOf = "true";
            } else if (StringUtil.equalsIgnoreCase((CharSequence)valueText, (CharSequence)"off")) {
                aliasOf = "false";
            }
            if (aliasOf == null) {
                return valueText;
            }
            if (!enableBooleanVersion2_2) {
                return valueText;
            }
            PsiClass typeClass = PsiTypesUtil.getPsiClass((PsiType)YamlConfigurationValueResult.getEffectiveValueType(yamlKeyValue, configKey, keyProperty));
            String typeName = typeClass == null ? null : typeClass.getQualifiedName();
            return "java.lang.Boolean".equals(typeName) ? aliasOf : valueText;
        }

        private static PsiType getEffectiveValueType(YAMLKeyValue yamlKeyValue, MetaConfigKey configKey, String keyProperty) {
            PsiType valueType;
            boolean useEffectiveValueElementType;
            boolean bl = useEffectiveValueElementType = configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL}) || configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED}) && keyProperty == null;
            if (!useEffectiveValueElementType && (valueType = SpringBootYamlScanner.getBeanPropertyValueType(yamlKeyValue)) != null) {
                return valueType;
            }
            return configKey.getEffectiveValueElementType();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "yamlKeyValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/application/yaml/SpringBootYamlScanner$YamlConfigurationValueResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootYamlScanner$YamlConfigurationValueResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaConfigKeyReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

