/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.platform.compat;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.IdePlatform;
import org.jetbrains.kotlin.platform.JsPlatform;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.WasmPlatform;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.NativeIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.WasmIdePlatformKind;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.platform.jvm.JdkPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.platform.konan.NativePlatform;
import org.jetbrains.kotlin.platform.konan.NativePlatforms;
import org.jetbrains.kotlin.platform.wasm.WasmPlatforms;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0002\u001a\u00060\u0001j\u0002`\u0003*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u001a\u0016\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004*\u00060\u0001j\u0002`\u0003*\n\u0010\u0000\"\u00020\u00012\u00020\u0001\u00a8\u0006\u0006"}, d2={"NewPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "toNewPlatform", "Lorg/jetbrains/kotlin/platform/compat/NewPlatform;", "Lorg/jetbrains/kotlin/platform/IdePlatform;", "toIdePlatform", "jps-common"})
public final class CompatConversionsKt {
    @NotNull
    public static final TargetPlatform toNewPlatform(@NotNull IdePlatform<?, ?> $this$toNewPlatform) {
        TargetPlatform targetPlatform;
        Intrinsics.checkNotNullParameter($this$toNewPlatform, (String)"<this>");
        IdePlatform<?, ?> idePlatform = $this$toNewPlatform;
        if (idePlatform instanceof CommonIdePlatformKind.Platform) {
            targetPlatform = CommonPlatforms.INSTANCE.getDefaultCommonPlatform();
        } else if (idePlatform instanceof JvmIdePlatformKind.Platform) {
            targetPlatform = JvmPlatforms.INSTANCE.jvmPlatformByTargetVersion(((JvmIdePlatformKind.Platform)$this$toNewPlatform).getVersion());
        } else if (idePlatform instanceof JsIdePlatformKind.Platform) {
            targetPlatform = JsPlatforms.INSTANCE.getDefaultJsPlatform();
        } else if (idePlatform instanceof WasmIdePlatformKind.Platform) {
            targetPlatform = WasmPlatforms.INSTANCE.getWasmJs();
        } else if (idePlatform instanceof NativeIdePlatformKind.Platform) {
            targetPlatform = NativePlatforms.INSTANCE.getUnspecifiedNativePlatform();
        } else {
            throw new IllegalStateException(("Unknown platform " + $this$toNewPlatform).toString());
        }
        return targetPlatform;
    }

    @NotNull
    public static final IdePlatform<?, ?> toIdePlatform(@NotNull TargetPlatform $this$toIdePlatform) {
        IdePlatform idePlatform;
        Intrinsics.checkNotNullParameter((Object)$this$toIdePlatform, (String)"<this>");
        SimplePlatform single = (SimplePlatform)CollectionsKt.singleOrNull((Iterable)((Iterable)$this$toIdePlatform));
        if (single == null) {
            idePlatform = CommonIdePlatformKind.Platform.INSTANCE;
        } else if (single instanceof JdkPlatform) {
            idePlatform = new JvmIdePlatformKind.Platform(((JdkPlatform)single).getTargetVersion());
        } else if (single instanceof JvmPlatform) {
            idePlatform = new JvmIdePlatformKind.Platform(JvmTarget.DEFAULT);
        } else if (single instanceof JsPlatform) {
            idePlatform = JsIdePlatformKind.Platform.INSTANCE;
        } else if (single instanceof WasmPlatform) {
            idePlatform = WasmIdePlatformKind.Platform.INSTANCE;
        } else if (single instanceof NativePlatform) {
            idePlatform = NativeIdePlatformKind.Platform.INSTANCE;
        } else {
            throw new IllegalStateException(("Unknown platform " + single).toString());
        }
        return idePlatform;
    }
}

