/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.QsConfigValueSearcher;
import com.intellij.quarkus.config.profiles.QsProfileTarget;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\b&\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\fH&J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\u000b\u001a\u00020\fH&J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001a0\u0019H&J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0015J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0015H\u0002J8\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001c0&2\u0006\u0010\"\u001a\u00020\u00152\u0010\b\u0002\u0010'\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001e0&H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006)"}, d2={"Lcom/intellij/quarkus/config/QsConfigFileContributor;", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "<init>", "(Lcom/intellij/openapi/fileTypes/FileType;)V", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "findKeys", "", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "key", "", "getKeyVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getProfiles", "Lcom/intellij/quarkus/config/profiles/QsProfileTarget;", "processConfigValues", "", "params", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueResult;", "findConfigFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "includeTests", "getConfigFileSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "testScope", "collectConfigDirectories", "", "configDirectories", "", "visitedModules", "Companion", "intellij.quarkus"})
public abstract class QsConfigFileContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileType fileType;
    @NotNull
    private static final ExtensionPointName<QsConfigFileContributor> EP_NAME = ExtensionPointName.Companion.create("com.intellij.quarkus.configFileContributor");

    public QsConfigFileContributor(@NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        this.fileType = fileType;
    }

    @NotNull
    public final FileType getFileType() {
        return this.fileType;
    }

    @NotNull
    public abstract List<PsiElement> findKeys(@NotNull PsiFile var1, @NotNull String var2);

    @NotNull
    public abstract Collection<LookupElement> getKeyVariants(@NotNull PsiFile var1);

    @NotNull
    public abstract Collection<QsProfileTarget> getProfiles(@NotNull PsiFile var1);

    public abstract boolean processConfigValues(@NotNull QsConfigValueSearcher.QsConfigValueSearchParams var1, @NotNull Processor<? super QsConfigValueSearcher.QsConfigValueResult> var2);

    @NotNull
    public final List<VirtualFile> findConfigFiles(@NotNull Module module, boolean includeTests) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        GlobalSearchScope globalSearchScope = this.getConfigFileSearchScope(module, includeTests);
        if (globalSearchScope == null) {
            return CollectionsKt.emptyList();
        }
        GlobalSearchScope configFileSearchScope = globalSearchScope;
        SmartList result = new SmartList();
        CommonProcessors.CollectProcessor<VirtualFile> processor2 = new CommonProcessors.CollectProcessor<VirtualFile>((SmartList<VirtualFile>)result){

            protected boolean accept(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ProgressManager.checkCanceled();
                String string = file.getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
                return QsConfigUtils.INSTANCE.isConfigFileName(string);
            }
        };
        FileTypeIndex.processFiles((FileType)this.fileType, (Processor)((Processor)processor2), (GlobalSearchScope)configFileSearchScope);
        return (List)result;
    }

    private final GlobalSearchScope getConfigFileSearchScope(Module module, boolean testScope) {
        GlobalSearchScope globalSearchScope;
        if (module.isDisposed()) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return module.getModuleScope(testScope);
        }
        LinkedHashSet configDirectories = new LinkedHashSet();
        QsConfigFileContributor.collectConfigDirectories$default(this, module, configDirectories, testScope, null, 8, null);
        if (configDirectories.isEmpty()) {
            globalSearchScope = null;
        } else {
            VirtualFile[] virtualFileArray = configDirectories.toArray(VirtualFile.EMPTY_ARRAY);
            globalSearchScope = GlobalSearchScopesCore.directoriesScope((Project)module.getProject(), (boolean)false, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        }
        return globalSearchScope;
    }

    private final void collectConfigDirectories(Module module, Set<VirtualFile> configDirectories, boolean testScope, Set<? super Module> visitedModules) {
        if (visitedModules.contains(module)) {
            return;
        }
        visitedModules.add((Module)module);
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        List list = moduleRootManager.getSourceRoots((JpsModuleSourceRootType)(testScope ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceRoots(...)");
        configDirectories.addAll(list);
        Module[] moduleArray = moduleRootManager.getDependencies(testScope);
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"getDependencies(...)");
        for (Module dependentModule : moduleArray) {
            Intrinsics.checkNotNull((Object)dependentModule);
            this.collectConfigDirectories(dependentModule, configDirectories, testScope, visitedModules);
        }
    }

    static /* synthetic */ void collectConfigDirectories$default(QsConfigFileContributor qsConfigFileContributor, Module module, Set set, boolean bl, Set set2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: collectConfigDirectories");
        }
        if ((n & 8) != 0) {
            set2 = new HashSet();
        }
        qsConfigFileContributor.collectConfigDirectories(module, set, bl, set2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ(\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/quarkus/config/QsConfigFileContributor$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/quarkus/config/QsConfigFileContributor;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "getReferenceSearchScope", "Lcom/intellij/psi/search/SearchScope;", "baseScope", "findConfigFiles", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "includeTests", "", "intellij.quarkus"})
    @SourceDebugExtension(value={"SMAP\nQsConfigFileContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsConfigFileContributor.kt\ncom/intellij/quarkus/config/QsConfigFileContributor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,96:1\n1586#2:97\n1661#2,3:98\n1586#2:103\n1661#2,3:104\n37#3,2:101\n*S KotlinDebug\n*F\n+ 1 QsConfigFileContributor.kt\ncom/intellij/quarkus/config/QsConfigFileContributor$Companion\n*L\n29#1:97\n29#1:98,3\n36#1:103\n36#1:104,3\n29#1:101,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<QsConfigFileContributor> getEP_NAME() {
            return EP_NAME;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SearchScope getReferenceSearchScope(@NotNull SearchScope baseScope) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)baseScope, (String)"baseScope");
            Iterable $this$map$iv = this.getEP_NAME().getExtensionList();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                QsConfigFileContributor qsConfigFileContributor = (QsConfigFileContributor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getFileType());
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            FileType[] fileTypes = thisCollection$iv.toArray(new FileType[0]);
            SearchScope searchScope = PsiSearchScopeUtil.restrictScopeTo((SearchScope)baseScope, (FileType[])Arrays.copyOf(fileTypes, fileTypes.length));
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"restrictScopeTo(...)");
            return searchScope;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Pair<VirtualFile, QsConfigFileContributor>> findConfigFiles(@NotNull Module module, boolean includeTests) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            SmartList result = new SmartList();
            for (QsConfigFileContributor contributor : this.getEP_NAME().getExtensionList()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = contributor.findConfigFiles(module, includeTests);
                SmartList smartList = result;
                boolean $i$f$map = false;
                void var8_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new Pair((Object)it, (Object)contributor));
                }
                smartList.addAll((Collection)((List)destination$iv$iv));
            }
            return (List)result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

