/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.profiles;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.quarkus.config.profiles.QsProfileTargetKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Quarkus Profile")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0014\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0096\u0082\u0004J\n\u0010\u001d\u001a\u00020\u000fH\u0096\u0080\u0004R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/quarkus/config/profiles/QsProfileTarget;", "Lcom/intellij/pom/PomRenameableTarget;", "", "element", "Lcom/intellij/psi/PsiElement;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "name", "", "Lorg/jetbrains/annotations/NotNull;", "elementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "nameOffset", "", "isWritable", "", "isValid", "setName", "getName", "navigate", "", "requestFocus", "canNavigate", "canNavigateToSource", "getElement", "equals", "other", "hashCode", "intellij.quarkus"})
public final class QsProfileTarget
implements PomRenameableTarget<Object> {
    @NotNull
    private String name;
    @NotNull
    private final SmartPsiElementPointer<PsiElement> elementPointer;
    private final int nameOffset;

    public QsProfileTarget(@NotNull PsiElement element, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        String string = textRange.substring(element.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        this.name = string;
        this.nameOffset = textRange.getStartOffset();
        PsiFile containingFile = element.getContainingFile();
        PsiFile psiFile = containingFile;
        if (psiFile == null || (psiFile = psiFile.getProject()) == null) {
            Project project = element.getProject();
            psiFile = project;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        }
        PsiFile project = psiFile;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element, containingFile);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        this.elementPointer = smartPsiElementPointer;
    }

    public boolean isWritable() {
        return !QsProfileTargetKt.getPREDEFINED_PROFILES().contains(this.name);
    }

    public boolean isValid() {
        return this.elementPointer.getElement() != null;
    }

    @Nullable
    public Object setName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        return null;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void navigate(boolean requestFocus) {
        VirtualFile virtualFile;
        Segment segment = this.elementPointer.getRange();
        if (segment == null) {
            return;
        }
        Segment elementRange = segment;
        int offset = elementRange.getStartOffset();
        if (this.nameOffset < elementRange.getEndOffset() - offset) {
            offset += this.nameOffset;
        }
        if ((virtualFile = this.elementPointer.getVirtualFile()) != null && virtualFile.isValid()) {
            PsiNavigationSupport.getInstance().createNavigatable(this.elementPointer.getProject(), virtualFile, offset).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.canNavigateToSource();
    }

    public boolean canNavigateToSource() {
        PsiElement element = this.elementPointer.getElement();
        return element != null && PsiNavigationSupport.getInstance().canNavigate(element);
    }

    @Nullable
    public final PsiElement getElement() {
        return this.elementPointer.getElement();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        QsProfileTarget target = (QsProfileTarget)other;
        return Intrinsics.areEqual((Object)this.name, (Object)target.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

