/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.qute.lang.highlighting;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.QuarkusIcons;
import com.intellij.quarkus.qute.lang.QuteLanguage;
import com.intellij.quarkus.qute.lang.highlighting.QuteHighlighterColorsKt;
import com.intellij.quarkus.qute.lang.highlighting.QuteSyntaxHighlighter;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0016\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/quarkus/qute/lang/highlighting/QuteColorSettingsPage;", "Lcom/intellij/openapi/options/colors/ColorSettingsPage;", "<init>", "()V", "ATTRS", "", "Lcom/intellij/openapi/options/colors/AttributesDescriptor;", "[Lcom/intellij/openapi/options/colors/AttributesDescriptor;", "getAttributeDescriptors", "()[Lcom/intellij/openapi/options/colors/AttributesDescriptor;", "getColorDescriptors", "Lcom/intellij/openapi/options/colors/ColorDescriptor;", "()[Lcom/intellij/openapi/options/colors/ColorDescriptor;", "getDisplayName", "", "getIcon", "Ljavax/swing/Icon;", "getHighlighter", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighter;", "getDemoText", "getAdditionalHighlightingTagToDescriptorMap", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.quarkus"})
public final class QuteColorSettingsPage
implements ColorSettingsPage {
    @NotNull
    private final AttributesDescriptor[] ATTRS;

    public QuteColorSettingsPage() {
        AttributesDescriptor[] attributesDescriptorArray = new AttributesDescriptor[]{new AttributesDescriptor(QuarkusBundle.message("qute.highlighting.colors.operator.sign", new Object[0]), QuteHighlighterColorsKt.getOPERATOR_SIGN()), new AttributesDescriptor(QuarkusBundle.message("qute.highlighting.colors.boolean", new Object[0]), QuteHighlighterColorsKt.getBOOLEAN()), new AttributesDescriptor(QuarkusBundle.message("qute.highlighting.colors.comment", new Object[0]), QuteHighlighterColorsKt.getCOMMENT()), new AttributesDescriptor(QuarkusBundle.message("qute.highlighting.colors.identifier", new Object[0]), QuteHighlighterColorsKt.getIDENTIFIER()), new AttributesDescriptor(QuarkusBundle.message("qute.highlighting.colors.number", new Object[0]), QuteHighlighterColorsKt.getNUMBER()), new AttributesDescriptor(QuarkusBundle.message("qute.highlighting.colors.secondary.keyword", new Object[0]), QuteHighlighterColorsKt.getSECONDARY_KEYWORD()), new AttributesDescriptor(QuarkusBundle.message("qute.highlighting.colors.string", new Object[0]), QuteHighlighterColorsKt.getSTRING()), new AttributesDescriptor(QuarkusBundle.message("qute.highlighting.colors.tag.braces", new Object[0]), QuteHighlighterColorsKt.getTAG_BRACE()), new AttributesDescriptor(QuarkusBundle.message("qute.highlighting.colors.tag.parentheses", new Object[0]), QuteHighlighterColorsKt.getPARENTHESES()), new AttributesDescriptor(QuarkusBundle.message("qute.highlighting.colors.tag.brackets", new Object[0]), QuteHighlighterColorsKt.getBRACKETS()), new AttributesDescriptor(QuarkusBundle.message("qute.highlighting.colors.tag.dot", new Object[0]), QuteHighlighterColorsKt.getDOT()), new AttributesDescriptor(QuarkusBundle.message("qute.highlighting.colors.tag.comma", new Object[0]), QuteHighlighterColorsKt.getCOMMA()), new AttributesDescriptor(QuarkusBundle.message("qute.highlighting.colors.tag.name", new Object[0]), QuteHighlighterColorsKt.getTAG_NAME()), new AttributesDescriptor(QuarkusBundle.message("qute.highlighting.colors.background", new Object[0]), QuteHighlighterColorsKt.getBACKGROUND())};
        this.ATTRS = attributesDescriptorArray;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        return this.ATTRS;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        Intrinsics.checkNotNullExpressionValue((Object)ColorDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public String getDisplayName() {
        String string = QuteLanguage.INSTANCE.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = QuarkusIcons.Quarkus;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Quarkus");
        return icon;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        return (SyntaxHighlighter)new QuteSyntaxHighlighter();
    }

    @NotNull
    public String getDemoText() {
        String string;
        try {
            InputStream inputStream = QuteColorSettingsPage.class.getClassLoader().getResourceAsStream("highlighting/qute.txt");
            Intrinsics.checkNotNull((Object)inputStream);
            string = StringUtil.convertLineSeparators((String)ResourceUtil.loadText((InputStream)inputStream));
            Intrinsics.checkNotNull((Object)string);
        }
        catch (IOException e) {
            string = StringsKt.trimIndent((String)("Error reading demo:\n        " + e.getMessage()));
        }
        return string;
    }

    @Nullable
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return null;
    }
}

