/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\tJ$\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dialects/oracle/OraKerberosAuthProvider;", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "<init>", "()V", "interceptConnection", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "silent", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadAuthConfig", "", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "external", "saveAuthConfig", "", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "data", "getId", "", "getDisplayName", "getApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "Companion", "intellij.database.dialects.oracle"})
public final class OraKerberosAuthProvider
implements DatabaseAuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "ora-kerberos";

    @Nullable
    public Object interceptConnection(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent, @NotNull Continuation<? super Boolean> $completion) {
        proto.getConnectionProperties().put("oracle.net.authentication_services", "KERBEROS5");
        return Boxing.boxBoolean((boolean)true);
    }

    @Nullable
    public Object loadAuthConfig(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials, boolean external) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return super.loadAuthConfig(point, credentials, external);
    }

    public void saveAuthConfig(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable Object data, boolean external) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super.saveAuthConfig(config, credentials, data, external);
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message((String)"kerberos", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public DatabaseAuthProvider.ApplicabilityLevel.Result getApplicability(@NotNull DatabaseConnectionPoint point, @NotNull DatabaseAuthProvider.ApplicabilityLevel level) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return !Intrinsics.areEqual((Object)point.getDbms(), (Object)Dbms.ORACLE) ? DatabaseAuthProvider.ApplicabilityLevel.Result.NOT_APPLICABLE : DatabaseAuthProvider.ApplicabilityLevel.Result.DEFAULT.clamp(level);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/oracle/OraKerberosAuthProvider$Companion;", "", "<init>", "()V", "ID", "", "intellij.database.dialects.oracle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

