/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import com.intellij.execution.Executor;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaTargetDependentParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.java.JavaTargetParameter;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.profiler.DefaultProfilerExecutorGroup;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.linux.HasInvalidVariables;
import com.intellij.profiler.linux.KernelVariable;
import com.intellij.profiler.linux.KernelVariablesChangeRequiredException;
import com.intellij.profiler.linux.KernelVariablesValidatorKt;
import com.intellij.profiler.linux.ValidationResult;
import com.intellij.profiler.ultimate.JavaProfilerConfigurationExtension;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.async.AgentConfiguration;
import com.intellij.profiler.ultimate.async.AsyncProfilerConfigurationExtensionBaseKt;
import com.intellij.profiler.ultimate.async.UtilsKt;
import com.intellij.profiler.ultimate.async.configurations.AgentOptions;
import com.intellij.profiler.ultimate.async.configurations.AsyncProfilerConfigurationStateBase;
import com.intellij.profiler.ultimate.async.configurations.AsyncProfilerStarter;
import com.intellij.profiler.ultimate.async.extractor.AsyncProfilerExtractor;
import com.intellij.profiler.ultimate.widget.JavaProfilerConsoleWidgetManager;
import com.intellij.profiler.ultimate.widget.WidgetMode;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J;\u0010\t\u001a\u00020\n\"\f\b\u0000\u0010\u000b*\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0007\u001a\u0002H\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J3\u0010\u0015\u001a\u00020\n\"\f\b\u0000\u0010\u000b*\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0007\u001a\u0002H\u000b2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0014\u00a2\u0006\u0002\u0010\u0017J+\u0010\u0018\u001a\u00020\u0019\"\f\b\u0000\u0010\u000b*\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0007\u001a\u0002H\u000b2\u0006\u0010\u0016\u001a\u00020\u0014H\u0004\u00a2\u0006\u0002\u0010\u001aJ3\u0010\u001b\u001a\u00020\u001c\"\f\b\u0000\u0010\u000b*\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u0002H\u000bH\u0002\u00a2\u0006\u0002\u0010\u001fJ$\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0014\u0010 \u001a\u00020!8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R'\u0010'\u001a\u0015\u0012\f\u0012\n )*\u0004\u0018\u00010\u00020\u00020(\u00a2\u0006\u0002\b*X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lcom/intellij/profiler/ultimate/async/AsyncProfilerConfigurationExtensionBase;", "Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationExtension;", "Lcom/intellij/profiler/ultimate/async/AgentConfiguration;", "<init>", "()V", "isApplicableFor", "", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "updateJavaParameters", "", "T", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "executor", "Lcom/intellij/execution/Executor;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/JavaParameters;Lcom/intellij/execution/configurations/RunnerSettings;Lcom/intellij/execution/Executor;)V", "getSettings", "Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationStateBase;", "doUpdateJavaParameters", "settings", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationStateBase;Lcom/intellij/execution/configurations/JavaParameters;)V", "makeProfilerAgentParameters", "Lcom/intellij/execution/configurations/JavaTargetDependentParameters;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationStateBase;)Lcom/intellij/execution/configurations/JavaTargetDependentParameters;", "createTargetParameter", "Lcom/intellij/execution/target/java/JavaTargetParameter;", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "(Lcom/intellij/execution/target/TargetEnvironmentRequest;Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationStateBase;Lcom/intellij/execution/configurations/RunConfigurationBase;)Lcom/intellij/execution/target/java/JavaTargetParameter;", "mainCommand", "Lcom/intellij/profiler/ultimate/async/configurations/AgentOptions$MainCommand;", "getMainCommand", "()Lcom/intellij/profiler/ultimate/async/configurations/AgentOptions$MainCommand;", "decorate", "Lcom/intellij/execution/ui/ConsoleView;", "console", "profilerParametersKey", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getProfilerParametersKey", "()Lcom/intellij/openapi/util/Key;", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nAsyncProfilerConfigurationExtensionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncProfilerConfigurationExtensionBase.kt\ncom/intellij/profiler/ultimate/async/AsyncProfilerConfigurationExtensionBase\n+ 2 JavaProfilerConfigurationExtension.kt\ncom/intellij/profiler/ultimate/JavaProfilerConfigurationExtension\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,183:1\n82#2:184\n82#2:187\n1#3:185\n23#4:186\n*S KotlinDebug\n*F\n+ 1 AsyncProfilerConfigurationExtensionBase.kt\ncom/intellij/profiler/ultimate/async/AsyncProfilerConfigurationExtensionBase\n*L\n58#1:184\n135#1:187\n106#1:186\n*E\n"})
public abstract class AsyncProfilerConfigurationExtensionBase
extends JavaProfilerConfigurationExtension<AgentConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Key<AgentConfiguration> profilerParametersKey = PROFILER_AGENT_CONFIGURATION_KEY;
    @NotNull
    private static final Key<AgentConfiguration> PROFILER_AGENT_CONFIGURATION_KEY;
    @NotNull
    private static final List<KernelVariable> requiredKernelVariables;

    public boolean isApplicableFor(@NotNull RunConfigurationBase<?> configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        return AsyncProfilerStarter.INSTANCE.canRun((RunProfile)configuration) || SystemInfo.isWindows;
    }

    public final <T extends RunConfigurationBase<?>> void updateJavaParameters(@NotNull T configuration, @NotNull JavaParameters params, @Nullable RunnerSettings runnerSettings, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        if (!this.isApplicableFor(runnerSettings)) {
            return;
        }
        AsyncProfilerConfigurationStateBase asyncProfilerConfigurationStateBase = this.getSettings(executor);
        if (asyncProfilerConfigurationStateBase == null) {
            return;
        }
        AsyncProfilerConfigurationStateBase settings = asyncProfilerConfigurationStateBase;
        CharSequence charSequence = settings.getAgentPath();
        if ((charSequence == null || charSequence.length() == 0) && AsyncProfilerConfigurationExtensionBaseKt.access$isOpenJ9(configuration)) {
            Project project = configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ProfilerToolWindowManager.Companion.getInstance(project).showWarningBalloon(UltimateProfilerBundleKt.profilerMessage("openj9.not.supported.message", new Object[0]));
        } else {
            this.doUpdateJavaParameters(configuration, settings, params);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected AsyncProfilerConfigurationStateBase getSettings(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        var2_2 = this;
        executor$iv = executor;
        $i$f$getConfigurationState = false;
        v0 = DefaultProfilerExecutorGroup.Companion.getInstance();
        if (v0 == null) ** GOTO lbl-1000
        v1 = executor$iv.getId();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getId(...)");
        if ((v0 = (DefaultProfilerExecutorGroup.ProfilerExecutorSettings)v0.getRegisteredSettings(v1)) != null) {
            v2 = v0.getState();
        } else lbl-1000:
        // 2 sources

        {
            v2 = v3 = null;
        }
        if (!(v2 instanceof AsyncProfilerConfigurationStateBase)) {
            v3 = null;
        }
        return (AsyncProfilerConfigurationStateBase)((ProfilerConfigurationState)((AsyncProfilerConfigurationStateBase)v3));
    }

    protected <T extends RunConfigurationBase<?>> void doUpdateJavaParameters(@NotNull T configuration, @NotNull AsyncProfilerConfigurationStateBase settings, @NotNull JavaParameters params) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        JavaTargetDependentParameters vmParameters = this.makeProfilerAgentParameters(configuration, settings);
        params.getVMParametersList().addAll(vmParameters.toLocalParameters());
    }

    @NotNull
    protected final <T extends RunConfigurationBase<?>> JavaTargetDependentParameters makeProfilerAgentParameters(@NotNull T configuration, @NotNull AsyncProfilerConfigurationStateBase settings) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        JavaTargetDependentParameters profilerParameters = new JavaTargetDependentParameters();
        profilerParameters.addParameter(arg_0 -> AsyncProfilerConfigurationExtensionBase.makeProfilerAgentParameters$lambda$1(arg_0 -> AsyncProfilerConfigurationExtensionBase.makeProfilerAgentParameters$lambda$0(this, settings, configuration, arg_0), arg_0));
        return profilerParameters;
    }

    private final <T extends RunConfigurationBase<?>> JavaTargetParameter createTargetParameter(TargetEnvironmentRequest request, AsyncProfilerConfigurationStateBase settings, T configuration) {
        ValidationResult validationResult;
        Platform targetPlatform = request instanceof LocalTargetEnvironmentRequest ? null : request.getTargetPlatform().getPlatform();
        String nativeAgentPath = UtilsKt.getNativeAgentPath(settings, targetPlatform);
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        MisConfiguredException misConfiguredException = AsyncProfilerConfigurationExtensionBaseKt.validateAgentPath(nativeAgentPath, project, (ProfilerConfigurationState)settings);
        if (misConfiguredException != null) {
            MisConfiguredException it = misConfiguredException;
            boolean bl = false;
            throw it;
        }
        if (targetPlatform == null && (validationResult = KernelVariablesValidatorKt.checkKernelVariablesOnLinuxOnly(requiredKernelVariables)) instanceof HasInvalidVariables) {
            HasInvalidVariables hasInvalidVariables = (HasInvalidVariables)validationResult;
            Project project2 = configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            throw new KernelVariablesChangeRequiredException(hasInvalidVariables, project2);
        }
        String agentPath = UtilsKt.tryToHandleSpacesInAgentPath(nativeAgentPath);
        boolean isWindows = targetPlatform == Platform.WINDOWS || targetPlatform == null && SystemInfo.isWindows;
        String dbgHelpPath = isWindows ? AsyncProfilerExtractor.INSTANCE.getLibDbghelpPath() : null;
        Platform platform = targetPlatform;
        if (platform == null) {
            Platform platform2 = Platform.current();
            platform = platform2;
            Intrinsics.checkNotNullExpressionValue((Object)platform2, (String)"current(...)");
        }
        AgentOptions options = settings.agentOptions(platform);
        ((UserDataHolderBase)configuration).putUserData(this.getProfilerConfigurationStateKey(), (Object)settings);
        String string = configuration.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Project project3 = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        AgentConfiguration agentConfiguration = new AgentConfiguration(agentPath, options, string, project3);
        ((UserDataHolderBase)configuration).putUserData(this.getProfilerParametersKey(), (Object)agentConfiguration);
        File dumpFile = agentConfiguration.getResultSnapshot().getDumpFile();
        String agentArgs = AgentOptions.agentArgs$default(options, false, this.getMainCommand(), null, null, null, 28, null);
        String dumpLocalPath = dumpFile.getAbsolutePath();
        File logFile = agentConfiguration.getLogFile();
        String logLocalPath = logFile.getAbsolutePath();
        String vmParameters = "-agentpath:" + agentPath + "=" + agentArgs + ",file=" + dumpLocalPath + ",log=" + logLocalPath + ",logLevel=debug";
        AsyncProfilerConfigurationExtensionBase $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AsyncProfilerConfigurationExtensionBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("start profiler from run configuration, add VM parameters: " + vmParameters);
        String[] stringArray = new String[]{nativeAgentPath};
        HashSet uploadPaths = SetsKt.hashSetOf((Object[])stringArray);
        if (dbgHelpPath != null) {
            uploadPaths.add(dbgHelpPath);
        }
        stringArray = new String[]{dumpLocalPath, logLocalPath};
        JavaTargetParameter.Builder builder = new JavaTargetParameter.Builder((Set)uploadPaths, SetsKt.setOf((Object[])stringArray)).fixed("-agentpath:").resolved(nativeAgentPath).fixed("=" + agentArgs + ",file=");
        Intrinsics.checkNotNull((Object)dumpLocalPath);
        String[] $this$createTargetParameter_u24lambda_u241 = stringArray = builder.resolved(dumpLocalPath);
        boolean bl = false;
        if (dbgHelpPath != null) {
            $this$createTargetParameter_u24lambda_u241.fixed(",dbghelppath=").resolved(dbgHelpPath);
        }
        JavaTargetParameter.Builder builder2 = stringArray.fixed(",log=");
        Intrinsics.checkNotNull((Object)logLocalPath);
        return builder2.resolved(logLocalPath).fixed(",logLevel=DEBUG").build();
    }

    @NotNull
    protected AgentOptions.MainCommand getMainCommand() {
        return AgentOptions.MainCommand.Start.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected ConsoleView decorate(@NotNull ConsoleView console, @NotNull RunConfigurationBase<?> configuration, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        v0 = super.decorate(console, configuration, executor);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"decorate(...)");
        baseConsole = v0;
        var5_5 = this;
        executor$iv = executor;
        $i$f$getConfigurationState = false;
        v1 = DefaultProfilerExecutorGroup.Companion.getInstance();
        if (v1 == null) ** GOTO lbl-1000
        v2 = executor$iv.getId();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getId(...)");
        if ((v1 = (DefaultProfilerExecutorGroup.ProfilerExecutorSettings)v1.getRegisteredSettings(v2)) != null) {
            v3 = v1.getState();
        } else lbl-1000:
        // 2 sources

        {
            v3 = v4 = null;
        }
        if (!(v3 instanceof AsyncProfilerConfigurationStateBase)) {
            v4 = null;
        }
        if ((ProfilerConfigurationState)((AsyncProfilerConfigurationStateBase)v4) == null) {
            return baseConsole;
        }
        v5 = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getProject(...)");
        return JavaProfilerConsoleWidgetManager.Companion.getInstance(v5).addWidgetToConsole(configuration, baseConsole, WidgetMode.PROFILE);
    }

    @Override
    @NotNull
    protected Key<AgentConfiguration> getProfilerParametersKey() {
        return this.profilerParametersKey;
    }

    private static final JavaTargetParameter makeProfilerAgentParameters$lambda$0(AsyncProfilerConfigurationExtensionBase this$0, AsyncProfilerConfigurationStateBase $settings, RunConfigurationBase $configuration, TargetEnvironmentRequest request) {
        Intrinsics.checkNotNull((Object)request);
        return this$0.createTargetParameter(request, $settings, $configuration);
    }

    private static final JavaTargetParameter makeProfilerAgentParameters$lambda$1(Function1 $tmp0, Object p0) {
        return (JavaTargetParameter)$tmp0.invoke(p0);
    }

    private static final boolean requiredKernelVariables$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.parseInt(it) <= 1;
    }

    private static final boolean requiredKernelVariables$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)"0");
    }

    static {
        Key key = Key.create((String)"async.profiler.agent.configuration");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PROFILER_AGENT_CONFIGURATION_KEY = key;
        Object[] objectArray = new KernelVariable[]{new KernelVariable("perf_event_paranoid", "1", AsyncProfilerConfigurationExtensionBase::requiredKernelVariables$lambda$0), new KernelVariable("kptr_restrict", "0", AsyncProfilerConfigurationExtensionBase::requiredKernelVariables$lambda$1)};
        requiredKernelVariables = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ultimate/async/AsyncProfilerConfigurationExtensionBase$Companion;", "", "<init>", "()V", "PROFILER_AGENT_CONFIGURATION_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/profiler/ultimate/async/AgentConfiguration;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getPROFILER_AGENT_CONFIGURATION_KEY", "()Lcom/intellij/openapi/util/Key;", "requiredKernelVariables", "", "Lcom/intellij/profiler/linux/KernelVariable;", "getRequiredKernelVariables", "()Ljava/util/List;", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<AgentConfiguration> getPROFILER_AGENT_CONFIGURATION_KEY() {
            return PROFILER_AGENT_CONFIGURATION_KEY;
        }

        @NotNull
        public final List<KernelVariable> getRequiredKernelVariables() {
            return requiredKernelVariables;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

