/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.ui;

import com.intellij.ide.TextCopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.api.MuiElement;
import com.intellij.profiler.ultimate.hprof.api.MuiField;
import com.intellij.profiler.ultimate.hprof.api.MuiInstance;
import com.intellij.profiler.ultimate.hprof.api.MuiPage;
import com.intellij.profiler.ultimate.hprof.api.MuiRecord;
import com.intellij.profiler.ultimate.hprof.api.MuiSnapshot;
import com.intellij.profiler.ultimate.hprof.api.MuiStub;
import com.intellij.profiler.ultimate.hprof.api.MuiTree;
import com.intellij.profiler.ultimate.hprof.api.MuiType;
import com.intellij.profiler.ultimate.hprof.api.MuiTypes;
import com.intellij.profiler.ultimate.hprof.api.visitors.MuiVisitorWithComparator;
import com.intellij.profiler.ultimate.hprof.ui.ActionsKt;
import com.intellij.profiler.ultimate.hprof.ui.MemoryViewTopLevelComponent;
import com.intellij.profiler.ultimate.hprof.ui.RenderUtilsKt;
import com.intellij.profiler.ultimate.hprof.ui.TextFragment;
import com.intellij.profiler.ultimate.hprof.ui.TreeActionProperties;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.ui.Control;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReverseReferencePanel<T extends MuiInstance>
extends BorderLayoutPanel
implements UiDataProvider {
    protected Tree myTree;
    protected MuiSnapshot<? extends MuiType, T> mySnapshot;

    protected void init(MemoryViewTopLevelComponent view, final MuiSnapshot<? extends MuiType, T> snapshot, final MuiInstance root, Disposable disposable) {
        this.mySnapshot = snapshot;
        this.myTree = new Tree((TreeModel)new AsyncTreeModel(new MyTreeModel<MuiInstance>(snapshot, root, this::load), disposable));
        this.myTree.putClientProperty(TreeActionProperties.REVERSE_VIEW, (Object)this.shouldTryAddField());
        this.myTree.putClientProperty((Object)DefaultTreeUI.AUTO_EXPAND_ALLOWED, (Object)false);
        this.myTree.putClientProperty((Object)Control.Painter.KEY, (Object)Control.Painter.COMPACT);
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                String prettyName;
                if (tree2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value instanceof MuiInstance && (prettyName = ((MuiInstance)value).getPrettyName()) != null) {
                    this.append(prettyName, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    return;
                }
                if (snapshot.isReady()) {
                    Long retainedSize;
                    if (value != root && ReverseReferencePanel.this.shouldTryAddField()) {
                        if (value instanceof MuiInstance && ((MuiInstance)value).getType().getId() == snapshot.getIdOfType(MuiTypes.CLASS)) {
                            this.append(UltimateProfilerBundleKt.profilerMessage("hprof.object.view.static", new Object[0]) + " ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        }
                        TreePath path = tree2.getPathForRow(row);
                        ReverseReferencePanel.this.appendFieldName(path, (arg_0, arg_1) -> (this).append(arg_0, arg_1));
                    }
                    RenderUtilsKt.createTextFragments(value, snapshot).forEach(f -> this.append(f.getText(), f.getAttributes()));
                    SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)tree2, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
                    if (value instanceof MuiInstance && (retainedSize = ((MuiInstance)value).getRetainedSize()) != null) {
                        this.append(" " + ReverseReferencePanel.formatNumber(retainedSize), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/profiler/ultimate/hprof/ui/ReverseReferencePanel$1", "customizeCellRenderer"));
            }
        });
        TreeSpeedSearch.installOn((JTree)this.myTree, (boolean)false, it -> {
            String string = RenderUtilsKt.createTextFragments(it.getLastPathComponent(), snapshot).stream().map(TextFragment::getText).collect(Collectors.joining());
            if (this.shouldTryAddField()) {
                StringBuilder sb = new StringBuilder();
                this.appendFieldName((TreePath)it, (s, attr) -> sb.append((String)s));
                sb.append(string);
                return sb.toString();
            }
            return string;
        });
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        pane.setBorder(BorderFactory.createEmptyBorder());
        this.addToCenter(pane);
        ActionsKt.installActions(this.myTree, view, snapshot, (Function1<? super TreePath, ? extends Object>)((Function1)path -> path == null ? null : path.getLastPathComponent()));
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            ReverseReferencePanel.$$$reportNull$$$0(0);
        }
        sink.set(PlatformDataKeys.COPY_PROVIDER, (Object)new TextCopyProvider(){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            @Nullable
            public Collection<String> getTextLinesToCopy() {
                ArrayList<String> result = new ArrayList<String>();
                TreeUtil.visitVisibleRows((JTree)ReverseReferencePanel.this.myTree, path -> ReverseReferencePanel.this.createText((TreePath)path, ReverseReferencePanel.this.mySnapshot), result::add);
                return result.isEmpty() ? null : result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profiler/ultimate/hprof/ui/ReverseReferencePanel$2", "getActionUpdateThread"));
            }
        });
    }

    private String createText(TreePath path, MuiSnapshot<?, ?> snapshot) {
        Long retainedSize;
        Object value = path.getLastPathComponent();
        StringBuilder sb = new StringBuilder();
        int depth = ReverseReferencePanel.calculateDepth(path);
        if (depth > 0) {
            sb.append(StringUtil.repeat((String)"\t", (int)depth));
        }
        this.appendFieldName(path, (s, attributes) -> sb.append((String)s));
        sb.append(RenderUtilsKt.createTextFragments(value, snapshot).stream().map(TextFragment::getText).collect(Collectors.joining()));
        if (!Registry.is((String)"idea.profiler.hprof.show.objectAddress", (boolean)false)) {
            Long id = null;
            if (value instanceof MuiInstance) {
                id = ((MuiInstance)value).getId();
            }
            if (value instanceof MuiType) {
                id = ((MuiType)value).getId();
            }
            if (id != null && id >= 0L) {
                sb.append(" 0x").append(Long.toHexString(id));
            }
        }
        if (value instanceof MuiInstance && (retainedSize = ((MuiInstance)value).getRetainedSize()) != null) {
            sb.append(" ").append(ReverseReferencePanel.formatNumber(retainedSize));
        }
        return sb.toString();
    }

    private static int calculateDepth(@NotNull TreePath path) {
        if (path == null) {
            ReverseReferencePanel.$$$reportNull$$$0(1);
        }
        int i = 0;
        TreePath cur = path.getParentPath();
        while (cur != null) {
            cur = cur.getParentPath();
            ++i;
        }
        return i;
    }

    @NlsSafe
    private static String formatNumber(long number) {
        return StringUtil.formatFileSize((long)number);
    }

    private void appendFieldName(TreePath path, BiConsumer<? super String, ? super SimpleTextAttributes> consumer) {
        if (this.shouldTryAddField() && path != null) {
            MuiField field;
            Object parentValue;
            Object value = path.getLastPathComponent();
            Object object = parentValue = (path = path.getParentPath()) != null ? path.getLastPathComponent() : null;
            if (parentValue instanceof MuiInstance && value instanceof MuiRecord && (field = ((MuiRecord)value).getValueField((MuiInstance)parentValue)) != null) {
                consumer.accept(String.format("%s", field.getName()), (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES);
                consumer.accept(String.format(" %s ", UltimateProfilerBundleKt.profilerMessage("hprof.object.view.of", new Object[0])), (SimpleTextAttributes)SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }
    }

    @NotNull
    protected abstract List<?> load(MuiSnapshot<?, T> var1, T var2);

    protected boolean shouldTryAddField() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/profiler/ultimate/hprof/ui/ReverseReferencePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "uiDataSnapshot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateDepth";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyTreeModel<T extends MuiInstance>
    extends BaseTreeModel<Object>
    implements InvokerSupplier {
        private final MuiSnapshot<? extends MuiType, T> mySnapshot;
        private final MuiInstance myRoot;
        private final BiFunction<? super MuiSnapshot<?, T>, ? super T, ? extends List<?>> myLoader;
        private final Invoker myInvoker;

        private MyTreeModel(MuiSnapshot<? extends MuiType, T> snapshot, MuiInstance root, BiFunction<? super MuiSnapshot<?, T>, ? super T, ? extends List<?>> loader) {
            this.mySnapshot = snapshot;
            this.myRoot = root;
            this.myLoader = loader;
            this.myInvoker = ApplicationManager.getApplication().isUnitTestMode() ? Invoker.forEventDispatchThread((Disposable)this) : Invoker.forBackgroundThreadWithoutReadAction((Disposable)this);
        }

        public boolean isLeaf(Object object) {
            return object instanceof MuiStub;
        }

        public int getChildCount(Object object) {
            if (object instanceof MuiPage) {
                return ((MuiPage)object).getSize();
            }
            if (object instanceof MuiStub) {
                return 0;
            }
            return super.getChildCount(object);
        }

        public List<?> getChildren(Object parent) {
            if (parent instanceof MuiPage) {
                return Arrays.asList(((MuiPage)parent).getData());
            }
            if (parent instanceof MuiField) {
                return Collections.emptyList();
            }
            return this.myLoader.apply((MuiSnapshot<?, MuiSnapshot<? extends MuiType, T>>)this.mySnapshot, (MuiSnapshot<? extends MuiType, T>)((Object)((MuiInstance)parent)));
        }

        @NotNull
        public Invoker getInvoker() {
            Invoker invoker = this.myInvoker;
            if (invoker == null) {
                MyTreeModel.$$$reportNull$$$0(0);
            }
            return invoker;
        }

        public Object getRoot() {
            return this.myRoot;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profiler/ultimate/hprof/ui/ReverseReferencePanel$MyTreeModel", "getInvoker"));
        }
    }

    public static class ShortestPaths<T extends MuiInstance>
    extends ReverseReferencePanel<T> {
        private final MuiTree<T> myPaths;

        public ShortestPaths(MemoryViewTopLevelComponent view, MuiSnapshot<? extends MuiType, T> snapshot, MuiTree<T> paths, Disposable disposable) {
            this.myPaths = paths;
            this.init(view, snapshot, (MuiInstance)paths.root(), disposable);
        }

        @Override
        @NotNull
        protected List<?> load(MuiSnapshot<?, T> snapshot, T parent) {
            List<T> list = this.myPaths.get(parent);
            if (list == null) {
                ShortestPaths.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profiler/ultimate/hprof/ui/ReverseReferencePanel$ShortestPaths", "load"));
        }
    }

    public static class Retained<T extends MuiInstance>
    extends ReverseReferencePanel<T> {
        public Retained(MemoryViewTopLevelComponent view, MuiSnapshot<? extends MuiType, T> snapshot, MuiInstance root, Disposable disposable) {
            this.init(view, snapshot, root, disposable);
        }

        @Override
        @NotNull
        protected List<?> load(MuiSnapshot<?, T> snapshot, T parent) {
            Comparator<MuiInstance> comparator2 = Comparator.comparing(MuiInstance::getRetainedSize).reversed();
            int limit = 1000;
            MuiVisitorWithComparator<MuiInstance> visitor2 = new MuiVisitorWithComparator<MuiInstance>(limit, limit, comparator2);
            snapshot.getRetained(parent.getId(), null, visitor2);
            ArrayList<MuiInstance> list = new ArrayList<MuiInstance>(visitor2.getResult());
            if (list.size() == limit) {
                list.add(new MuiStub(String.format(UltimateProfilerBundleKt.profilerMessage("hprof.stub.first.results", new Object[0]), limit)));
            }
            ArrayList<MuiInstance> arrayList = list;
            if (arrayList == null) {
                Retained.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        @Override
        protected boolean shouldTryAddField() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profiler/ultimate/hprof/ui/ReverseReferencePanel$Retained", "load"));
        }
    }

    public static class Dominators<T extends MuiInstance>
    extends ReverseReferencePanel<T> {
        public Dominators(MemoryViewTopLevelComponent view, MuiSnapshot<? extends MuiType, T> snapshot, MuiInstance root, Disposable disposable) {
            this.init(view, snapshot, root, disposable);
        }

        @Override
        @NotNull
        protected List<?> load(MuiSnapshot<?, T> snapshot, T parent) {
            Long dominator = snapshot.getDominator(parent.getId(), null);
            List list = dominator == null ? Collections.emptyList() : Collections.singletonList(snapshot.getInstanceById(dominator));
            if (list == null) {
                Dominators.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        protected boolean shouldTryAddField() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profiler/ultimate/hprof/ui/ReverseReferencePanel$Dominators", "load"));
        }
    }

    public static class Simple<T extends MuiInstance>
    extends ReverseReferencePanel<T> {
        public Simple(MemoryViewTopLevelComponent view, MuiSnapshot<? extends MuiType, T> snapshot, MuiInstance root, Disposable disposable) {
            this.init(view, snapshot, root, disposable);
        }

        @Override
        @NotNull
        protected List<?> load(MuiSnapshot<?, T> snapshot, T parent) {
            List<MuiElement> list = Arrays.asList(snapshot.getReverseReferences(parent.getId(), 1000, null));
            if (list == null) {
                Simple.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profiler/ultimate/hprof/ui/ReverseReferencePanel$Simple", "load"));
        }
    }
}

