/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jbonlymac;

import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.NativeCall;
import com.intellij.profiler.ultimate.jbonlymac.JavaCalls;
import com.intellij.profiler.ultimate.jbonlymac.Statistics;
import com.intellij.profiler.ultimate.model.BaseJavaCall;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\t\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c2\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0083\u0004J\n\u0010\u001a\u001a\u00020\u0006H\u00d6\u0081\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/intellij/profiler/ultimate/jbonlymac/CallsMappingStatistics;", "Lcom/intellij/profiler/ultimate/jbonlymac/Statistics;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "javaCalls", "Lcom/intellij/profiler/ultimate/jbonlymac/JavaCalls;", "_totalNativeCalls", "", "<init>", "(Lcom/intellij/profiler/ultimate/jbonlymac/JavaCalls;I)V", "getJavaCalls", "()Lcom/intellij/profiler/ultimate/jbonlymac/JavaCalls;", "totalCalls", "getTotalCalls", "()I", "totalNativeCalls", "getTotalNativeCalls", "update", "", "item", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.profiler.ultimate"})
public final class CallsMappingStatistics
implements Statistics<BaseCallStackElement> {
    @NotNull
    private final JavaCalls javaCalls;
    private int _totalNativeCalls;

    public CallsMappingStatistics(@NotNull JavaCalls javaCalls, int _totalNativeCalls) {
        Intrinsics.checkNotNullParameter((Object)javaCalls, (String)"javaCalls");
        this.javaCalls = javaCalls;
        this._totalNativeCalls = _totalNativeCalls;
    }

    public /* synthetic */ CallsMappingStatistics(JavaCalls javaCalls, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            javaCalls = new JavaCalls(0, 0, 0, 0, 0, 31, null);
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(javaCalls, n);
    }

    @NotNull
    public final JavaCalls getJavaCalls() {
        return this.javaCalls;
    }

    public final int getTotalCalls() {
        return this.javaCalls.getTotal() + this._totalNativeCalls;
    }

    public final int getTotalNativeCalls() {
        return this._totalNativeCalls;
    }

    @Override
    public void update(@NotNull BaseCallStackElement item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (item instanceof NativeCall) {
            int n = this._totalNativeCalls;
            this._totalNativeCalls = n + 1;
        }
        if (item instanceof BaseJavaCall) {
            this.javaCalls.update((BaseJavaCall)item);
        }
    }

    @NotNull
    public final JavaCalls component1() {
        return this.javaCalls;
    }

    private final int component2() {
        return this._totalNativeCalls;
    }

    @NotNull
    public final CallsMappingStatistics copy(@NotNull JavaCalls javaCalls, int _totalNativeCalls) {
        Intrinsics.checkNotNullParameter((Object)javaCalls, (String)"javaCalls");
        return new CallsMappingStatistics(javaCalls, _totalNativeCalls);
    }

    public static /* synthetic */ CallsMappingStatistics copy$default(CallsMappingStatistics callsMappingStatistics, JavaCalls javaCalls, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            javaCalls = callsMappingStatistics.javaCalls;
        }
        if ((n2 & 2) != 0) {
            n = callsMappingStatistics._totalNativeCalls;
        }
        return callsMappingStatistics.copy(javaCalls, n);
    }

    @NotNull
    public String toString() {
        return "CallsMappingStatistics(javaCalls=" + this.javaCalls + ", _totalNativeCalls=" + this._totalNativeCalls + ")";
    }

    public int hashCode() {
        int result = this.javaCalls.hashCode();
        result = result * 31 + Integer.hashCode(this._totalNativeCalls);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CallsMappingStatistics)) {
            return false;
        }
        CallsMappingStatistics callsMappingStatistics = (CallsMappingStatistics)other;
        if (!Intrinsics.areEqual((Object)this.javaCalls, (Object)callsMappingStatistics.javaCalls)) {
            return false;
        }
        return this._totalNativeCalls == callsMappingStatistics._totalNativeCalls;
    }

    public CallsMappingStatistics() {
        this(null, 0, 3, null);
    }
}

