/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.openapi.project.Project;
import com.intellij.profiler.api.CompressedDumpsAware;
import com.intellij.profiler.api.ProfilerDumpFileParser;
import com.intellij.profiler.api.SignatureBasedProfilerDumpParserProvider;
import com.intellij.profiler.compressed.CompressedDumpParsePolicy;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.jfr.JFRDumpParserProvider;
import com.intellij.profiler.ultimate.jfr.JFRFileParser;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRDumpParserProvider;", "Lcom/intellij/profiler/api/SignatureBasedProfilerDumpParserProvider;", "Lcom/intellij/profiler/api/CompressedDumpsAware;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "name", "getName", "requiredFileExtension", "getRequiredFileExtension", "supportedFileSignatures", "", "", "getSupportedFileSignatures", "()Ljava/util/List;", "createParser", "Lcom/intellij/profiler/api/ProfilerDumpFileParser;", "project", "Lcom/intellij/openapi/project/Project;", "parsePolicy", "Lcom/intellij/profiler/compressed/CompressedDumpParsePolicy;", "getParsePolicy", "()Lcom/intellij/profiler/compressed/CompressedDumpParsePolicy;", "intellij.profiler.ultimate"})
public final class JFRDumpParserProvider
implements SignatureBasedProfilerDumpParserProvider,
CompressedDumpsAware {
    @NotNull
    private final String id;
    @NotNull
    private final String name = UltimateProfilerBundleKt.profilerMessage("jfr.dump.name", new Object[0]);
    @NotNull
    private final String requiredFileExtension;
    @NotNull
    private final List<byte[]> supportedFileSignatures;
    @NotNull
    private final CompressedDumpParsePolicy parsePolicy;

    public JFRDumpParserProvider() {
        this.id = "Java Flight Recorder Dump";
        this.requiredFileExtension = "jfr";
        byte[] byArray = "FLR\u0000".getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.supportedFileSignatures = CollectionsKt.listOf((Object)byArray);
        this.parsePolicy = (CompressedDumpParsePolicy)new CompressedDumpParsePolicy.Allow((Function1)parsePolicy.1.INSTANCE);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getRequiredFileExtension() {
        return this.requiredFileExtension;
    }

    @NotNull
    public List<byte[]> getSupportedFileSignatures() {
        return this.supportedFileSignatures;
    }

    @NotNull
    public ProfilerDumpFileParser createParser(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new JFRFileParser(project);
    }

    @NotNull
    public CompressedDumpParsePolicy getParsePolicy() {
        return this.parsePolicy;
    }
}

