/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.ultimate.model.BaseJavaMethodCall;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCModule;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001.B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u001f\u001a\u00020\u0006H\u0016J\u001d\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020!0\u00052\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0002\u0010$J\u001d\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0\u00052\u0006\u0010&\u001a\u00020'H\u0014\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0006H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010!2\u0006\u0010,\u001a\u00020-H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000e\u00a8\u0006/"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRMethodCall;", "Lcom/intellij/profiler/ultimate/model/BaseJavaMethodCall;", "frame", "Lorg/openjdk/jmc/common/IMCFrame;", "argumentTypes", "", "", "<init>", "(Lorg/openjdk/jmc/common/IMCFrame;[Ljava/lang/String;)V", "getArgumentTypes", "()[Ljava/lang/String;", "[Ljava/lang/String;", "fullPackageName", "getFullPackageName", "()Ljava/lang/String;", "className", "getClassName", "methodName", "getMethodName", "inlined", "", "getInlined", "()Z", "formalDescriptor", "getFormalDescriptor", "lineNumber", "", "getLineNumber", "()I", "moduleName", "getModuleName", "fullName", "calcNavigatables", "Lcom/intellij/psi/NavigatablePsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/psi/NavigatablePsiElement;", "findNavigatableMethod", "cls", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiClass;)[Lcom/intellij/psi/NavigatablePsiElement;", "copyWithCustomName", "name", "findNavigatableInFileByLine", "file", "Lcom/intellij/psi/PsiFile;", "JFRMethodCallWithCustomName", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJFRMethodCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRMethodCall.kt\ncom/intellij/profiler/ultimate/jfr/JFRMethodCall\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n13022#2,2:211\n13225#2,2:235\n37#3,2:213\n37#3,2:217\n37#3,2:238\n67#4:215\n1#5:216\n1#5:230\n1642#6,10:219\n1915#6:229\n1916#6:231\n1652#6:232\n777#6:233\n873#6:234\n874#6:237\n*S KotlinDebug\n*F\n+ 1 JFRMethodCall.kt\ncom/intellij/profiler/ultimate/jfr/JFRMethodCall\n*L\n62#1:211,2\n73#1:235,2\n86#1:213,2\n70#1:217,2\n75#1:238,2\n103#1:215\n71#1:230\n71#1:219,10\n71#1:229\n71#1:231\n71#1:232\n72#1:233\n72#1:234\n72#1:237\n*E\n"})
public class JFRMethodCall
extends BaseJavaMethodCall {
    @NotNull
    private final IMCFrame frame;
    @Nullable
    private final String[] argumentTypes;

    public JFRMethodCall(@NotNull IMCFrame frame, @Nullable String[] argumentTypes) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.frame = frame;
        this.argumentTypes = argumentTypes;
    }

    @Override
    @Nullable
    public String[] getArgumentTypes() {
        return this.argumentTypes;
    }

    @Override
    @NotNull
    public String getFullPackageName() {
        String string = this.frame.getMethod().getType().getPackage().getName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public String getClassName() {
        String string = this.frame.getMethod().getType().getTypeName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public String getMethodName() {
        String string = this.frame.getMethod().getMethodName();
        if (string == null) {
            string = "[unknown]";
        }
        return string;
    }

    @Override
    public boolean getInlined() {
        return this.frame.getType() == IMCFrame.Type.INLINED;
    }

    @Override
    @Nullable
    public String getFormalDescriptor() {
        return this.frame.getMethod().getFormalDescriptor();
    }

    public int getLineNumber() {
        Integer n = this.frame.getFrameLineNumber();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getFrameLineNumber(...)");
        return ((Number)n).intValue();
    }

    @Nullable
    public final String getModuleName() {
        IMCModule iMCModule = this.frame.getMethod().getType().getPackage().getModule();
        return iMCModule != null ? iMCModule.getName() : null;
    }

    @Override
    @NotNull
    public String fullName() {
        String[] stringArray;
        StringBuilder stringBuilder;
        StringBuilder $this$fullName_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (((CharSequence)this.getFullPackageName()).length() > 0) {
            stringArray = new String[]{this.getFullPackageName(), "."};
            StringsKt.append((StringBuilder)$this$fullName_u24lambda_u240, (String[])stringArray);
        }
        if (((CharSequence)this.getClassName()).length() > 0) {
            stringArray = new String[]{this.getClassName(), "."};
            StringsKt.append((StringBuilder)$this$fullName_u24lambda_u240, (String[])stringArray);
        }
        $this$fullName_u24lambda_u240.append(this.getMethodName());
        if (this.getArgumentTypes() != null) {
            $this$fullName_u24lambda_u240.append(this.argumentTypesString());
        }
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public NavigatablePsiElement[] calcNavigatables(@NotNull Project project) {
        boolean classesOrFiles;
        NavigatablePsiElement[] navigatables;
        block2: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            NavigatablePsiElement[] $this$all$iv = navigatables = super.calcNavigatables(project);
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                NavigatablePsiElement element$iv;
                NavigatablePsiElement it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (it instanceof PsiClass || it instanceof PsiFile) continue;
                bl = false;
                break block2;
            }
            bl = classesOrFiles = true;
        }
        if (!classesOrFiles) {
            return navigatables;
        }
        return (NavigatablePsiElement[])ActionsKt.runReadAction(() -> JFRMethodCall.calcNavigatables$lambda$1(this, project, navigatables));
    }

    @Override
    @NotNull
    protected NavigatablePsiElement[] findNavigatableMethod(@NotNull PsiClass cls) {
        Intrinsics.checkNotNullParameter((Object)cls, (String)"cls");
        NavigatablePsiElement[] res = super.findNavigatableMethod(cls);
        if (!(res.length == 0)) {
            return res;
        }
        if (DebuggerUtilsEx.isLambdaName((String)this.getMethodName())) {
            PsiFile file = cls.getNavigationElement().getContainingFile();
            List list = DebuggerUtilsEx.collectLambdas((SourcePosition)SourcePosition.createFromLine((PsiFile)file, (int)this.getLineNumber()), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"collectLambdas(...)");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return (NavigatablePsiElement[])thisCollection$iv.toArray(new PsiLambdaExpression[0]);
        }
        return new NavigatablePsiElement[0];
    }

    @Override
    @NotNull
    public JFRMethodCall copyWithCustomName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new JFRMethodCallWithCustomName(name, this.frame, this.getArgumentTypes());
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    private final NavigatablePsiElement findNavigatableInFileByLine(PsiFile file) {
        void $this$parentOfType$iv;
        Document document = file.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        Document document2 = document;
        int lineNumber = this.getLineNumber() - 1;
        if (!DocumentUtil.isValidLine((int)lineNumber, (Document)document2)) {
            return null;
        }
        int offset = document2.getLineStartOffset(lineNumber);
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        if (element instanceof PsiWhiteSpace || element instanceof PsiComment) {
            Class[] classArray = new Class[]{PsiWhiteSpace.class, PsiComment.class};
            PsiElement psiElement2 = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])classArray);
            if (psiElement2 == null) {
                psiElement2 = element;
            }
            element = psiElement2;
        }
        PsiElement psiElement3 = element;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, NavigatablePsiElement.class, (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    private static final NavigatablePsiElement[] calcNavigatables$lambda$1(JFRMethodCall this$0, Project $project, NavigatablePsiElement[] $navigatables) {
        NavigatablePsiElement[] navigatablePsiElementArray;
        void $this$filterTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        NavigatablePsiElement[] navigatablePsiElementArray2;
        Collection thisCollection$iv;
        List<PsiFile> files = this$0.findContainingFiles($project);
        if (files.isEmpty()) {
            return $navigatables;
        }
        NavigatablePsiElement[] navigatablePsiElementArray3 = $navigatables;
        if (navigatablePsiElementArray3.length == 0) {
            boolean bl = false;
            Collection $this$toTypedArray$iv = files;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            navigatablePsiElementArray2 = (NavigatablePsiElement[])thisCollection$iv.toArray(new PsiFile[0]);
        } else {
            navigatablePsiElementArray2 = navigatablePsiElementArray3;
        }
        NavigatablePsiElement[] fallbackResult = navigatablePsiElementArray2;
        Iterable $this$mapNotNull$iv = files;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$toTypedArray = $this$mapNotNull$iv;
        Iterable<NavigatablePsiElement> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            NavigatablePsiElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PsiFile it = (PsiFile)element$iv$iv;
            boolean bl2 = false;
            if (this$0.findNavigatableInFileByLine(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List targetsAtLine = (List)destination$iv$iv;
        Iterable $this$filter$iv = targetsAtLine;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block8: {
                NavigatablePsiElement targetsAtLine2 = (NavigatablePsiElement)element$iv$iv;
                boolean bl4 = false;
                NavigatablePsiElement[] $this$any$iv = $navigatables;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    NavigatablePsiElement element$iv;
                    NavigatablePsiElement it = element$iv = $this$any$iv[i];
                    boolean bl5 = false;
                    if (!SequencesKt.contains((Sequence)PsiTreeUtilKt.parents((PsiElement)((PsiElement)targetsAtLine2), (boolean)true), (Object)it)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List targetsInside = (List)destination$iv$iv2;
        Collection $this$toTypedArray$iv = targetsInside;
        boolean $i$f$toTypedArray2 = false;
        thisCollection$iv = $this$toTypedArray$iv;
        NavigatablePsiElement[] navigatablePsiElementArray4 = thisCollection$iv.toArray(new NavigatablePsiElement[0]);
        if (navigatablePsiElementArray4.length == 0) {
            boolean bl = false;
            navigatablePsiElementArray = fallbackResult;
        } else {
            navigatablePsiElementArray = navigatablePsiElementArray4;
        }
        return navigatablePsiElementArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRMethodCall$JFRMethodCallWithCustomName;", "Lcom/intellij/profiler/ultimate/jfr/JFRMethodCall;", "className", "", "frame", "Lorg/openjdk/jmc/common/IMCFrame;", "argumentTypes", "", "<init>", "(Ljava/lang/String;Lorg/openjdk/jmc/common/IMCFrame;[Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "intellij.profiler.ultimate"})
    private static final class JFRMethodCallWithCustomName
    extends JFRMethodCall {
        @NotNull
        private final String className;

        public JFRMethodCallWithCustomName(@NotNull String className, @NotNull IMCFrame frame, @Nullable String[] argumentTypes) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            super(frame, argumentTypes);
            this.className = className;
        }

        public /* synthetic */ JFRMethodCallWithCustomName(String string, IMCFrame iMCFrame, String[] stringArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                stringArray = null;
            }
            this(string, iMCFrame, stringArray);
        }

        @Override
        @NotNull
        public String getClassName() {
            return this.className;
        }
    }
}

