/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr.events;

import com.intellij.openapi.project.Project;
import com.intellij.profiler.api.AllocationSizeMetric;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.ultimate.jfr.events.JfrEvent;
import com.intellij.profiler.ultimate.jfr.events.JfrEventGroup;
import com.intellij.profiler.ultimate.jfr.events.JfrEventTypesBuilder;
import com.intellij.profiler.ultimate.jfr.events.JfrSamplingSingleEventTypeBuilder;
import com.intellij.profiler.ultimate.jfr.ui.JfrTimelineEventKind;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.MCFrame;
import org.openjdk.jmc.common.util.MCMethod;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.parser.ValueField;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bH\u0014\u00a2\u0006\u0002\u0010\u001dJ\u001a\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u001f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J'\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bH\u0014\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u000eH\u0002R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/intellij/profiler/ultimate/jfr/events/JfrMemoryAllocationEventTypeBuilder;", "Lcom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder;", "group", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventGroup;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/profiler/ultimate/jfr/events/JfrEventGroup;Lcom/intellij/openapi/project/Project;)V", "tlabSizeAccessor", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventTypesBuilder$DataStructureAccessorProvider$AccessorInfo;", "Lorg/openjdk/jmc/common/unit/ITypedQuantity;", "allocationSizeAccessor", "weightAccessor", "objectClassAccessor", "Lorg/openjdk/jmc/common/IMCType;", "fakeFrameCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/openjdk/jmc/common/IMCFrame;", "isCpuEvent", "", "()Z", "increment", "", "event", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEvent;", "values", "", "", "(Lcom/intellij/profiler/ultimate/jfr/events/JfrEvent;[Ljava/lang/Object;)J", "getSizeAccessor", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventTypesBuilder$DataStructureAccessor;", "getStack", "Lorg/openjdk/jmc/common/IMCStackTrace;", "(Lcom/intellij/profiler/ultimate/jfr/events/JfrEvent;[Ljava/lang/Object;)Lorg/openjdk/jmc/common/IMCStackTrace;", "fakeFrameWithObjectClass", "klass", "AllocationStackTrace", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJfrEventType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JfrEventType.kt\ncom/intellij/profiler/ultimate/jfr/events/JfrMemoryAllocationEventTypeBuilder\n+ 2 JfrEventType.kt\ncom/intellij/profiler/ultimate/jfr/events/JfrEventTypesBuilder\n*L\n1#1,843:1\n127#2,2:844\n127#2,2:846\n127#2,2:848\n127#2,2:850\n*S KotlinDebug\n*F\n+ 1 JfrEventType.kt\ncom/intellij/profiler/ultimate/jfr/events/JfrMemoryAllocationEventTypeBuilder\n*L\n792#1:844,2\n793#1:846,2\n794#1:848,2\n795#1:850,2\n*E\n"})
final class JfrMemoryAllocationEventTypeBuilder
extends JfrSamplingSingleEventTypeBuilder {
    @NotNull
    private final JfrEventTypesBuilder.DataStructureAccessorProvider.AccessorInfo<ITypedQuantity<?>> tlabSizeAccessor;
    @NotNull
    private final JfrEventTypesBuilder.DataStructureAccessorProvider.AccessorInfo<ITypedQuantity<?>> allocationSizeAccessor;
    @NotNull
    private final JfrEventTypesBuilder.DataStructureAccessorProvider.AccessorInfo<ITypedQuantity<?>> weightAccessor;
    @NotNull
    private final JfrEventTypesBuilder.DataStructureAccessorProvider.AccessorInfo<IMCType> objectClassAccessor;
    @NotNull
    private final ConcurrentHashMap<String, IMCFrame> fakeFrameCache;
    private final boolean isCpuEvent;

    public JfrMemoryAllocationEventTypeBuilder(@NotNull JfrEventGroup group, @Nullable Project project) {
        JfrEventTypesBuilder this_$iv$iv;
        JfrEventTypesBuilder this_$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        super(group, project, JfrTimelineEventKind.MEMORY);
        JfrEventTypesBuilder jfrEventTypesBuilder = this;
        Function1 predicate$iv = JfrMemoryAllocationEventTypeBuilder::tlabSizeAccessor$lambda$0;
        boolean $i$f$accessor = false;
        void var6_6 = this_$iv;
        List predicates$iv$iv = CollectionsKt.listOf((Object)predicate$iv);
        boolean $i$f$accessor2 = false;
        this.tlabSizeAccessor = JfrEventTypesBuilder.access$getAccessorProvider(this_$iv$iv).create(ITypedQuantity.class, predicates$iv$iv);
        this_$iv = this;
        predicate$iv = JfrMemoryAllocationEventTypeBuilder::allocationSizeAccessor$lambda$0;
        $i$f$accessor = false;
        this_$iv$iv = this_$iv;
        predicates$iv$iv = CollectionsKt.listOf((Object)predicate$iv);
        $i$f$accessor2 = false;
        this.allocationSizeAccessor = JfrEventTypesBuilder.access$getAccessorProvider(this_$iv$iv).create(ITypedQuantity.class, predicates$iv$iv);
        this_$iv = this;
        predicate$iv = JfrMemoryAllocationEventTypeBuilder::weightAccessor$lambda$0;
        $i$f$accessor = false;
        this_$iv$iv = this_$iv;
        predicates$iv$iv = CollectionsKt.listOf((Object)predicate$iv);
        $i$f$accessor2 = false;
        this.weightAccessor = JfrEventTypesBuilder.access$getAccessorProvider(this_$iv$iv).create(ITypedQuantity.class, predicates$iv$iv);
        this_$iv = this;
        predicate$iv = JfrMemoryAllocationEventTypeBuilder::objectClassAccessor$lambda$0;
        $i$f$accessor = false;
        this_$iv$iv = this_$iv;
        predicates$iv$iv = CollectionsKt.listOf((Object)predicate$iv);
        $i$f$accessor2 = false;
        this.objectClassAccessor = JfrEventTypesBuilder.access$getAccessorProvider(this_$iv$iv).create(IMCType.class, predicates$iv$iv);
        this.fakeFrameCache = new ConcurrentHashMap();
        this.setValueMetric((ValueMetric)AllocationSizeMetric.INSTANCE);
    }

    public /* synthetic */ JfrMemoryAllocationEventTypeBuilder(JfrEventGroup jfrEventGroup, Project project, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            project = null;
        }
        this(jfrEventGroup, project);
    }

    @Override
    public boolean isCpuEvent() {
        return this.isCpuEvent;
    }

    @Override
    protected long increment(@NotNull JfrEvent event, @NotNull Object[] values) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        ITypedQuantity<?> iTypedQuantity = this.getSizeAccessor(event).get(values);
        return iTypedQuantity != null ? iTypedQuantity.clampedLongValueIn(UnitLookup.BYTE) : 0L;
    }

    private final JfrEventTypesBuilder.DataStructureAccessor<ITypedQuantity<?>> getSizeAccessor(JfrEvent event) {
        return switch (WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
            case 1 -> this.tlabSizeAccessor.invoke(event);
            case 2 -> this.allocationSizeAccessor.invoke(event);
            case 3 -> this.weightAccessor.invoke(event);
            default -> throw new IllegalArgumentException("Not a memory event: " + event.getIdentifier());
        };
    }

    @Override
    @Nullable
    protected IMCStackTrace getStack(@NotNull JfrEvent event, @NotNull Object[] values) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        IMCStackTrace iMCStackTrace = super.getStack(event, values);
        if (iMCStackTrace == null) {
            return null;
        }
        IMCStackTrace stackWithoutObjectClass = iMCStackTrace;
        IMCType iMCType = this.objectClassAccessor.invoke(event).get(values);
        if (iMCType == null) {
            return null;
        }
        IMCType klass = iMCType;
        IMCFrame objectClassFrame = this.fakeFrameWithObjectClass(klass);
        return new AllocationStackTrace(stackWithoutObjectClass, objectClassFrame);
    }

    private final IMCFrame fakeFrameWithObjectClass(IMCType klass) {
        IMCFrame iMCFrame = this.fakeFrameCache.computeIfAbsent(klass.getTypeName(), arg_0 -> JfrMemoryAllocationEventTypeBuilder.fakeFrameWithObjectClass$lambda$1(arg_0 -> JfrMemoryAllocationEventTypeBuilder.fakeFrameWithObjectClass$lambda$0(klass, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)iMCFrame, (String)"computeIfAbsent(...)");
        return iMCFrame;
    }

    private static final boolean tlabSizeAccessor$lambda$0(ValueField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.matches(JdkAttributes.TLAB_SIZE);
    }

    private static final boolean allocationSizeAccessor$lambda$0(ValueField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.matches(JdkAttributes.ALLOCATION_SIZE);
    }

    private static final boolean weightAccessor$lambda$0(ValueField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.matches(JdkAttributes.SAMPLE_WEIGHT);
    }

    private static final boolean objectClassAccessor$lambda$0(ValueField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getIdentifier(), (Object)"objectClass");
    }

    private static final IMCFrame fakeFrameWithObjectClass$lambda$0(IMCType $klass, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MCMethod method = new MCMethod($klass, "new", "()L;", 256, true);
        return new MCFrame(method, -1, -1, IMCFrame.Type.UNKNOWN);
    }

    private static final IMCFrame fakeFrameWithObjectClass$lambda$1(Function1 $tmp0, Object p0) {
        return (IMCFrame)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\t\u0010\u000b\u001a\u00020\u0001H\u00c2\u0003J\t\u0010\f\u001a\u00020\u0004H\u00c2\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0014\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/ultimate/jfr/events/JfrMemoryAllocationEventTypeBuilder$AllocationStackTrace;", "Lorg/openjdk/jmc/common/IMCStackTrace;", "baseStack", "frame", "Lorg/openjdk/jmc/common/IMCFrame;", "<init>", "(Lorg/openjdk/jmc/common/IMCStackTrace;Lorg/openjdk/jmc/common/IMCFrame;)V", "getFrames", "", "getTruncationState", "Lorg/openjdk/jmc/common/IMCStackTrace$TruncationState;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.profiler.ultimate"})
    private static final class AllocationStackTrace
    implements IMCStackTrace {
        @NotNull
        private final IMCStackTrace baseStack;
        @NotNull
        private final IMCFrame frame;

        public AllocationStackTrace(@NotNull IMCStackTrace baseStack, @NotNull IMCFrame frame) {
            Intrinsics.checkNotNullParameter((Object)baseStack, (String)"baseStack");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            this.baseStack = baseStack;
            this.frame = frame;
        }

        @NotNull
        public List<IMCFrame> getFrames() {
            Collection collection = CollectionsKt.listOf((Object)this.frame);
            List<? extends IMCFrame> list = this.baseStack.getFrames();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getFrames(...)");
            return CollectionsKt.plus((Collection)collection, (Iterable)list);
        }

        @Override
        @NotNull
        public IMCStackTrace.TruncationState getTruncationState() {
            IMCStackTrace.TruncationState truncationState = this.baseStack.getTruncationState();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)truncationState), (String)"getTruncationState(...)");
            return truncationState;
        }

        private final IMCStackTrace component1() {
            return this.baseStack;
        }

        private final IMCFrame component2() {
            return this.frame;
        }

        @NotNull
        public final AllocationStackTrace copy(@NotNull IMCStackTrace baseStack, @NotNull IMCFrame frame) {
            Intrinsics.checkNotNullParameter((Object)baseStack, (String)"baseStack");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            return new AllocationStackTrace(baseStack, frame);
        }

        public static /* synthetic */ AllocationStackTrace copy$default(AllocationStackTrace allocationStackTrace, IMCStackTrace iMCStackTrace, IMCFrame iMCFrame, int n, Object object) {
            if ((n & 1) != 0) {
                iMCStackTrace = allocationStackTrace.baseStack;
            }
            if ((n & 2) != 0) {
                iMCFrame = allocationStackTrace.frame;
            }
            return allocationStackTrace.copy(iMCStackTrace, iMCFrame);
        }

        @NotNull
        public String toString() {
            return "AllocationStackTrace(baseStack=" + this.baseStack + ", frame=" + this.frame + ")";
        }

        public int hashCode() {
            int result = this.baseStack.hashCode();
            result = result * 31 + this.frame.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AllocationStackTrace)) {
                return false;
            }
            AllocationStackTrace allocationStackTrace = (AllocationStackTrace)other;
            if (!Intrinsics.areEqual((Object)this.baseStack, (Object)allocationStackTrace.baseStack)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.frame, (Object)allocationStackTrace.frame);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JfrEvent.values().length];
            try {
                nArray[JfrEvent.ALLOC_INSIDE_TLAB.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JfrEvent.ALLOC_OUTSIDE_TLAB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JfrEvent.OBJECT_ALLOCATION_SAMPLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

