/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.jps.JpsProjectConfigLocation;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.ContentRootEntityBuilder;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntityBuilder;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.AbstractEclipseClasspathReader;
import org.jetbrains.idea.eclipse.EPathCommonUtil;
import org.jetbrains.idea.eclipse.config.EclipseModuleRootsSerializer;
import org.jetbrains.idea.eclipse.config.EclipseProjectFile;
import org.jetbrains.idea.eclipse.config.ModulePathShortener;
import org.jetbrains.idea.eclipse.config.ModuleRelativePathResolver;
import org.jetbrains.idea.eclipse.conversion.EJavadocUtil;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a*\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0018\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0000\u001a*\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a(\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\"\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\"\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\b\u0010(\u001a\u0004\u0018\u00010\u00052\u0006\u0010)\u001a\u00020\u000bH\u0000\u001a*\u0010*\u001a\u0004\u0018\u00010\u00052\u0006\u0010+\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0016\u0010.\u001a\u0004\u0018\u00010\u00052\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010!\u001a\u0004\u0018\u00010\u001e*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\"\u001a\u0010!\u001a\u0004\u0018\u00010$*\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010%\u00a8\u00062"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "convertToJavadocUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "originalPath", "", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntityBuilder;", "relativePathResolver", "Lorg/jetbrains/idea/eclipse/config/ModuleRelativePathResolver;", "virtualUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "convertToEclipseJavadocPath", "javadocRoot", "module", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "projectLocation", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "pathShortener", "Lorg/jetbrains/idea/eclipse/config/ModulePathShortener;", "convertToRootUrl", "path", "pathToUrl", "convertVariablePathToUrl", "pathMap", "Lcom/intellij/openapi/components/ExpandMacroToPathMap;", "varStart", "", "convertRelativePathToUrl", "contentRootEntity", "Lcom/intellij/platform/workspace/jps/entities/ContentRootEntityBuilder;", "pathResolver", "findFileUnderContentRoot", "mainContentRoot", "getMainContentRoot", "(Lcom/intellij/platform/workspace/jps/entities/ModuleEntityBuilder;)Lcom/intellij/platform/workspace/jps/entities/ContentRootEntityBuilder;", "Lcom/intellij/platform/workspace/jps/entities/ContentRootEntity;", "(Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;)Lcom/intellij/platform/workspace/jps/entities/ContentRootEntity;", "getStorageRoot", "imlFileUrl", "customDir", "virtualFileManager", "convertToEclipsePath", "fileUrl", "entitySource", "Lorg/jetbrains/idea/eclipse/config/EclipseProjectFile;", "convertToEclipsePathWithVariable", "roots", "", "Lcom/intellij/platform/workspace/jps/entities/LibraryRoot;", "intellij.eclipse"})
@SourceDebugExtension(value={"SMAP\npathConversion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pathConversion.kt\norg/jetbrains/idea/eclipse/config/PathConversionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,288:1\n296#2,2:289\n296#2,2:291\n1915#2,2:294\n1#3:293\n13#4:296\n*S KotlinDebug\n*F\n+ 1 pathConversion.kt\norg/jetbrains/idea/eclipse/config/PathConversionKt\n*L\n204#1:289,2\n209#1:291,2\n271#1:294,2\n33#1:296\n*E\n"})
public final class PathConversionKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final VirtualFileUrl convertToJavadocUrl(@NotNull String originalPath, @NotNull ModuleEntityBuilder moduleEntity, @NotNull ModuleRelativePathResolver relativePathResolver, @NotNull VirtualFileUrlManager virtualUrlManager) {
        String javadocPath;
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter((Object)relativePathResolver, (String)"relativePathResolver");
        Intrinsics.checkNotNullParameter((Object)virtualUrlManager, (String)"virtualUrlManager");
        String string = javadocPath = !SystemInfo.isWindows ? StringsKt.replaceFirst$default((String)originalPath, (String)"file:/", (String)"file://", (boolean)false, (int)4, null) : originalPath;
        if (StringsKt.startsWith$default((String)javadocPath, (String)"file:/", (boolean)false, (int)2, null)) {
            String path = StringsKt.removePrefix((String)javadocPath, (CharSequence)"file:/");
            if (new File(path).exists()) {
                return virtualUrlManager.getOrCreateFromUrl(PathConversionKt.pathToUrl(path));
            }
        } else {
            String protocol = VirtualFileManager.extractProtocol((String)javadocPath);
            if (Intrinsics.areEqual((Object)protocol, (Object)HttpFileSystem.getInstance().getProtocol())) {
                return virtualUrlManager.getOrCreateFromUrl(javadocPath);
            }
            if (StringsKt.startsWith$default((String)javadocPath, (String)"jar:", (boolean)false, (int)2, null)) {
                String jarJavadocPath = StringsKt.removePrefix((String)javadocPath, (CharSequence)"jar:");
                if (StringsKt.startsWith$default((String)jarJavadocPath, (String)"platform:/", (boolean)false, (int)2, null)) {
                    Object basePath;
                    String currentModulePath;
                    String string2 = jarJavadocPath.substring(18);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String relativeToPlatform = string2;
                    ContentRootEntityBuilder contentRootEntityBuilder = PathConversionKt.getMainContentRoot(moduleEntity);
                    VirtualFile currentRoot = contentRootEntityBuilder != null && (contentRootEntityBuilder = contentRootEntityBuilder.getUrl()) != null ? VirtualFileUrls.getVirtualFile((VirtualFileUrl)contentRootEntityBuilder) : null;
                    Object object = currentRoot;
                    if (object == null || (object = object.getParent()) == null || (object = object.getPath()) == null) {
                        EntitySource entitySource = moduleEntity.getEntitySource();
                        Intrinsics.checkNotNull((Object)entitySource, (String)"null cannot be cast to non-null type org.jetbrains.idea.eclipse.config.EclipseProjectFile");
                        object = JpsPathUtil.urlToPath((String)((EclipseProjectFile)entitySource).getProjectLocation$intellij_eclipse().getBaseDirectoryUrl().getUrl());
                    }
                    if (EJavadocUtil.isJarFileExist(currentModulePath = (String)(basePath = object) + relativeToPlatform)) {
                        String string3 = VirtualFileManager.constructUrl((String)"jar", (String)currentModulePath);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"constructUrl(...)");
                        return virtualUrlManager.getOrCreateFromUrl(string3);
                    }
                    String string4 = EPathCommonUtil.getRelativeModuleName((String)relativeToPlatform);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getRelativeModuleName(...)");
                    String moduleName = string4;
                    String relativeToModulePathWithJarSuffix = EPathCommonUtil.getRelativeToModulePath((String)relativeToPlatform);
                    String relativeToModulePath = EJavadocUtil.stripPathInsideJar(relativeToModulePathWithJarSuffix);
                    Object url = null;
                    if (!Intrinsics.areEqual((Object)moduleName, (Object)moduleEntity.getName())) {
                        url = relativePathResolver.resolve(moduleName, relativeToModulePath);
                    }
                    if (url != null) {
                        boolean bl;
                        boolean bl2 = bl = relativeToModulePathWithJarSuffix != null;
                        if (_Assertions.ENABLED && !bl) {
                            String string5 = "Assertion failed";
                            throw new AssertionError((Object)string5);
                        }
                        boolean bl3 = bl = relativeToModulePath != null;
                        if (_Assertions.ENABLED && !bl) {
                            String string6 = "Assertion failed";
                            throw new AssertionError((Object)string6);
                        }
                        String string7 = relativeToModulePath;
                        Intrinsics.checkNotNull((Object)string7);
                        int n = string7.length();
                        String string8 = relativeToModulePathWithJarSuffix;
                        Intrinsics.checkNotNull((Object)string8);
                        if (n < string8.length()) {
                            String string9 = relativeToModulePathWithJarSuffix.substring(relativeToModulePath.length());
                            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                            url = (String)url + string9;
                        }
                        String string10 = VirtualFileManager.constructUrl((String)"jar", (String)VfsUtil.urlToPath((String)url));
                        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"constructUrl(...)");
                        return virtualUrlManager.getOrCreateFromUrl(string10);
                    }
                } else if (StringsKt.startsWith$default((String)jarJavadocPath, (String)"file:/", (boolean)false, (int)2, null)) {
                    String string11 = jarJavadocPath.substring(6);
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"substring(...)");
                    String localFile = string11;
                    if (EJavadocUtil.isJarFileExist(localFile)) {
                        String string12 = VirtualFileManager.constructUrl((String)"jar", (String)localFile);
                        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"constructUrl(...)");
                        return virtualUrlManager.getOrCreateFromUrl(string12);
                    }
                }
            }
        }
        return virtualUrlManager.getOrCreateFromUrl(javadocPath);
    }

    @Nullable
    public static final String convertToEclipseJavadocPath(@NotNull VirtualFileUrl javadocRoot, @NotNull ModuleEntity module, @NotNull JpsProjectConfigLocation projectLocation, @NotNull ModulePathShortener pathShortener) {
        Intrinsics.checkNotNullParameter((Object)javadocRoot, (String)"javadocRoot");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)projectLocation, (String)"projectLocation");
        Intrinsics.checkNotNullParameter((Object)pathShortener, (String)"pathShortener");
        String javadocUrl = javadocRoot.getUrl();
        String protocol = VirtualFileManager.extractProtocol((String)javadocUrl);
        if (!Intrinsics.areEqual((Object)protocol, (Object)HttpFileSystem.getInstance().getProtocol())) {
            VirtualFile baseDir;
            VirtualFile contentRoot;
            String string = VfsUtil.urlToPath((String)javadocUrl);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlToPath(...)");
            String path = string;
            ContentRootEntity contentRootEntity = PathConversionKt.getMainContentRoot(module);
            VirtualFile virtualFile = contentRoot = contentRootEntity != null && (contentRootEntity = contentRootEntity.getUrl()) != null ? VirtualFileUrls.getVirtualFile((VirtualFileUrl)contentRootEntity) : null;
            VirtualFile virtualFile2 = baseDir = virtualFile != null ? virtualFile.getParent() : VirtualFileUrls.getVirtualFile((VirtualFileUrl)projectLocation.getBaseDirectoryUrl());
            if (Intrinsics.areEqual((Object)protocol, (Object)JarFileSystem.getInstance().getProtocol())) {
                VirtualFile javadocFile = JarFileSystem.getInstance().getVirtualFileForJar(VirtualFileUrls.getVirtualFile((VirtualFileUrl)javadocRoot));
                if (javadocFile != null) {
                    String relativeUrl;
                    String string2 = relativeUrl = contentRoot != null && baseDir != null && VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)javadocFile, (boolean)false) ? "/" + VfsUtilCore.getRelativePath((VirtualFile)javadocFile, (VirtualFile)baseDir, (char)'/') : pathShortener.shortenPath(javadocFile);
                    if (relativeUrl != null) {
                        Object javadocPath = javadocUrl;
                        String string3 = javadocPath;
                        Intrinsics.checkNotNull((Object)string3);
                        if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"!/", (boolean)false, (int)2, null)) {
                            string3 = javadocPath;
                            Intrinsics.checkNotNull((Object)string3);
                            javadocPath = StringsKt.removeSuffix((String)string3, (CharSequence)"/") + "!/";
                        }
                        string3 = javadocPath;
                        Intrinsics.checkNotNull((Object)string3);
                        int n = javadocFile.getUrl().length() - 1;
                        String string4 = string3.substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        return "jar:platform:/resource" + relativeUrl + string4;
                    }
                    return "jar:file:/" + StringsKt.removePrefix((String)path, (CharSequence)"/");
                }
                return "jar:file:/" + StringsKt.removePrefix((String)path, (CharSequence)"/");
            }
            if (new File(path).exists()) {
                return "file:/" + StringsKt.removePrefix((String)path, (CharSequence)"/");
            }
        }
        return javadocUrl;
    }

    @NotNull
    public static final VirtualFileUrl convertToRootUrl(@NotNull String path, @NotNull VirtualFileUrlManager virtualUrlManager) {
        VirtualFile jarFile;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)virtualUrlManager, (String)"virtualUrlManager");
        String url = PathConversionKt.pathToUrl(path);
        VirtualFile localFile = VirtualFileManager.getInstance().findFileByUrl(url);
        if (localFile != null && (jarFile = JarFileSystem.getInstance().getJarRootForLocalFile(localFile)) != null) {
            String string = jarFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            return virtualUrlManager.getOrCreateFromUrl(string);
        }
        return virtualUrlManager.getOrCreateFromUrl(url);
    }

    @NotNull
    public static final String pathToUrl(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = JpsPathUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)path));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathToUrl(...)");
        return string;
    }

    @NotNull
    public static final VirtualFileUrl convertVariablePathToUrl(@NotNull ExpandMacroToPathMap pathMap, @Nullable String path, int varStart, @NotNull VirtualFileUrlManager virtualUrlManager) {
        Intrinsics.checkNotNullParameter((Object)pathMap, (String)"pathMap");
        Intrinsics.checkNotNullParameter((Object)virtualUrlManager, (String)"virtualUrlManager");
        AbstractEclipseClasspathReader.EPathVariable variable = AbstractEclipseClasspathReader.createEPathVariable((String)path, (int)varStart);
        String string = AbstractEclipseClasspathReader.getVariableRelatedPath((String)variable.getVariable(), (String)variable.getRelatedPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVariableRelatedPath(...)");
        String pathWithVariable = string;
        String string2 = pathMap.substitute(pathWithVariable, SystemInfo.isFileSystemCaseSensitive);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substitute(...)");
        return PathConversionKt.convertToRootUrl(string2, virtualUrlManager);
    }

    @NotNull
    public static final VirtualFileUrl convertRelativePathToUrl(@NotNull String path, @NotNull ContentRootEntityBuilder contentRootEntity, @NotNull ModuleRelativePathResolver pathResolver, @NotNull VirtualFileUrlManager virtualUrlManager) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)contentRootEntity, (String)"contentRootEntity");
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        Intrinsics.checkNotNullParameter((Object)virtualUrlManager, (String)"virtualUrlManager");
        if (((CharSequence)path).length() == 0 || !new File(path).exists()) {
            if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
                String url;
                String string = EPathCommonUtil.getRelativeModuleName((String)path);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRelativeModuleName(...)");
                String moduleName = string;
                String relativeToRootPath = EPathCommonUtil.getRelativeToModulePath((String)path);
                if (!Intrinsics.areEqual((Object)moduleName, (Object)contentRootEntity.getModule().getName()) && (url = pathResolver.resolve(moduleName, relativeToRootPath)) != null) {
                    return virtualUrlManager.getOrCreateFromUrl(url);
                }
            } else {
                VirtualFileUrl url = PathConversionKt.findFileUnderContentRoot(path, contentRootEntity, virtualUrlManager);
                if (url != null) {
                    return url;
                }
            }
        }
        return PathConversionKt.convertToRootUrl(path, virtualUrlManager);
    }

    private static final VirtualFileUrl findFileUnderContentRoot(String path, ContentRootEntityBuilder contentRootEntity, VirtualFileUrlManager virtualUrlManager) {
        VirtualFileUrl virtualFileUrl;
        File file;
        File root = VirtualFileUrlManagerUtil.toPath((VirtualFileUrl)contentRootEntity.getUrl()).toFile();
        if (root.exists()) {
            file = root;
        } else {
            VirtualFileUrl fileUrl;
            ContentRootEntityBuilder contentRootEntityBuilder = PathConversionKt.getMainContentRoot(contentRootEntity.getModule());
            VirtualFileUrl virtualFileUrl2 = fileUrl = contentRootEntityBuilder != null ? contentRootEntityBuilder.getUrl() : null;
            file = virtualFileUrl2 != null ? VirtualFileUrlManagerUtil.toPath((VirtualFileUrl)virtualFileUrl2).toFile() : null;
        }
        File mainRoot = file;
        File file2 = new File(mainRoot, path);
        if (file2.exists()) {
            String string = file2.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            virtualFileUrl = PathConversionKt.convertToRootUrl(string, virtualUrlManager);
        } else {
            virtualFileUrl = null;
        }
        return virtualFileUrl;
    }

    @Nullable
    public static final ContentRootEntityBuilder getMainContentRoot(@NotNull ModuleEntityBuilder $this$mainContentRoot) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$mainContentRoot, (String)"<this>");
            Iterable $this$firstOrNull$iv = $this$mainContentRoot.getContentRoots();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ContentRootEntityBuilder it = (ContentRootEntityBuilder)element$iv;
                boolean bl = false;
                VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(it.getUrl().getUrl());
                if (!((virtualFile != null ? virtualFile.findChild(".project") : null) != null)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public static final ContentRootEntity getMainContentRoot(@NotNull ModuleEntity $this$mainContentRoot) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$mainContentRoot, (String)"<this>");
            Iterable $this$firstOrNull$iv = $this$mainContentRoot.getContentRoots();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ContentRootEntity it = (ContentRootEntity)element$iv;
                boolean bl = false;
                VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(it.getUrl().getUrl());
                if (!((virtualFile != null ? virtualFile.findChild(".project") : null) != null)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public static final VirtualFileUrl getStorageRoot(@NotNull VirtualFileUrl imlFileUrl, @Nullable String customDir, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter((Object)imlFileUrl, (String)"imlFileUrl");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        VirtualFileUrl virtualFileUrl = imlFileUrl.getParent();
        Intrinsics.checkNotNull((Object)virtualFileUrl);
        VirtualFileUrl moduleRoot = virtualFileUrl;
        if (customDir == null) {
            return moduleRoot;
        }
        if (OSAgnosticPathUtil.isAbsolute((String)customDir)) {
            String string = VfsUtilCore.pathToUrl((String)customDir);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathToUrl(...)");
            return virtualFileManager.getOrCreateFromUrl(string);
        }
        VirtualFileUrl virtualFileUrl2 = moduleRoot.append(customDir);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl2, (String)"append(...)");
        return virtualFileUrl2;
    }

    @Nullable
    public static final String convertToEclipsePath(@NotNull VirtualFileUrl fileUrl, @NotNull ModuleEntity moduleEntity, @NotNull EclipseProjectFile entitySource, @NotNull ModulePathShortener pathShortener) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter((Object)entitySource, (String)"entitySource");
        Intrinsics.checkNotNullParameter((Object)pathShortener, (String)"pathShortener");
        ContentRootEntity contentRootEntity = PathConversionKt.getMainContentRoot(moduleEntity);
        if (contentRootEntity != null) {
            ContentRootEntity it = contentRootEntity;
            boolean bl = false;
            virtualFile = VirtualFileManager.getInstance().findFileByUrl(it.getUrl().getUrl());
        } else {
            virtualFile = null;
        }
        VirtualFile contentRoot = virtualFile;
        VirtualFile file = VirtualFileUrls.getVirtualFile((VirtualFileUrl)fileUrl);
        String url = fileUrl.getUrl();
        if (file != null) {
            LOG.assertTrue(file.isValid());
            if (file.getFileSystem() instanceof JarFileSystem) {
                VirtualFile jarFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
                if (jarFile == null) {
                    LOG.error("Url: '" + url + "'; file: " + file);
                    Intrinsics.checkNotNull((Object)url);
                    return ProjectRootManagerImpl.Companion.extractLocalPath(url);
                }
                file = jarFile;
            }
            if (contentRoot != null && VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) {
                return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot, (char)'/');
            }
            String path = pathShortener.shortenPath(file);
            if (path != null) {
                return path;
            }
        } else {
            VirtualFile virtualFile2;
            if (contentRoot != null) {
                String string = contentRoot.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                String rootUrl = string;
                Intrinsics.checkNotNull((Object)url);
                if (StringsKt.startsWith$default((String)url, (String)rootUrl, (boolean)false, (int)2, null) && url.length() > rootUrl.length()) {
                    String string2 = url.substring(rootUrl.length() + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    return string2;
                }
            }
            VirtualFile virtualFile3 = contentRoot;
            if (virtualFile3 != null) {
                virtualFile2 = virtualFile3.getParent();
            } else {
                VirtualFile virtualFile4 = VirtualFileUrls.getVirtualFile((VirtualFileUrl)entitySource.getProjectLocation$intellij_eclipse().getBaseDirectoryUrl());
                virtualFile2 = virtualFile4;
                Intrinsics.checkNotNull((Object)virtualFile4);
            }
            VirtualFile projectBaseDir = virtualFile2;
            String string = projectBaseDir.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            String projectUrl = string;
            Intrinsics.checkNotNull((Object)url);
            if (StringsKt.startsWith$default((String)url, (String)projectUrl, (boolean)false, (int)2, null)) {
                String string3 = url.substring(projectUrl.length());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                return string3;
            }
            String string4 = VfsUtilCore.urlToPath((String)url);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"urlToPath(...)");
            String path = string4;
            String string5 = projectBaseDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getPath(...)");
            String projectPath = string5;
            if (StringsKt.startsWith$default((String)path, (String)projectPath, (boolean)false, (int)2, null)) {
                String string6 = path.substring(projectPath.length());
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                return ProjectRootManagerImpl.Companion.extractLocalPath(string6);
            }
        }
        Intrinsics.checkNotNull((Object)url);
        return ProjectRootManagerImpl.Companion.extractLocalPath(url);
    }

    @Nullable
    public static final String convertToEclipsePathWithVariable(@NotNull List<LibraryRoot> roots) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Iterable $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map pathMacros;
            String filePath;
            LibraryRoot root = (LibraryRoot)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)VirtualFileManager.extractPath((String)root.getUrl().getUrl()), (String)"extractPath(...)");
            int jarSeparatorIdx = StringsKt.indexOf$default((CharSequence)filePath, (String)"!/", (int)0, (boolean)false, (int)6, null);
            if (jarSeparatorIdx > -1) {
                String string = filePath.substring(0, jarSeparatorIdx);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                filePath = string;
            }
            Intrinsics.checkNotNullExpressionValue((Object)PathMacros.getInstance().getUserMacros(), (String)"getUserMacros(...)");
            for (String name : pathMacros.keySet()) {
                String path;
                Object v = pathMacros.get(name);
                Intrinsics.checkNotNull(v);
                Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)((String)v)), (String)"toSystemIndependentName(...)");
                if (!StringsKt.startsWith$default((String)filePath, (String)(path + "/"), (boolean)false, (int)2, null)) continue;
                String string = filePath.substring(path.length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String substr = string;
                return name + (String)(StringsKt.startsWith$default((String)substr, (String)"/", (boolean)false, (int)2, null) || ((CharSequence)substr).length() == 0 ? substr : "/" + substr);
            }
        }
        return null;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EclipseModuleRootsSerializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

