/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.fs.telemetry;

import com.intellij.platform.eel.impl.fs.telemetry.Measurer;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/eel/impl/fs/telemetry/FsQueryStatCounter;", "", "<init>", "()V", "uniquePaths", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/platform/eel/impl/fs/telemetry/FsQueryStatCounter$FsQuery;", "Ljava/time/Instant;", "repeatedTime", "Ljava/time/Duration;", "delegate", "Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$DelegateType;", "path1", "Ljava/nio/file/Path;", "path2", "operation", "Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$Operation;", "startTime", "endTime", "success", "", "FsQuery", "intellij.platform.eel.impl"})
@ApiStatus.Internal
public final class FsQueryStatCounter {
    @NotNull
    private final ConcurrentMap<FsQuery, Instant> uniquePaths = new ConcurrentHashMap();

    @Nullable
    public final Duration repeatedTime(@NotNull Measurer.DelegateType delegate, @Nullable Path path1, @Nullable Path path2, @NotNull Measurer.Operation operation, @NotNull Instant startTime, @NotNull Instant endTime, boolean success) {
        Intrinsics.checkNotNullParameter((Object)((Object)delegate), (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        FsQuery key = new FsQuery(delegate, operation, success, path1, path2);
        Instant prevEndTime = this.uniquePaths.put(key, endTime);
        if (prevEndTime == null) {
            return null;
        }
        return Duration.between(prevEndTime, startTime);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u00c6\u0003J?\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0014\u0010\u001c\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001e\u001a\u00020\u001fH\u00d6\u0081\u0004J\n\u0010 \u001a\u00020!H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/intellij/platform/eel/impl/fs/telemetry/FsQueryStatCounter$FsQuery;", "", "delegate", "Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$DelegateType;", "operation", "Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$Operation;", "success", "", "path1", "Ljava/nio/file/Path;", "path2", "<init>", "(Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$DelegateType;Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$Operation;ZLjava/nio/file/Path;Ljava/nio/file/Path;)V", "getDelegate", "()Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$DelegateType;", "getOperation", "()Lcom/intellij/platform/eel/impl/fs/telemetry/Measurer$Operation;", "getSuccess", "()Z", "getPath1", "()Ljava/nio/file/Path;", "getPath2", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.eel.impl"})
    public static final class FsQuery {
        @NotNull
        private final Measurer.DelegateType delegate;
        @NotNull
        private final Measurer.Operation operation;
        private final boolean success;
        @Nullable
        private final Path path1;
        @Nullable
        private final Path path2;

        public FsQuery(@NotNull Measurer.DelegateType delegate, @NotNull Measurer.Operation operation, boolean success, @Nullable Path path1, @Nullable Path path2) {
            Intrinsics.checkNotNullParameter((Object)((Object)delegate), (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            this.delegate = delegate;
            this.operation = operation;
            this.success = success;
            this.path1 = path1;
            this.path2 = path2;
        }

        @NotNull
        public final Measurer.DelegateType getDelegate() {
            return this.delegate;
        }

        @NotNull
        public final Measurer.Operation getOperation() {
            return this.operation;
        }

        public final boolean getSuccess() {
            return this.success;
        }

        @Nullable
        public final Path getPath1() {
            return this.path1;
        }

        @Nullable
        public final Path getPath2() {
            return this.path2;
        }

        @NotNull
        public final Measurer.DelegateType component1() {
            return this.delegate;
        }

        @NotNull
        public final Measurer.Operation component2() {
            return this.operation;
        }

        public final boolean component3() {
            return this.success;
        }

        @Nullable
        public final Path component4() {
            return this.path1;
        }

        @Nullable
        public final Path component5() {
            return this.path2;
        }

        @NotNull
        public final FsQuery copy(@NotNull Measurer.DelegateType delegate, @NotNull Measurer.Operation operation, boolean success, @Nullable Path path1, @Nullable Path path2) {
            Intrinsics.checkNotNullParameter((Object)((Object)delegate), (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            return new FsQuery(delegate, operation, success, path1, path2);
        }

        public static /* synthetic */ FsQuery copy$default(FsQuery fsQuery, Measurer.DelegateType delegateType, Measurer.Operation operation, boolean bl, Path path, Path path2, int n, Object object) {
            if ((n & 1) != 0) {
                delegateType = fsQuery.delegate;
            }
            if ((n & 2) != 0) {
                operation = fsQuery.operation;
            }
            if ((n & 4) != 0) {
                bl = fsQuery.success;
            }
            if ((n & 8) != 0) {
                path = fsQuery.path1;
            }
            if ((n & 0x10) != 0) {
                path2 = fsQuery.path2;
            }
            return fsQuery.copy(delegateType, operation, bl, path, path2);
        }

        @NotNull
        public String toString() {
            return "FsQuery(delegate=" + this.delegate + ", operation=" + this.operation + ", success=" + this.success + ", path1=" + this.path1 + ", path2=" + this.path2 + ")";
        }

        public int hashCode() {
            int result = this.delegate.hashCode();
            result = result * 31 + this.operation.hashCode();
            result = result * 31 + Boolean.hashCode(this.success);
            result = result * 31 + (this.path1 == null ? 0 : ((Object)this.path1).hashCode());
            result = result * 31 + (this.path2 == null ? 0 : ((Object)this.path2).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FsQuery)) {
                return false;
            }
            FsQuery fsQuery = (FsQuery)other;
            if (this.delegate != fsQuery.delegate) {
                return false;
            }
            if (this.operation != fsQuery.operation) {
                return false;
            }
            if (this.success != fsQuery.success) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path1, (Object)fsQuery.path1)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.path2, (Object)fsQuery.path2);
        }
    }
}

