/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.move;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.util.GroovyChangeContextUtil;

public final class MoveGroovyClassHandler
implements MoveClassHandler {
    private static final Logger LOG = Logger.getInstance(MoveGroovyClassHandler.class);

    public PsiClass doMoveClass(@NotNull PsiClass aClass, @NotNull PsiDirectory moveDestination) throws IncorrectOperationException {
        if (aClass == null) {
            MoveGroovyClassHandler.$$$reportNull$$$0(0);
        }
        if (moveDestination == null) {
            MoveGroovyClassHandler.$$$reportNull$$$0(1);
        }
        if (!aClass.getLanguage().equals((Object)GroovyLanguage.INSTANCE)) {
            return null;
        }
        PsiFile file = aClass.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return null;
        }
        PsiPackage newPackage = JavaDirectoryService.getInstance().getPackage(moveDestination);
        LOG.assertTrue(newPackage != null);
        PsiClass newClass = null;
        String newPackageName = newPackage.getQualifiedName();
        if (aClass instanceof GroovyScriptClass) {
            PsiClass[] classes = ((GroovyFile)file).getClasses();
            if (classes.length == 1) {
                if (!moveDestination.equals((Object)file.getContainingDirectory())) {
                    Project project = file.getProject();
                    MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)file, (PsiDirectory)moveDestination);
                    DumbService.getInstance((Project)project).completeJustSubmittedTasks();
                    file = moveDestination.findFile(file.getName());
                    assert (file != null);
                    ((PsiClassOwner)file).setPackageName(newPackageName);
                }
                return ((GroovyFile)file).getScriptClass();
            }
            MoveGroovyClassHandler.correctSelfReferences(aClass, newPackage);
            GroovyFile newFile = MoveGroovyClassHandler.generateNewScript((GroovyFile)file, newPackage);
            for (PsiElement child : file.getChildren()) {
                GrDocCommentOwner owner;
                if (!(child instanceof GrTopStatement) && !(child instanceof PsiComment) || child instanceof PsiClass || child instanceof GrImportStatement || child instanceof GrPackageDefinition || child instanceof GrDocComment && (owner = GrDocCommentUtil.findDocOwner((GrDocComment)child)) instanceof PsiClass) continue;
                child.delete();
            }
            if (!moveDestination.equals((Object)file.getContainingDirectory())) {
                moveDestination.add((PsiElement)newFile);
            }
            newClass = newFile.getClasses()[0];
            MoveGroovyClassHandler.correctOldClassReferences(newClass, aClass);
        } else if (!moveDestination.equals((Object)file.getContainingDirectory()) && moveDestination.findFile(file.getName()) != null) {
            MoveGroovyClassHandler.correctSelfReferences(aClass, newPackage);
            PsiFile newFile = moveDestination.findFile(file.getName());
            FileASTNode fileNode = newFile.getNode();
            fileNode.addChild((ASTNode)Factory.createSingleLeafElement((IElementType)GroovyTokenTypes.mNLS, (CharSequence)"\n\n", (int)0, (int)2, null, (PsiManager)aClass.getManager()));
            PsiDocComment docComment = aClass.getDocComment();
            if (docComment != null) {
                newFile.add((PsiElement)docComment);
                fileNode.addChild((ASTNode)Factory.createSingleLeafElement((IElementType)GroovyTokenTypes.mNLS, (CharSequence)"\n", (int)0, (int)1, null, (PsiManager)aClass.getManager()));
            }
            newClass = (GrTypeDefinition)newFile.add((PsiElement)aClass);
            MoveGroovyClassHandler.correctOldClassReferences(newClass, aClass);
            aClass.delete();
        } else if (((GroovyFile)file).getClasses().length > 1) {
            MoveGroovyClassHandler.correctSelfReferences(aClass, newPackage);
            Project project = aClass.getProject();
            PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)project);
            GroovyFile newFile = (GroovyFile)moveDestination.add((PsiElement)fileFactory.createFileFromText(aClass.getName() + ".groovy", (Language)GroovyLanguage.INSTANCE, (CharSequence)"class XXX {}"));
            PsiClass created = newFile.getClasses()[0];
            PsiDocComment docComment = aClass.getDocComment();
            if (docComment != null) {
                newFile.addBefore((PsiElement)docComment, (PsiElement)created);
                docComment.delete();
            }
            newClass = (PsiClass)created.replace((PsiElement)aClass);
            MoveGroovyClassHandler.setPackageDefinition((GroovyFile)file, newFile, newPackageName);
            MoveGroovyClassHandler.correctOldClassReferences(newClass, aClass);
            aClass.delete();
        }
        return newClass;
    }

    private static void setPackageDefinition(@NotNull GroovyFile file, GroovyFile newFile, String newPackageName) {
        PsiModifierList modifierList;
        if (file == null) {
            MoveGroovyClassHandler.$$$reportNull$$$0(2);
        }
        String modifiersText = null;
        GrPackageDefinition packageDefinition = file.getPackageDefinition();
        if (packageDefinition != null && (modifierList = packageDefinition.getModifierList()) != null) {
            modifiersText = modifierList.getText().trim();
        }
        if (modifiersText != null && !modifiersText.isEmpty()) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(file.getProject());
            GrPackageDefinition newPackageDefinition = (GrPackageDefinition)factory.createTopElementFromText(modifiersText + " package " + newPackageName);
            newFile.setPackage(newPackageDefinition);
        } else {
            newFile.setPackageName(newPackageName);
        }
    }

    @NotNull
    private static GroovyFile generateNewScript(@NotNull GroovyFile file, PsiPackage newPackage) {
        PsiClass[] newFileClasses;
        if (file == null) {
            MoveGroovyClassHandler.$$$reportNull$$$0(3);
        }
        for (GrImportStatement importStatement : file.getImportStatements()) {
            importStatement.delete();
        }
        GroovyFile newFile = GroovyPsiElementFactory.getInstance(file.getProject()).createGroovyFile("", true, null);
        newFile.addRange(file.getFirstChild(), file.getLastChild());
        for (PsiClass psiClass : newFileClasses = newFile.getClasses()) {
            if (psiClass instanceof GroovyScriptClass) continue;
            GrDocComment docComment = GrDocCommentUtil.findDocComment((GrDocCommentOwner)psiClass);
            if (docComment != null) {
                docComment.delete();
            }
            psiClass.delete();
        }
        GrPackageDefinition packageDefinition = newFile.getPackageDefinition();
        if (packageDefinition != null) {
            packageDefinition.delete();
        }
        PsiElement cur = newFile.getFirstChild();
        while (PsiImplUtil.isWhiteSpaceOrNls(cur)) {
            cur = cur.getNextSibling();
        }
        if (cur != null && cur != newFile.getFirstChild()) {
            cur = cur.getPrevSibling();
            newFile.deleteChildRange(newFile.getFirstChild(), cur);
        }
        cur = newFile.getLastChild();
        while (PsiImplUtil.isWhiteSpaceOrNls(cur)) {
            cur = cur.getPrevSibling();
        }
        if (cur != null && cur != newFile.getLastChild()) {
            cur = cur.getNextSibling();
            newFile.deleteChildRange(cur, newFile.getLastChild());
        }
        newFile.setName(file.getName());
        MoveGroovyClassHandler.setPackageDefinition(file, newFile, newPackage.getQualifiedName());
        GroovyChangeContextUtil.decodeContextInfo(newFile, null, null);
        GroovyFile groovyFile = newFile;
        if (groovyFile == null) {
            MoveGroovyClassHandler.$$$reportNull$$$0(4);
        }
        return groovyFile;
    }

    @Nullable
    public String getName(@NotNull PsiClass clazz) {
        PsiFile file;
        if (clazz == null) {
            MoveGroovyClassHandler.$$$reportNull$$$0(5);
        }
        if (!((file = clazz.getContainingFile()) instanceof GroovyFile)) {
            return null;
        }
        return ((GroovyFile)file).getClasses().length > 1 ? clazz.getName() + ".groovy" : file.getName();
    }

    public void preprocessUsages(@NotNull Collection<UsageInfo> results) {
        if (results == null) {
            MoveGroovyClassHandler.$$$reportNull$$$0(6);
        }
        MoveGroovyClassHandler.removeAllAliasImportedUsages(results);
    }

    static void removeAllAliasImportedUsages(@NotNull Collection<UsageInfo> results) {
        if (results == null) {
            MoveGroovyClassHandler.$$$reportNull$$$0(7);
        }
        Iterator<UsageInfo> iterator2 = results.iterator();
        while (iterator2.hasNext()) {
            GroovyResolveResult resolveResult;
            PsiElement context;
            PsiElement element;
            PsiReference ref2;
            UsageInfo info = iterator2.next();
            if (info == null || (ref2 = info.getReference()) == null || !((element = ref2.getElement()) instanceof GrReferenceElement) || !((context = (resolveResult = ((GrReferenceElement)element).advancedResolve()).getCurrentFileResolveContext()) instanceof GrImportStatement) || !((GrImportStatement)context).isAliasedImport()) continue;
            iterator2.remove();
        }
    }

    public void prepareMove(@NotNull PsiClass aClass) {
        if (aClass == null) {
            MoveGroovyClassHandler.$$$reportNull$$$0(8);
        }
        if (aClass.getContainingFile() instanceof GroovyFileBase) {
            GroovyChangeContextUtil.encodeContextInfo(MoveGroovyClassHandler.getRealElement(aClass));
        }
    }

    public void finishMoveClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            MoveGroovyClassHandler.$$$reportNull$$$0(9);
        }
        if (aClass.getContainingFile() instanceof GroovyFileBase) {
            GroovyChangeContextUtil.decodeContextInfo(MoveGroovyClassHandler.getRealElement(aClass), null, null);
        }
    }

    private static PsiElement getRealElement(PsiClass aClass) {
        return aClass instanceof GroovyScriptClass ? aClass.getContainingFile() : aClass;
    }

    private static void correctOldClassReferences(@NotNull PsiClass newClass, PsiClass oldClass) {
        if (newClass == null) {
            MoveGroovyClassHandler.$$$reportNull$$$0(10);
        }
        Collection all = ReferencesSearch.search((PsiElement)oldClass, (SearchScope)new LocalSearchScope((PsiElement)newClass.getContainingFile())).findAll();
        for (PsiReference reference : all) {
            PsiElement element = reference.getElement();
            PsiElement parent = element.getParent();
            if (parent instanceof GrImportStatement && !((GrImportStatement)parent).isStatic()) {
                parent.delete();
            }
            reference.bindToElement((PsiElement)newClass);
        }
    }

    private static void correctSelfReferences(@NotNull PsiClass aClass, PsiPackage newContainingPackage) {
        PsiPackage aPackage;
        if (aClass == null) {
            MoveGroovyClassHandler.$$$reportNull$$$0(11);
        }
        if ((aPackage = JavaDirectoryService.getInstance().getPackage(aClass.getContainingFile().getContainingDirectory())) == null) {
            return;
        }
        for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)new LocalSearchScope((PsiElement)aClass)).findAll()) {
            GrCodeReferenceElement qualifier;
            if (!(reference instanceof GrCodeReferenceElement) || (qualifier = (GrCodeReferenceElement)((GrCodeReferenceElement)reference).getQualifier()) == null) continue;
            qualifier.bindToElement((PsiElement)newContainingPackage);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveDestination";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/move/MoveGroovyClassHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/move/MoveGroovyClassHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNewScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doMoveClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPackageDefinition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateNewScript";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeAllAliasImportedUsages";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareMove";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "finishMoveClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "correctOldClassReferences";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "correctSelfReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

