/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.Comparator;
import java.util.List;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyFacetUtil;
import org.jetbrains.plugins.groovy.util.GroovySelectModuleStep;
import org.jetbrains.plugins.groovy.util.RightTextCellRenderer;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001aC\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r\u001aI\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\u000b0\u00102\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0010\u001a8\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b\u001a\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"GROOVY_LAST_MODULE", "", "selectModule", "", "project", "Lcom/intellij/openapi/project/Project;", "modules", "", "Lcom/intellij/openapi/module/Module;", "version", "Lcom/intellij/util/Function;", "Lorg/jetbrains/annotations/Nls;", "consumer", "Lcom/intellij/util/Consumer;", "createSelectModulePopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "Lkotlin/Function1;", "createSelectModulePopupStep", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "hasJavaSdk", "", "module", "hasAcceptableModuleType", "intellij.groovy"})
@JvmName(name="ModuleChooserUtil")
@SourceDebugExtension(value={"SMAP\nmoduleChooserUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 moduleChooserUtil.kt\norg/jetbrains/plugins/groovy/util/ModuleChooserUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n363#2,7:63\n*S KotlinDebug\n*F\n+ 1 moduleChooserUtil.kt\norg/jetbrains/plugins/groovy/util/ModuleChooserUtil\n*L\n53#1:63,7\n*E\n"})
public final class ModuleChooserUtil {
    @NotNull
    private static final String GROOVY_LAST_MODULE = "Groovy.Last.Module.Chosen";

    public static final void selectModule(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function<Module, String> version, @NotNull Consumer<Module> consumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter(version, (String)"version");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Module module = (Module)CollectionsKt.singleOrNull(modules);
        if (module != null) {
            Module it = module;
            boolean bl = false;
            consumer.consume((Object)it);
            return;
        }
        ModuleChooserUtil.createSelectModulePopup(project, modules, (Function1<? super Module, String>)((Function1)new Function1<Module, String>(version){

            public final String invoke(Module p0) {
                return (String)((Function)this.receiver).fun((Object)p0);
            }
        }), (Function1<? super Module, Unit>)((Function1)new Function1<Module, Unit>(consumer){

            public final void invoke(Module p0) {
                ((Consumer)this.receiver).consume((Object)p0);
            }
        })).showCenteredInCurrentWindow(project);
    }

    @NotNull
    public static final ListPopup createSelectModulePopup(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function1<? super Module, String> version, @NotNull Function1<? super Module, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter(version, (String)"version");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Iterable iterable = modules;
        ModulesAlphaComparator modulesAlphaComparator = ModulesAlphaComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)modulesAlphaComparator, (String)"INSTANCE");
        ListPopupStep<Module> step = ModuleChooserUtil.createSelectModulePopupStep(project, CollectionsKt.sortedWith((Iterable)iterable, (Comparator)((Comparator)modulesAlphaComparator)), consumer);
        return (ListPopup)new ListPopupImpl(project, step, version){
            final /* synthetic */ Function1<Module, String> $version;
            {
                this.$version = $version;
                super($project, $step);
            }

            protected RightTextCellRenderer getListElementRenderer() {
                ListCellRenderer listCellRenderer = super.getListElementRenderer();
                Intrinsics.checkNotNullExpressionValue((Object)listCellRenderer, (String)"getListElementRenderer(...)");
                return new RightTextCellRenderer<Module>(listCellRenderer, this.$version);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final ListPopupStep<Module> createSelectModulePopupStep(Project project, List<? extends Module> modules, Function1<? super Module, Unit> consumer) {
        GroovySelectModuleStep step;
        block3: {
            int n;
            GroovySelectModuleStep groovySelectModuleStep;
            block2: {
                void $this$indexOfFirst$iv;
                PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
                step = new GroovySelectModuleStep(modules, (Function1<? super Module, Unit>)((Function1)arg_0 -> ModuleChooserUtil.createSelectModulePopupStep$lambda$0(propertiesComponent, consumer, arg_0)));
                String string = propertiesComponent.getValue(GROOVY_LAST_MODULE);
                if (string == null) break block3;
                String lastModuleName = string;
                boolean bl = false;
                List<? extends Module> list = modules;
                groovySelectModuleStep = step;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    Module it = (Module)item$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)lastModuleName)) {
                        n = index$iv;
                        break block2;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int n2 = n;
            groovySelectModuleStep.setDefaultOptionIndex(n2);
        }
        return (ListPopupStep)step;
    }

    public static final boolean hasJavaSdk(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        return (sdk != null ? sdk.getSdkType() : null) instanceof JavaSdkType;
    }

    public static final boolean hasAcceptableModuleType(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return GroovyFacetUtil.isAcceptableModuleType(ModuleType.get((Module)module));
    }

    private static final Unit createSelectModulePopupStep$lambda$0(PropertiesComponent $propertiesComponent, Function1 $consumer, Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $propertiesComponent.setValue(GROOVY_LAST_MODULE, it.getName());
        $consumer.invoke((Object)it);
        return Unit.INSTANCE;
    }
}

