/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a\u0010\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006*\u00020\u0002\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\u0004*\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u001a\f\u0010\f\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0010\u001a\u00020\u0001*\u0004\u0018\u00010\u0002\u001a\r\u0010\u0011\u001a\u00020\u0001*\u00020\u0002H\u0082\u0010\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001a\f\u0010\u0014\u001a\u00020\u0001*\u0004\u0018\u00010\u0002\u001a\r\u0010\u0015\u001a\u00020\u0001*\u00020\u0002H\u0082\u0010\u001a\u0018\u0010\u0014\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\n\u0010\u0016\u001a\u00020\u0017\"\u00020\u0018\u001a\f\u0010\u0014\u001a\u00020\u0001*\u00020\u0018H\u0002\u001a\r\u0010\u0019\u001a\u00020\u0001*\u00020\u0002H\u0086\u0010\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u0002\u001a1\u0010\u001e\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010 \u001a\u00020\t2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\"\"\u00020\u0004\u00a2\u0006\u0002\u0010#\u001a\n\u0010$\u001a\u00020\u0004*\u00020\u0004\u001a\u001d\u0010%\u001a\u00020\t*\u00020\t2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tH\u0086\b\u001a(\u0010%\u001a\u0002H(\"\u0004\b\u0000\u0010(*\u0002H(2\u0006\u0010&\u001a\u0002H(2\u0006\u0010'\u001a\u0002H(H\u0086\b\u00a2\u0006\u0002\u0010)\u001aH\u0010*\u001a\u00020\t\"\u0004\b\u0000\u0010+*\b\u0012\u0004\u0012\u0002H+0\u001f2\b\b\u0002\u0010,\u001a\u00020\t2\b\b\u0002\u0010-\u001a\u00020\t2\b\b\u0002\u0010.\u001a\u00020\t2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u0002H+\u0012\u0004\u0012\u00020\u000100\u001a\n\u00101\u001a\u00020\t*\u00020\u0001\u001a\u0015\u00102\u001a\u00020\u0001*\u00020\u00022\u0006\u00103\u001a\u000204H\u0086\u0004\u001a\u0015\u00105\u001a\u00020\u0001*\u00020\u00022\u0006\u00103\u001a\u000204H\u0086\u0004\u001a\u0015\u00106\u001a\u00020\t*\u00020\t2\u0006\u00103\u001a\u000207H\u0086\u0004\u001a \u00108\u001a\u0004\u0018\u0001H(\"\n\b\u0000\u0010(\u0018\u0001*\u000209*\u000209H\u0086\b\u00a2\u0006\u0002\u0010:\u001a#\u0010;\u001a\u00020\u0001\"\b\b\u0000\u0010<*\u00020=*\u0004\u0018\u0001H<2\u0006\u0010>\u001a\u0002H<\u00a2\u0006\u0002\u0010?\u00a8\u0006@"}, d2={"hasChildNode", "", "Lcom/intellij/lang/ASTNode;", "type", "Lcom/intellij/psi/tree/IElementType;", "children", "Lcom/intellij/util/containers/JBIterable;", "getMeaningfulChild", "index", "", "getMeaningfulChildType", "getPrevMeaningfulNode", "getNextMeaningfulNode", "firstLeaf", "lastLeaf", "isLeaf", "isKeyWord", "isThisNodeKeyword", "text", "", "isSymbol", "isThisNodeSymbol", "symbols", "", "", "isComplex", "isComment", "isWhitespace", "isWhitespaceOrComment", "isFollowingAfterLineBreak", "matchPhrase", "", "offset", "pattern", "", "(Ljava/util/List;I[Lcom/intellij/psi/tree/IElementType;)I", "unwrapKeywordId", "change", "what", "with", "T", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "indexOf", "E", "since", "till", "notFound", "predicate", "Lkotlin/Function1;", "toInt", "intersects", "range", "Lcom/intellij/openapi/util/TextRange;", "doesntIntersect", "fitInto", "Lkotlin/ranges/IntRange;", "child", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "isNullOr", "V", "", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "intellij.database.sql.core.impl"})
@JvmName(name="SqlUtilFun")
public final class SqlUtilFun {
    public static final boolean hasChildNode(@NotNull ASTNode $this$hasChildNode, @NotNull IElementType type) {
        Intrinsics.checkNotNullParameter((Object)$this$hasChildNode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return SqlImplUtil.sqlChildren($this$hasChildNode.getPsi()).find(arg_0 -> SqlUtilFun.hasChildNode$lambda$1(arg_0 -> SqlUtilFun.hasChildNode$lambda$0(type, arg_0), arg_0)) != null;
    }

    @NotNull
    public static final JBIterable<ASTNode> children(@NotNull ASTNode $this$children) {
        Intrinsics.checkNotNullParameter((Object)$this$children, (String)"<this>");
        JBIterable jBIterable = ((SyntaxTraverser)SyntaxTraverser.astTraverser((ASTNode)$this$children).expandAndSkip(arg_0 -> SqlUtilFun.children$lambda$1(arg_0 -> SqlUtilFun.children$lambda$0($this$children, arg_0), arg_0))).traverse();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
        return jBIterable;
    }

    @Nullable
    public static final ASTNode getMeaningfulChild(@NotNull ASTNode $this$getMeaningfulChild, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getMeaningfulChild, (String)"<this>");
        if (index < 0) {
            return null;
        }
        return (ASTNode)((SyntaxTraverser)SyntaxTraverser.astTraverser((ASTNode)$this$getMeaningfulChild).expandAndSkip(arg_0 -> SqlUtilFun.getMeaningfulChild$lambda$1(arg_0 -> SqlUtilFun.getMeaningfulChild$lambda$0($this$getMeaningfulChild, arg_0), arg_0))).traverse().filter(arg_0 -> SqlUtilFun.getMeaningfulChild$lambda$3(SqlUtilFun::getMeaningfulChild$lambda$2, arg_0)).get(index);
    }

    @Nullable
    public static final IElementType getMeaningfulChildType(@NotNull ASTNode $this$getMeaningfulChildType, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getMeaningfulChildType, (String)"<this>");
        ASTNode aSTNode = SqlUtilFun.getMeaningfulChild($this$getMeaningfulChildType, index);
        return aSTNode != null ? aSTNode.getElementType() : null;
    }

    @Nullable
    public static final ASTNode getPrevMeaningfulNode(@NotNull ASTNode $this$getPrevMeaningfulNode) {
        Intrinsics.checkNotNullParameter((Object)$this$getPrevMeaningfulNode, (String)"<this>");
        for (ASTNode n = $this$getPrevMeaningfulNode.getTreePrev(); n != null; n = n.getTreePrev()) {
            if (SqlUtilFun.isWhitespaceOrComment(n)) continue;
            return n;
        }
        return null;
    }

    @Nullable
    public static final ASTNode getNextMeaningfulNode(@NotNull ASTNode $this$getNextMeaningfulNode) {
        Intrinsics.checkNotNullParameter((Object)$this$getNextMeaningfulNode, (String)"<this>");
        for (ASTNode n = $this$getNextMeaningfulNode.getTreeNext(); n != null; n = n.getTreeNext()) {
            if (SqlUtilFun.isWhitespaceOrComment(n)) continue;
            return n;
        }
        return null;
    }

    @NotNull
    public static final ASTNode firstLeaf(@NotNull ASTNode $this$firstLeaf) {
        Intrinsics.checkNotNullParameter((Object)$this$firstLeaf, (String)"<this>");
        ASTNode n = $this$firstLeaf;
        ASTNode c;
        while ((c = n.getFirstChildNode()) != null) {
            n = c;
        }
        return n;
    }

    @NotNull
    public static final ASTNode lastLeaf(@NotNull ASTNode $this$lastLeaf) {
        Intrinsics.checkNotNullParameter((Object)$this$lastLeaf, (String)"<this>");
        ASTNode n = $this$lastLeaf;
        ASTNode c;
        while ((c = n.getLastChildNode()) != null) {
            n = c;
        }
        return n;
    }

    public static final boolean isLeaf(@NotNull ASTNode $this$isLeaf) {
        Intrinsics.checkNotNullParameter((Object)$this$isLeaf, (String)"<this>");
        return !($this$isLeaf instanceof LazyParseableElement) && $this$isLeaf.getFirstChildNode() == null;
    }

    public static final boolean isKeyWord(@Nullable ASTNode $this$isKeyWord) {
        if ($this$isKeyWord == null) {
            return false;
        }
        return SqlUtilFun.isThisNodeKeyword($this$isKeyWord);
    }

    private static final boolean isThisNodeKeyword(ASTNode $this$isThisNodeKeyword) {
        while (!($this$isThisNodeKeyword instanceof LazyParseableElement)) {
            ASTNode theChild;
            IElementType iElementType = $this$isThisNodeKeyword.getElementType();
            if (iElementType instanceof SqlKeywordTokenType) {
                return true;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_IDENTIFIER) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) || Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_BLOCK_COMMENT) || Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.SQL_LINE_COMMENT) || Intrinsics.areEqual((Object)iElementType, (Object)SqlTokens.MYSQL_LINE_COMMENT)) {
                return false;
            }
            if ($this$isThisNodeKeyword.getFirstChildNode() == null) {
                return false;
            }
            if ($this$isThisNodeKeyword.getLastChildNode() != theChild) {
                return false;
            }
            $this$isThisNodeKeyword = theChild;
        }
        return false;
    }

    public static final boolean isKeyWord(@Nullable ASTNode $this$isKeyWord, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return $this$isKeyWord != null && SqlUtilFun.isKeyWord($this$isKeyWord) && StringsKt.equals((String)$this$isKeyWord.getText(), (String)text, (boolean)true);
    }

    public static final boolean isSymbol(@Nullable ASTNode $this$isSymbol) {
        if ($this$isSymbol == null) {
            return false;
        }
        if (SqlFormattingFunKt.getMEANINGLESS_TYPES().contains($this$isSymbol.getElementType())) {
            return false;
        }
        int n = $this$isSymbol.getTextLength();
        if (n == 1) {
            char c = $this$isSymbol.getText().charAt(0);
            return SqlUtilFun.isSymbol(c);
        }
        if (n > 8) {
            return false;
        }
        return SqlUtilFun.isThisNodeSymbol($this$isSymbol);
    }

    private static final boolean isThisNodeSymbol(ASTNode $this$isThisNodeSymbol) {
        while (!($this$isThisNodeSymbol instanceof LazyParseableElement)) {
            ASTNode theChild = $this$isThisNodeSymbol.getFirstChildNode();
            if (theChild == null) {
                String string = $this$isThisNodeSymbol.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String text = string;
                int n = text.length();
                for (int i = 0; i < n; ++i) {
                    char c = text.charAt(i);
                    if (SqlUtilFun.isSymbol(c)) continue;
                    return false;
                }
                return true;
            }
            if ($this$isThisNodeSymbol.getLastChildNode() != theChild) {
                return false;
            }
            $this$isThisNodeSymbol = theChild;
        }
        return false;
    }

    public static final boolean isSymbol(@Nullable ASTNode $this$isSymbol, char ... symbols) {
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        if ($this$isSymbol == null) {
            return false;
        }
        if (SqlFormattingFunKt.getMEANINGLESS_TYPES().contains($this$isSymbol.getElementType())) {
            return false;
        }
        if ($this$isSymbol instanceof LazyParseableElement) {
            return false;
        }
        int n = $this$isSymbol.getTextLength();
        if (n == 1) {
            char c = $this$isSymbol.getText().charAt(0);
            for (char symbol : symbols) {
                if (c != symbol) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean isSymbol(char $this$isSymbol) {
        if (Character.isLetterOrDigit($this$isSymbol)) {
            return false;
        }
        return $this$isSymbol != '_';
    }

    public static final boolean isComplex(@NotNull ASTNode $this$isComplex) {
        Intrinsics.checkNotNullParameter((Object)$this$isComplex, (String)"<this>");
        while (!($this$isComplex instanceof LazyParseableElement)) {
            ASTNode theChild;
            if ($this$isComplex.getFirstChildNode() == null) {
                return false;
            }
            if ($this$isComplex.getLastChildNode() != theChild) {
                return true;
            }
            $this$isComplex = theChild;
        }
        return true;
    }

    public static final boolean isComment(@NotNull ASTNode $this$isComment) {
        Intrinsics.checkNotNullParameter((Object)$this$isComment, (String)"<this>");
        return SqlElementTypes.COMMENT_TOKENS.contains($this$isComment.getElementType());
    }

    public static final boolean isWhitespace(@NotNull ASTNode $this$isWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$isWhitespace, (String)"<this>");
        return $this$isWhitespace.getTextLength() <= 0 || $this$isWhitespace.getElementType() == SqlElementTypes.ORAP_DELIMITER_TOKEN || $this$isWhitespace.getElementType() == SqlTokens.ORAP_BIG_DELIMITER_TOKEN || $this$isWhitespace.getPsi() instanceof PsiWhiteSpace;
    }

    public static final boolean isWhitespaceOrComment(@NotNull ASTNode $this$isWhitespaceOrComment) {
        Intrinsics.checkNotNullParameter((Object)$this$isWhitespaceOrComment, (String)"<this>");
        return SqlUtilFun.isWhitespace($this$isWhitespaceOrComment) || SqlUtilFun.isComment($this$isWhitespaceOrComment);
    }

    public static final boolean isFollowingAfterLineBreak(@NotNull ASTNode $this$isFollowingAfterLineBreak) {
        Intrinsics.checkNotNullParameter((Object)$this$isFollowingAfterLineBreak, (String)"<this>");
        PsiElement p2 = PsiTreeUtil.prevLeaf((PsiElement)$this$isFollowingAfterLineBreak.getPsi());
        if (p2 == null) {
            return false;
        }
        if (SqlTokens.WS_TOKENS.contains(PsiTreeUtilKt.getElementType((PsiElement)p2))) {
            return p2.textContains('\n');
        }
        return false;
    }

    public static final int matchPhrase(@NotNull List<? extends ASTNode> $this$matchPhrase, int offset, IElementType ... pattern) {
        Intrinsics.checkNotNullParameter($this$matchPhrase, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        int m = pattern.length;
        int n = $this$matchPhrase.size();
        if (offset + m > n) {
            return -1;
        }
        int k = offset;
        block0: for (IElementType pt : pattern) {
            while (k < n) {
                IElementType t;
                Intrinsics.checkNotNullExpressionValue((Object)$this$matchPhrase.get(k++).getElementType(), (String)"getElementType(...)");
                if (t == pt) continue block0;
                if (SqlElementTypes.WS_OR_COMMENTS.contains(t)) continue;
                return -1;
            }
        }
        return k - offset;
    }

    @NotNull
    public static final IElementType unwrapKeywordId(@NotNull IElementType $this$unwrapKeywordId) {
        IElementType iElementType;
        Intrinsics.checkNotNullParameter((Object)$this$unwrapKeywordId, (String)"<this>");
        if ($this$unwrapKeywordId instanceof SqlIdentifierKeywordTokenType) {
            SqlKeywordTokenType sqlKeywordTokenType = ((SqlIdentifierKeywordTokenType)$this$unwrapKeywordId).getKeyword();
            iElementType = (IElementType)(sqlKeywordTokenType != null ? (SqlTokenType)sqlKeywordTokenType : (SqlTokenType)$this$unwrapKeywordId);
        } else {
            iElementType = $this$unwrapKeywordId;
        }
        return iElementType;
    }

    public static final int change(int $this$change, int what, int with) {
        boolean $i$f$change = false;
        return $this$change == what ? with : $this$change;
    }

    public static final <T> T change(T $this$change, T what, T with) {
        boolean $i$f$change = false;
        return Intrinsics.areEqual($this$change, what) ? with : $this$change;
    }

    public static final <E> int indexOf(@NotNull List<? extends E> $this$indexOf, int since, int till, int notFound, @NotNull Function1<? super E, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$indexOf, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (since < 0) {
            throw new IllegalArgumentException("Called List.indexOf() with negative since: " + since);
        }
        if ($this$indexOf.isEmpty()) {
            return notFound;
        }
        int n = $this$indexOf.size();
        if (till <= since || since >= n) {
            return notFound;
        }
        int n2 = Math.min(till, n);
        for (int i = since; i < n2; ++i) {
            if (!((Boolean)predicate.invoke($this$indexOf.get(i))).booleanValue()) continue;
            return i;
        }
        return notFound;
    }

    public static /* synthetic */ int indexOf$default(List list, int n, int n2, int n3, Function1 function1, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = list.size();
        }
        if ((n4 & 4) != 0) {
            n3 = -1;
        }
        return SqlUtilFun.indexOf(list, n, n2, n3, function1);
    }

    public static final int toInt(boolean $this$toInt) {
        return $this$toInt ? 1 : 0;
    }

    public static final boolean intersects(@NotNull ASTNode $this$intersects, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)$this$intersects, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return $this$intersects.getTextRange().intersects(range);
    }

    public static final boolean doesntIntersect(@NotNull ASTNode $this$doesntIntersect, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)$this$doesntIntersect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return !SqlUtilFun.intersects($this$doesntIntersect, range);
    }

    public static final int fitInto(int $this$fitInto, @NotNull IntRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return $this$fitInto < range.getFirst() ? range.getFirst() : ($this$fitInto > range.getEndInclusive() ? range.getEndInclusive() : $this$fitInto);
    }

    public static final /* synthetic */ <T extends PsiElement> T child(PsiElement $this$child) {
        Intrinsics.checkNotNullParameter((Object)$this$child, (String)"<this>");
        boolean $i$f$child = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)PsiTreeUtil.findChildOfType((PsiElement)$this$child, PsiElement.class);
    }

    public static final <V> boolean isNullOr(@Nullable V $this$isNullOr, @NotNull V value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return $this$isNullOr == null || Intrinsics.areEqual($this$isNullOr, value);
    }

    private static final boolean hasChildNode$lambda$0(IElementType $type, PsiElement it) {
        return PsiTreeUtilKt.getElementType((PsiElement)it) == $type;
    }

    private static final boolean hasChildNode$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean children$lambda$0(ASTNode $this_children, ASTNode it) {
        return it == $this_children || it.getElementType() == SqlElementTypes.SQL_DUMMY_BLOCK;
    }

    private static final boolean children$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getMeaningfulChild$lambda$0(ASTNode $this_getMeaningfulChild, ASTNode it) {
        return it == $this_getMeaningfulChild || it.getElementType() == SqlElementTypes.SQL_DUMMY_BLOCK;
    }

    private static final boolean getMeaningfulChild$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getMeaningfulChild$lambda$2(ASTNode it) {
        Intrinsics.checkNotNull((Object)it);
        return !SqlUtilFun.isWhitespaceOrComment(it);
    }

    private static final boolean getMeaningfulChild$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

