/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.FlowPatternKt;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001BC\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ(\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/intellij/sql/formatter/model/RowPattern;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "applicableState", "", "resultState", "matchers", "", "Lcom/intellij/sql/formatter/model/NodeMatcher;", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "producer", "Lkotlin/Function0;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlBlockProducer;", "<init>", "(Ljava/lang/Byte;Ljava/lang/Byte;Ljava/util/List;Lcom/intellij/sql/formatter/model/BlockRole;Lkotlin/jvm/functions/Function0;)V", "getRole", "()Lcom/intellij/sql/formatter/model/BlockRole;", "process", "Lkotlin/ranges/IntRange;", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "nodes", "Lcom/intellij/lang/ASTNode;", "since", "", "getDescription", "", "intellij.database.sql.core.impl"})
public final class RowPattern
extends FlowPattern {
    @NotNull
    private final List<NodeMatcher> matchers;
    @NotNull
    private final BlockRole role;

    public RowPattern(@Nullable Byte applicableState, @Nullable Byte resultState, @NotNull List<? extends NodeMatcher> matchers, @NotNull BlockRole role, @NotNull Function0<? extends SqlBlock> producer) {
        Intrinsics.checkNotNullParameter(matchers, (String)"matchers");
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        super(applicableState, resultState, producer, null);
        this.matchers = matchers;
        this.role = role;
    }

    @Override
    @NotNull
    public BlockRole getRole() {
        return this.role;
    }

    @Override
    @Nullable
    public IntRange process(@NotNull SqlFormattingContext context, @NotNull List<? extends ASTNode> nodes, int since) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        int rowLength = FlowPatternKt.access$parseRow(nodes, since, this.matchers);
        return rowLength > 0 ? RangesKt.until((int)since, (int)(since + rowLength)) : null;
    }

    @Override
    @NotNull
    protected String getDescription() {
        return "ROW: " + CollectionsKt.joinToString$default((Iterable)this.matchers, null, null, null, (int)0, null, RowPattern::getDescription$lambda$0, (int)31, null);
    }

    private static final CharSequence getDescription$lambda$0(NodeMatcher it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }
}

