/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Spacing;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.RowPattern;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCreateTypeBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlTableParenthesizedColumnsSection;
import com.intellij.sql.formatter.model.StartStopPattern;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokenType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0003\u000e\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J\b\u0010\u000b\u001a\u00020\u0005H\u0014J\b\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTypeBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "<init>", "()V", "whetherToFlatten", "", "node", "Lcom/intellij/lang/ASTNode;", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userRequiresExpand", "configureFormattingAttributes", "", "Companion", "SqlTypeParenthesizedContentSection", "SqlTypeMemberRoutineBlock", "intellij.database.sql.core.impl"})
public final class SqlCreateTypeBlock
extends SqlNodeBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<FlowPattern> patterns;

    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return Intrinsics.areEqual((Object)node.getElementType(), (Object)SqlCompositeElementTypes.SQL_TABLE_TYPE_ELEMENT) || node.getElementType() == SqlCompositeElementTypes.SQL_TABLE_ELEMENT_LIST || super.whetherToFlatten(node);
    }

    @Override
    @NotNull
    protected List<FlowPattern> flowPatterns() {
        return patterns;
    }

    @Override
    protected boolean userRequiresExpand() {
        return true;
    }

    @Override
    protected void configureFormattingAttributes() {
        for (SqlBlock b : this.getNestedBlocks()) {
            SqlBlock sqlBlock = b;
            if (sqlBlock instanceof SqlKeyword) {
                IElementType iElementType = ((SqlKeyword)b).getElementType();
                if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_AS) && !Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_IS)) continue;
                b.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (!(sqlBlock instanceof SqlTableParenthesizedColumnsSection)) continue;
            b.setMyWrap(this.getContext().getSql().TABLE_OPENING > 1 ? SqlFlowBlock.makeWrap$default(this, WrapType.ALWAYS, false, 2, null) : null);
            b.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
        }
    }

    static {
        SqlTokenType sqlTokenType = SqlCommonTokens.SQL_LEFT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LEFT_PAREN");
        NodeMatcher nodeMatcher = NodeMatcherKt.matchType((IElementType)sqlTokenType);
        SqlTokenType sqlTokenType2 = SqlCommonTokens.SQL_RIGHT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_RIGHT_PAREN");
        patterns = CollectionsKt.listOf((Object)new StartStopPattern(null, null, nodeMatcher, NodeMatcherKt.matchType((IElementType)sqlTokenType2), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE)));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTypeBlock$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<FlowPattern> getPatterns() {
            return patterns;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTypeBlock$SqlTypeMemberRoutineBlock;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "<init>", "()V", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "intellij.database.sql.core.impl"})
    public static final class SqlTypeMemberRoutineBlock
    extends SqlRangeBlock {
        @Override
        @Nullable
        public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            return Intrinsics.areEqual((Object)SqlFormattingModelFun.primaryElementType(block1), (Object)SqlCommonKeywords.SQL_MEMBER) ? SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null) : super.decideSpacing(block1, block2);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTypeBlock$SqlTypeParenthesizedContentSection;", "Lcom/intellij/sql/formatter/model/SqlTableParenthesizedColumnsSection;", "<init>", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "Companion", "intellij.database.sql.core.impl"})
    public static final class SqlTypeParenthesizedContentSection
    extends SqlTableParenthesizedColumnsSection {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<FlowPattern> patterns;

        @Override
        @NotNull
        protected List<FlowPattern> flowPatterns() {
            return patterns;
        }

        static {
            Object[] objectArray = new NodeMatcher[2];
            SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_MEMBER;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_MEMBER");
            objectArray[0] = NodeMatcherKt.matchType((IElementType)sqlTokenType);
            objectArray[1] = NodeMatcherKt.matchTypeName("ORA_MEMBER_FUNCTION_DEFINITION");
            patterns = CollectionsKt.listOf((Object)new RowPattern(null, null, CollectionsKt.listOf((Object[])objectArray), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE)));
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTypeBlock$SqlTypeParenthesizedContentSection$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<FlowPattern> getPatterns() {
                return patterns;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

