/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.NodeWithLineCommentPattern;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCommentBlock;
import com.intellij.sql.formatter.model.SqlDeclareStatementBlock;
import com.intellij.sql.formatter.model.SqlDeclareStatementEntryBlock;
import com.intellij.sql.formatter.model.SqlDeclareStatementGroupBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0014J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/formatter/model/SqlDeclareStatementGroupBlock;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "<init>", "()V", "numberOfEntries", "", "numberOfLineComments", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/NodeWithLineCommentPattern;", "analyseOriginalCodeStyle", "", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "configureFormattingAttributes", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "getDebugNameSuffix", "", "Companion", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlBatchBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlBatchBlock.kt\ncom/intellij/sql/formatter/model/SqlDeclareStatementGroupBlock\n+ 2 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlock\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n112#2,4:202\n112#2,4:207\n1#3:206\n*S KotlinDebug\n*F\n+ 1 SqlBatchBlock.kt\ncom/intellij/sql/formatter/model/SqlDeclareStatementGroupBlock\n*L\n96#1:202,4\n104#1:207,4\n*E\n"})
public final class SqlDeclareStatementGroupBlock
extends SqlRangeBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int numberOfEntries;
    private int numberOfLineComments;
    @NotNull
    private static final List<NodeWithLineCommentPattern> patterns;

    @NotNull
    protected List<NodeWithLineCommentPattern> flowPatterns() {
        return patterns;
    }

    @Override
    protected void analyseOriginalCodeStyle() {
        for (SqlBlock block : this.getNestedBlocks()) {
            if (!(block instanceof SqlDeclareStatementEntryBlock)) continue;
            int n = this.numberOfEntries;
            this.numberOfEntries = n + 1;
            if (((SqlDeclareStatementEntryBlock)block).getCommentBlock$intellij_database_sql_core_impl() == null) continue;
            n = this.numberOfLineComments;
            this.numberOfLineComments = n + 1;
        }
        if (this.numberOfEntries >= 2) {
            this.setShape(BlockShape.DECIDED_TO_MULTI_ROWS);
        }
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureFormattingAttributes() {
        SqlBlock indent$iv;
        Alignment align$iv;
        if (this.getContext().getSql().IMP_DECLARE_ALIGN_TYPE && this.numberOfEntries >= 2) {
            Alignment alignmentForTypes = SqlFormattingModelFun.makeLeftAlignmentBS();
            for (SqlBlock b : this.getNestedBlocks()) {
                void wrap$iv;
                void this_$iv;
                SqlBlock t;
                SqlDeclareStatementBlock d;
                if (!(b instanceof SqlDeclareStatementEntryBlock) || ((SqlDeclareStatementEntryBlock)b).getDeclareBlock$intellij_database_sql_core_impl() == null || d.getTypeBlock$intellij_database_sql_core_impl() == null) continue;
                SqlBlock sqlBlock = t;
                Object var7_7 = null;
                Object var8_9 = null;
                align$iv = alignmentForTypes;
                boolean $i$f$setAttributes = false;
                this_$iv.setMyWrap((Wrap)wrap$iv);
                this_$iv.setMyIndent((Indent)indent$iv);
                this_$iv.setMyAlign(align$iv);
            }
        }
        if (this.getContext().getSql().IMP_DECLARE_ALIGN_LINE_COMMENTS && this.numberOfLineComments >= 2) {
            Alignment alignmentForComments = SqlFormattingModelFun.makeLeftAlignmentBS();
            for (SqlBlock b : this.getNestedBlocks()) {
                if (!(b instanceof SqlDeclareStatementEntryBlock)) continue;
                if (((SqlDeclareStatementEntryBlock)b).getCommentBlock$intellij_database_sql_core_impl() != null) {
                    void indent$iv2;
                    void wrap$iv;
                    void this_$iv;
                    SqlCommentBlock sqlCommentBlock;
                    SqlCommentBlock it = sqlCommentBlock;
                    boolean bl = false;
                    indent$iv = it;
                    align$iv = null;
                    Object $i$f$setAttributes = null;
                    Alignment align$iv2 = alignmentForComments;
                    boolean $i$f$setAttributes2 = false;
                    this_$iv.setMyWrap((Wrap)wrap$iv);
                    this_$iv.setMyIndent((Indent)indent$iv2);
                    this_$iv.setMyAlign(align$iv2);
                }
            }
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        return block1 instanceof SqlDeclareStatementEntryBlock ? this.getContext().makeSafeSpaceOrBreak() : (block2 instanceof SqlDeclareStatementEntryBlock ? SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null) : super.decideSpacing(block1, block2));
    }

    @Override
    @NotNull
    protected String getDebugNameSuffix() {
        return this.numberOfEntries + "," + this.numberOfLineComments;
    }

    static {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_DECLARE_STATEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_DECLARE_STATEMENT");
        patterns = CollectionsKt.listOf((Object)new NodeWithLineCommentPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE)));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlDeclareStatementGroupBlock$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/NodeWithLineCommentPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<NodeWithLineCommentPattern> getPatterns() {
            return patterns;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

