/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.jupyter.py.debugger.JupyterLineBreakpointType;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J/\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterAutoBreakpointHelper;", "", "<init>", "()V", "addBreakpointToCellIfNeeded", "", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isBreakpointInCell", "", "manager", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl;", "cellLines", "Lkotlin/ranges/IntRange;", "addBreakpointToCell", "getFirstValidLineForBreakpoint", "", "jupyterLineBreakpointType", "Lcom/intellij/jupyter/py/debugger/JupyterLineBreakpointType;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/jupyter/py/debugger/JupyterLineBreakpointType;Lkotlin/ranges/IntRange;)Ljava/lang/Integer;", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterAutoBreakpointHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterAutoBreakpointHelper.kt\ncom/intellij/jupyter/py/debugger/JupyterAutoBreakpointHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1807#2,3:75\n296#2,2:78\n*S KotlinDebug\n*F\n+ 1 JupyterAutoBreakpointHelper.kt\ncom/intellij/jupyter/py/debugger/JupyterAutoBreakpointHelper\n*L\n45#1:75,3\n70#1:78,2\n*E\n"})
public final class JupyterAutoBreakpointHelper {
    @NotNull
    public static final JupyterAutoBreakpointHelper INSTANCE = new JupyterAutoBreakpointHelper();

    private JupyterAutoBreakpointHelper() {
    }

    public final void addBreakpointToCellIfNeeded(@NotNull NotebookIntervalPointer cellPointer, @NotNull Project project, @NotNull VirtualFile virtualFile) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            NotebookCellLines.Interval interval = cellPointer.get();
            if (interval == null || (interval = interval.getLines()) == null) break block1;
            NotebookCellLines.Interval cellLines = interval;
            boolean bl = false;
            XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
            Intrinsics.checkNotNull((Object)xBreakpointManager, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl");
            XBreakpointManagerImpl breakpointManager = (XBreakpointManagerImpl)xBreakpointManager;
            if (!INSTANCE.isBreakpointInCell(breakpointManager, (IntRange)cellLines, virtualFile)) {
                INSTANCE.addBreakpointToCell(breakpointManager, project, virtualFile, (IntRange)cellLines);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBreakpointInCell(XBreakpointManagerImpl manager, IntRange cellLines, VirtualFile virtualFile) {
        boolean bl;
        Collection collection = manager.getBreakpoints(JupyterLineBreakpointType.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getBreakpoints(...)");
        Collection breakpoints = collection;
        Iterable $this$any$iv = breakpoints;
        boolean $i$f$any = false;
        if (((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            XLineBreakpoint breakpoint = (XLineBreakpoint)element$iv;
            boolean bl2 = false;
            XLineBreakpoint xLineBreakpoint = breakpoint;
            if (xLineBreakpoint != null && (xLineBreakpoint = xLineBreakpoint.getSourcePosition()) != null) {
                XLineBreakpoint position = xLineBreakpoint;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)position.getFile(), (Object)virtualFile)) {
                    boolean bl4;
                    int n = cellLines.getFirst();
                    int n2 = cellLines.getLast();
                    int n3 = position.getLine();
                    if (n <= n3) {
                        if (n3 <= n2) {
                            return true;
                        }
                        bl4 = false;
                    } else {
                        bl4 = false;
                    }
                    if (bl4) {
                        return true;
                    }
                }
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final void addBreakpointToCell(XBreakpointManagerImpl manager, Project project, VirtualFile virtualFile, IntRange cellLines) {
        JupyterLineBreakpointType breakpointType = (JupyterLineBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(JupyterLineBreakpointType.class);
        Intrinsics.checkNotNull((Object)((Object)breakpointType));
        Integer n = this.getFirstValidLineForBreakpoint(project, virtualFile, breakpointType, cellLines);
        if (n == null) {
            return;
        }
        int firstValidLine = n;
        manager.addLineBreakpoint((XLineBreakpointType)breakpointType, virtualFile.getUrl(), firstValidLine, null);
    }

    private final Integer getFirstValidLineForBreakpoint(Project project, VirtualFile virtualFile, JupyterLineBreakpointType jupyterLineBreakpointType, IntRange cellLines) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = (Iterable)cellLines;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int line = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!jupyterLineBreakpointType.canPutAt(virtualFile, line, project)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

