/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.stat;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.jupyter.core.jupyter.connections.fus.JupyterConnectionsCollector;
import com.intellij.jupyter.core.jupyter.connections.fus.JupyterStartResult;
import com.intellij.jupyter.py.debugger.common.JupyterPyDebugRunnerProvider;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.system.OS;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J(\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0011J-\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*2\u0006\u0010\"\u001a\u00020#2\u0006\u0010+\u001a\u00020%2\u0006\u0010'\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b,J\u000e\u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020/J2\u00100\u001a\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001502012\u0006\u0010+\u001a\u00020%2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010'\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0016\u0010\u0017\u001a\u00020\u00188\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0019\u0010\u0003R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/jupyter/py/stat/JupyterPyFeaturesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "SERVER_START_RESULT", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/jupyter/core/jupyter/connections/fus/JupyterStartResult;", "OS_TYPE", "Lcom/intellij/util/system/OS;", "DURATION", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "IS_SUCCESS", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "SERVER", "Lcom/intellij/jupyter/py/stat/JupyterPyFeaturesCollector$ManagedServerType;", "baseFields", "", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "[Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "debugRunnerProviderField", "Lcom/intellij/internal/statistic/eventLog/events/ClassEventField;", "getDebugRunnerProviderField$annotations", "INSTALL_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "SERVER_START_EVENT", "jupyterDebugRunnerSelectedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "Ljava/lang/Class;", "logServerStart", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "timeInMills", "", "eventType", "serverType", "logPackageInstallResult", "isSuccess", "", "durationMs", "logPackageInstallResult$intellij_jupyter_py", "logSelectedDebugRunner", "selectedProvider", "Lcom/intellij/jupyter/py/debugger/common/JupyterPyDebugRunnerProvider;", "collectData", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "ManagedServerType", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterPyFeaturesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterPyFeaturesCollector.kt\ncom/intellij/jupyter/py/stat/JupyterPyFeaturesCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,88:1\n261#2,3:89\n261#2,3:92\n261#2,3:95\n*S KotlinDebug\n*F\n+ 1 JupyterPyFeaturesCollector.kt\ncom/intellij/jupyter/py/stat/JupyterPyFeaturesCollector\n*L\n20#1:89,3\n21#1:92,3\n24#1:95,3\n*E\n"})
public final class JupyterPyFeaturesCollector
extends CounterUsagesCollector {
    @NotNull
    public static final JupyterPyFeaturesCollector INSTANCE;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final EnumEventField<JupyterStartResult> SERVER_START_RESULT;
    @NotNull
    private static final EnumEventField<OS> OS_TYPE;
    @NotNull
    private static final LongEventField DURATION;
    @NotNull
    private static final BooleanEventField IS_SUCCESS;
    @NotNull
    private static final EnumEventField<ManagedServerType> SERVER;
    @NotNull
    private static final PrimitiveEventField<? extends Object>[] baseFields;
    @NotNull
    private static final ClassEventField debugRunnerProviderField;
    @NotNull
    private static final VarargEventId INSTALL_EVENT;
    @NotNull
    private static final VarargEventId SERVER_START_EVENT;
    @NotNull
    private static final EventId1<Class<?>> jupyterDebugRunnerSelectedEvent;

    private JupyterPyFeaturesCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @JvmStatic
    private static /* synthetic */ void getDebugRunnerProviderField$annotations() {
    }

    public final void logServerStart(@Nullable Sdk sdk, long timeInMills, @NotNull JupyterStartResult eventType, @NotNull ManagedServerType serverType) {
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)((Object)serverType), (String)"serverType");
        List<EventPair<? extends Object>> data = this.collectData(timeInMills, sdk, serverType);
        SERVER_START_EVENT.log(CollectionsKt.plus((Collection)data, (Object)SERVER_START_RESULT.with((Object)eventType)));
    }

    public final void logPackageInstallResult$intellij_jupyter_py(boolean isSuccess, @NotNull Sdk sdk, long durationMs, @NotNull ManagedServerType serverType) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)((Object)serverType), (String)"serverType");
        List<EventPair<? extends Object>> data = this.collectData(durationMs, sdk, serverType);
        INSTALL_EVENT.log(CollectionsKt.plus((Collection)data, (Object)IS_SUCCESS.with((Object)isSuccess)));
    }

    public final void logSelectedDebugRunner(@NotNull JupyterPyDebugRunnerProvider selectedProvider) {
        Intrinsics.checkNotNullParameter((Object)selectedProvider, (String)"selectedProvider");
        jupyterDebugRunnerSelectedEvent.log(selectedProvider.getClass());
    }

    private final List<EventPair<? extends Object>> collectData(long durationMs, Sdk sdk, ManagedServerType serverType) {
        Sdk sdk2;
        Sdk sdk3;
        long durationInTensOfSeconds = durationMs / (long)10000 * (long)10;
        Object[] objectArray = new EventPair[6];
        objectArray[0] = PyStatisticToolsKt.getPYTHON_VERSION().with((Object)PyStatisticToolsKt.getVersion((Sdk)sdk).toPythonVersion());
        objectArray[1] = PyStatisticToolsKt.getEXECUTION_TYPE().with((sdk3 = sdk) != null && (sdk3 = PyStatisticToolsKt.getExecutionType((Sdk)sdk3)) != null ? sdk3.getValue() : null);
        objectArray[2] = PyStatisticToolsKt.getINTERPRETER_TYPE().with((sdk2 = sdk) != null && (sdk2 = PyStatisticToolsKt.getInterpreterType((Sdk)sdk2)) != null ? sdk2.getValue() : null);
        OS oS = OS.CURRENT;
        Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"CURRENT");
        objectArray[3] = OS_TYPE.with((Object)oS);
        objectArray[4] = DURATION.with((Object)durationInTensOfSeconds);
        objectArray[5] = SERVER.with((Object)serverType);
        List data = CollectionsKt.listOf((Object[])objectArray);
        return data;
    }

    static {
        EventFields $this$iv;
        INSTANCE = new JupyterPyFeaturesCollector();
        GROUP = new EventLogGroup("jupyter.py.features", 9, "FUS", "Features used for Jupyter Python", null, 16, null);
        SpreadBuilder spreadBuilder = EventFields.INSTANCE;
        String name$iv = "start_result";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        SERVER_START_RESULT = new EnumEventField(name$iv, JupyterStartResult.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "OS";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        OS_TYPE = new EnumEventField(name$iv, OS.class, null, transform$iv);
        DURATION = EventFields.Long((String)"duration_sec", (String)"Duration in seconds rounded to 10s");
        IS_SUCCESS = EventFields.Boolean((String)"success");
        $this$iv = EventFields.INSTANCE;
        name$iv = "server";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        SERVER = new EnumEventField(name$iv, ManagedServerType.class, null, transform$iv);
        spreadBuilder = new SpreadBuilder[]{OS_TYPE, PyStatisticToolsKt.getPYTHON_VERSION(), PyStatisticToolsKt.getEXECUTION_TYPE(), PyStatisticToolsKt.getINTERPRETER_TYPE(), DURATION, SERVER};
        baseFields = spreadBuilder;
        debugRunnerProviderField = EventFields.Class((String)"debug_runner_provider");
        spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)IS_SUCCESS);
        spreadBuilder.addSpread(baseFields);
        INSTALL_EVENT = GROUP.registerVarargEvent("jupyter.package.install", "Jupyter Package install conditions", (EventField[])spreadBuilder.toArray((Object[])new EventField[spreadBuilder.size()]));
        EventLogGroup eventLogGroup = JupyterConnectionsCollector.INSTANCE.getGroup();
        spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add(SERVER_START_RESULT);
        spreadBuilder.addSpread(baseFields);
        SERVER_START_EVENT = eventLogGroup.registerVarargEvent("jupyterlab.server.start", "Jupyterlab/Ipykernel managed server start", (EventField[])spreadBuilder.toArray((Object[])new EventField[spreadBuilder.size()]));
        jupyterDebugRunnerSelectedEvent = GROUP.registerEvent("jupyter.debug.runner.selected", (EventField)debugRunnerProviderField, "Records the type of debug runner selected for Jupyter notebook debugging (local vs remote)");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/py/stat/JupyterPyFeaturesCollector$ManagedServerType;", "", "<init>", "(Ljava/lang/String;I)V", "JUPYTERLAB", "IPYKERNEL", "intellij.jupyter.py"})
    public static final class ManagedServerType
    extends Enum<ManagedServerType> {
        public static final /* enum */ ManagedServerType JUPYTERLAB = new ManagedServerType();
        public static final /* enum */ ManagedServerType IPYKERNEL = new ManagedServerType();
        private static final /* synthetic */ ManagedServerType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ManagedServerType[] values() {
            return (ManagedServerType[])$VALUES.clone();
        }

        public static ManagedServerType valueOf(String value) {
            return Enum.valueOf(ManagedServerType.class, value);
        }

        @NotNull
        public static EnumEntries<ManagedServerType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = managedServerTypeArray = new ManagedServerType[]{ManagedServerType.JUPYTERLAB, ManagedServerType.IPYKERNEL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

