/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.providers;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.index.SwLexerBasedSpecificationRecognitionKt;
import com.intellij.swagger.core.model.SwSpecificationSchemaStorage;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/swagger/core/providers/SpecificationJsonSchemaFileProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "specificationType", "Lcom/intellij/swagger/core/SwSpecificationType;", "remoteSchemaUrl", "", "visibleName", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/swagger/core/SwSpecificationType;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "isAvailable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "getRemoteSource", "getSchemaFile", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwJsonSchemaFileProviderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwJsonSchemaFileProviderFactory.kt\ncom/intellij/swagger/core/providers/SpecificationJsonSchemaFileProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,80:1\n30#2,2:81\n*S KotlinDebug\n*F\n+ 1 SwJsonSchemaFileProviderFactory.kt\ncom/intellij/swagger/core/providers/SpecificationJsonSchemaFileProvider\n*L\n71#1:81,2\n*E\n"})
public final class SpecificationJsonSchemaFileProvider
implements JsonSchemaFileProvider {
    @NotNull
    private final SwSpecificationType specificationType;
    @NotNull
    private final String remoteSchemaUrl;
    @NotNull
    private final String visibleName;
    @NotNull
    private final Project project;

    public SpecificationJsonSchemaFileProvider(@NotNull SwSpecificationType specificationType, @NotNull String remoteSchemaUrl, @Nls @NotNull String visibleName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)specificationType, (String)"specificationType");
        Intrinsics.checkNotNullParameter((Object)remoteSchemaUrl, (String)"remoteSchemaUrl");
        Intrinsics.checkNotNullParameter((Object)visibleName, (String)"visibleName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.specificationType = specificationType;
        this.remoteSchemaUrl = remoteSchemaUrl;
        this.visibleName = visibleName;
        this.project = project;
    }

    public boolean isAvailable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        SwSpecificationType detectedSpecificationType = (SwSpecificationType)ActionsKt.runReadAction(() -> SpecificationJsonSchemaFileProvider.isAvailable$lambda$0(file, this));
        return Intrinsics.areEqual((Object)detectedSpecificationType, (Object)this.specificationType);
    }

    @NotNull
    public String getName() {
        return this.visibleName;
    }

    @NotNull
    public SchemaType getSchemaType() {
        return SchemaType.embeddedSchema;
    }

    @NotNull
    public String getRemoteSource() {
        return this.remoteSchemaUrl;
    }

    @Nullable
    public VirtualFile getSchemaFile() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<SwSpecificationSchemaStorage> serviceClass$iv = SwSpecificationSchemaStorage.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Pair<VirtualFile, JsonSchemaObject> pair = ((SwSpecificationSchemaStorage)object).getSchemaFor(this.specificationType);
        return pair != null ? (VirtualFile)pair.getFirst() : null;
    }

    private static final SwSpecificationType isAvailable$lambda$0(VirtualFile $file, SpecificationJsonSchemaFileProvider this$0) {
        if (!$file.isValid() || $file.getFileType().isBinary()) {
            return SwSpecificationType.UNKNOWN.INSTANCE;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this$0.project).findFile($file);
        if (psiFile == null) {
            return SwSpecificationType.UNKNOWN.INSTANCE;
        }
        PsiFile psiFile2 = psiFile;
        return SwLexerBasedSpecificationRecognitionKt.getOrRecognizeSpecificationTypeWithLexer(psiFile2);
    }
}

