/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.visualEditing;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.psi.PsiElement;
import com.intellij.swagger.core.providers.SwMergeableLineMarkerRenderer;
import com.intellij.swagger.core.visualEditing.SwEditorMouseEvent;
import com.intellij.swagger.core.visualEditing.SwGutterRepaintRequest;
import com.intellij.swagger.core.visualEditing.SwVisualEditingActionLineMarker;
import com.intellij.swagger.core.visualEditing.SwVisualEditingActionsService;
import com.intellij.swagger.core.visualEditing.utils.SwInterval;
import com.intellij.swagger.core.visualEditing.utils.SwIntervalTreeUtilsKt;
import com.intellij.swagger.core.visualEditing.utils.SwTreeSearchData;
import com.intellij.ui.LayeredIcon;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0006\u0010\u0018\u001a\u00020\u0000J\u001e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0082\u0004J\n\u0010$\u001a\u00020%H\u0096\u0080\u0004J\u0018\u0010&\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010(\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010)\u001a\u00020\u000fH\u0016J\u0006\u0010*\u001a\u00020!J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/swagger/core/visualEditing/SwVisualEditingLineMarkerRenderer;", "Lcom/intellij/swagger/core/providers/SwMergeableLineMarkerRenderer;", "lineMarker", "Lcom/intellij/swagger/core/visualEditing/SwVisualEditingActionLineMarker;", "lineRange", "Lcom/intellij/swagger/core/visualEditing/utils/SwInterval;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/swagger/core/visualEditing/SwVisualEditingActionLineMarker;Lcom/intellij/swagger/core/visualEditing/utils/SwInterval;Lcom/intellij/openapi/editor/Document;)V", "getLineRange", "()Lcom/intellij/swagger/core/visualEditing/utils/SwInterval;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "compositeIcon", "Lcom/intellij/ui/LayeredIcon;", "currentLineRepaintRequest", "Lcom/intellij/swagger/core/visualEditing/SwGutterRepaintRequest$RepaintLine;", "dispose", "", "withHideableSecondaryIcon", "icon", "Ljavax/swing/Icon;", "withAlwaysVisiblePrimaryIcon", "subscribedToMouseEvents", "repaintGutter", "event", "Lcom/intellij/swagger/core/visualEditing/SwEditorMouseEvent;", "repaintRequest", "(Lcom/intellij/swagger/core/visualEditing/SwEditorMouseEvent;Lcom/intellij/swagger/core/visualEditing/SwGutterRepaintRequest$RepaintLine;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processMouseEvent", "Lcom/intellij/swagger/core/visualEditing/SwGutterRepaintRequest;", "equals", "", "other", "", "hashCode", "", "shouldMakeMarkerVisible", "Lcom/intellij/swagger/core/visualEditing/SwEditorMouseEvent$HoverLine;", "isMouseOverSmallestHighlightedRange", "getIcon", "isHideableIconVisibleNow", "setVisible", "visible", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwVisualEditingLineMarkerRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwVisualEditingLineMarkerRenderer.kt\ncom/intellij/swagger/core/visualEditing/SwVisualEditingLineMarkerRenderer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,149:1\n23#2:150\n19#3:151\n*S KotlinDebug\n*F\n+ 1 SwVisualEditingLineMarkerRenderer.kt\ncom/intellij/swagger/core/visualEditing/SwVisualEditingLineMarkerRenderer\n*L\n35#1:150\n70#1:151\n*E\n"})
public final class SwVisualEditingLineMarkerRenderer
extends SwMergeableLineMarkerRenderer {
    @NotNull
    private final SwVisualEditingActionLineMarker lineMarker;
    @NotNull
    private final SwInterval lineRange;
    @NotNull
    private final Document document;
    @Nullable
    private CoroutineScope coroutineScope;
    @NotNull
    private final LayeredIcon compositeIcon;
    @NotNull
    private final SwGutterRepaintRequest.RepaintLine currentLineRepaintRequest;

    /*
     * WARNING - void declaration
     */
    public SwVisualEditingLineMarkerRenderer(@NotNull SwVisualEditingActionLineMarker lineMarker, @NotNull SwInterval lineRange, @NotNull Document document) {
        void $this$compositeIcon_u24lambda_u240;
        LayeredIcon layeredIcon;
        Intrinsics.checkNotNullParameter((Object)((Object)lineMarker), (String)"lineMarker");
        Intrinsics.checkNotNullParameter((Object)lineRange, (String)"lineRange");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        LineMarkerInfo lineMarkerInfo = (LineMarkerInfo)lineMarker;
        Icon icon = AllIcons.General.Add;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Add");
        super((LineMarkerInfo<PsiElement>)lineMarkerInfo, icon);
        this.lineMarker = lineMarker;
        this.lineRange = lineRange;
        this.document = document;
        LayeredIcon layeredIcon2 = layeredIcon = new LayeredIcon(2);
        SwVisualEditingLineMarkerRenderer swVisualEditingLineMarkerRenderer = this;
        boolean bl = false;
        $this$compositeIcon_u24lambda_u240.setIcon(null, 0);
        $this$compositeIcon_u24lambda_u240.setIcon(AllIcons.General.Add, 1);
        $this$compositeIcon_u24lambda_u240.setLayerEnabled(0, true);
        $this$compositeIcon_u24lambda_u240.setLayerEnabled(1, false);
        swVisualEditingLineMarkerRenderer.compositeIcon = layeredIcon;
        this.currentLineRepaintRequest = new SwGutterRepaintRequest.RepaintLine(this.lineRange.getStart());
    }

    @NotNull
    public final SwInterval getLineRange() {
        return this.lineRange;
    }

    @Override
    public void dispose() {
        block0: {
            SwVisualEditingLineMarkerRenderer $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SwVisualEditingLineMarkerRenderer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("CANCEL SCOPE for " + this.lineRange + " in " + this);
            CoroutineScope coroutineScope = this.coroutineScope;
            if (coroutineScope == null) break block0;
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)coroutineScope, (String)"Corresponding range highlighter is disposed", null, (int)2, null);
        }
    }

    @NotNull
    public final SwVisualEditingLineMarkerRenderer withHideableSecondaryIcon(@NotNull Icon icon) {
        SwVisualEditingLineMarkerRenderer swVisualEditingLineMarkerRenderer;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        SwVisualEditingLineMarkerRenderer $this$withHideableSecondaryIcon_u24lambda_u240 = swVisualEditingLineMarkerRenderer = this;
        boolean bl = false;
        $this$withHideableSecondaryIcon_u24lambda_u240.compositeIcon.setIcon(icon, 1);
        $this$withHideableSecondaryIcon_u24lambda_u240.compositeIcon.setLayerEnabled(1, false);
        return swVisualEditingLineMarkerRenderer;
    }

    @NotNull
    public final SwVisualEditingLineMarkerRenderer withAlwaysVisiblePrimaryIcon(@Nullable Icon icon) {
        SwVisualEditingLineMarkerRenderer swVisualEditingLineMarkerRenderer;
        SwVisualEditingLineMarkerRenderer $this$withAlwaysVisiblePrimaryIcon_u24lambda_u240 = swVisualEditingLineMarkerRenderer = this;
        boolean bl = false;
        $this$withAlwaysVisiblePrimaryIcon_u24lambda_u240.compositeIcon.setIcon(icon, 0);
        $this$withAlwaysVisiblePrimaryIcon_u24lambda_u240.compositeIcon.setLayerEnabled(0, icon != null);
        return swVisualEditingLineMarkerRenderer;
    }

    @NotNull
    public final SwVisualEditingLineMarkerRenderer subscribedToMouseEvents() {
        block0: {
            SwVisualEditingActionsService actionsService = SwVisualEditingActionsService.Companion.getInstance(this.lineMarker.getProject$intellij_swagger_core());
            CoroutineScope coroutineScope = this.coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)actionsService.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (boolean)false, (int)2, null);
            if (coroutineScope == null) break block0;
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(actionsService, this, null){
                int label;
                final /* synthetic */ SwVisualEditingActionsService $actionsService;
                final /* synthetic */ SwVisualEditingLineMarkerRenderer this$0;
                {
                    this.$actionsService = $actionsService;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = FlowKt.collectLatest((Flow)((Flow)this.$actionsService.getMouseEvents()), (Function2)((Function2)new Function2<SwEditorMouseEvent, Continuation<? super Unit>, Object>(this.this$0, null){
                                Object L$1;
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ SwVisualEditingLineMarkerRenderer this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    block6: {
                                        SwGutterRepaintRequest repaintRequest;
                                        SwEditorMouseEvent swEditorMouseEvent = (SwEditorMouseEvent)this.L$0;
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                void event;
                                                ResultKt.throwOnFailure((Object)$result);
                                                repaintRequest = SwVisualEditingLineMarkerRenderer.access$processMouseEvent(this.this$0, (SwEditorMouseEvent)event);
                                                if (!(repaintRequest instanceof SwGutterRepaintRequest.RepaintLine)) break;
                                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)repaintRequest);
                                                this.label = 1;
                                                Object object2 = SwVisualEditingLineMarkerRenderer.access$repaintGutter(this.this$0, (SwEditorMouseEvent)event, (SwGutterRepaintRequest.RepaintLine)repaintRequest, (Continuation)this);
                                                if (object2 == object) {
                                                    return object;
                                                }
                                                break block6;
                                            }
                                            case 1: {
                                                SwGutterRepaintRequest repaintRequest2 = (SwGutterRepaintRequest)this.L$1;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object2 = $result;
                                                break block6;
                                            }
                                        }
                                        if (!(repaintRequest instanceof SwGutterRepaintRequest.DoNothing)) {
                                            throw new NoWhenBranchMatchedException();
                                        }
                                    }
                                    return Unit.INSTANCE;
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(SwEditorMouseEvent p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        return this;
    }

    private final Object repaintGutter(SwEditorMouseEvent event, SwGutterRepaintRequest.RepaintLine repaintRequest, Continuation<? super Unit> $completion) {
        EditorGutter $this$asSafely$iv = event.getEditor().getGutter();
        boolean $i$f$asSafely = false;
        EditorGutter editorGutter = $this$asSafely$iv;
        if (!(editorGutter instanceof EditorGutterComponentEx)) {
            editorGutter = null;
        }
        EditorGutterComponentEx editorGutterComponentEx = (EditorGutterComponentEx)editorGutter;
        if (editorGutterComponentEx == null) {
            return Unit.INSTANCE;
        }
        EditorGutterComponentEx gutterComponent = editorGutterComponentEx;
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(event, gutterComponent, repaintRequest, null){
            int label;
            final /* synthetic */ SwEditorMouseEvent $event;
            final /* synthetic */ EditorGutterComponentEx $gutterComponent;
            final /* synthetic */ SwGutterRepaintRequest.RepaintLine $repaintRequest;
            {
                this.$event = $event;
                this.$gutterComponent = $gutterComponent;
                this.$repaintRequest = $repaintRequest;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (this.$event instanceof SwEditorMouseEvent.HoverLine) {
                            int lineWidth = this.$gutterComponent.getWhitespaceSeparatorOffset();
                            int effectiveYCoordinate = ((SwEditorMouseEvent.HoverLine)this.$event).getEditor().visualLineToY(this.$repaintRequest.getLine());
                            int lineHeight = ((SwEditorMouseEvent.HoverLine)this.$event).getEditor().getLineHeight();
                            this.$gutterComponent.repaint(0, effectiveYCoordinate, lineWidth, lineHeight);
                        } else {
                            this.$gutterComponent.repaint();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final SwGutterRepaintRequest processMouseEvent(SwEditorMouseEvent event) {
        SwGutterRepaintRequest swGutterRepaintRequest;
        if (!Intrinsics.areEqual((Object)event.getEditor().getDocument(), (Object)this.document)) {
            this.setVisible(false);
            swGutterRepaintRequest = this.currentLineRepaintRequest;
        } else if (event instanceof SwEditorMouseEvent.HoverLine && Intrinsics.areEqual((Object)((SwEditorMouseEvent.HoverLine)event).getEditor().getDocument(), (Object)this.document)) {
            boolean visible = this.shouldMakeMarkerVisible((SwEditorMouseEvent.HoverLine)event, this.document);
            this.setVisible(visible);
            swGutterRepaintRequest = this.currentLineRepaintRequest;
        } else if (event instanceof SwEditorMouseEvent.HoverLine && !Intrinsics.areEqual((Object)((SwEditorMouseEvent.HoverLine)event).getEditor().getDocument(), (Object)this.document) || event instanceof SwEditorMouseEvent.ExitEditorArea) {
            this.setVisible(false);
            swGutterRepaintRequest = this.currentLineRepaintRequest;
        } else {
            swGutterRepaintRequest = SwGutterRepaintRequest.DoNothing.INSTANCE;
        }
        return swGutterRepaintRequest;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof SwVisualEditingLineMarkerRenderer && Intrinsics.areEqual((Object)((SwVisualEditingLineMarkerRenderer)((Object)other)).lineRange, (Object)this.lineRange);
    }

    public int hashCode() {
        return this.lineRange.hashCode();
    }

    private final boolean shouldMakeMarkerVisible(SwEditorMouseEvent.HoverLine event, Document document) {
        return this.isMouseOverSmallestHighlightedRange(event, document);
    }

    private final boolean isMouseOverSmallestHighlightedRange(SwEditorMouseEvent.HoverLine event, Document document) {
        if (!this.lineRange.contains(event.getLine())) {
            return false;
        }
        SwTreeSearchData swTreeSearchData = SwIntervalTreeUtilsKt.findSmallestSubtreeFor(document, this.lineMarker.getProject$intellij_swagger_core(), event.getLine());
        if (swTreeSearchData == null) {
            return false;
        }
        SwTreeSearchData smallestTreeWithCurrentLine = swTreeSearchData;
        Integer smallestSubtreeStartOffset = smallestTreeWithCurrentLine.getFirstSubtreeStart();
        return (smallestSubtreeStartOffset == null || smallestSubtreeStartOffset >= event.getLine()) && Intrinsics.areEqual((Object)smallestTreeWithCurrentLine.getRange(), (Object)this.lineRange);
    }

    @NotNull
    public LayeredIcon getIcon() {
        return this.compositeIcon;
    }

    public final boolean isHideableIconVisibleNow() {
        return this.compositeIcon.isLayerEnabled(1);
    }

    private final void setVisible(boolean visible) {
        this.compositeIcon.setLayerEnabled(1, visible);
    }

    public static final /* synthetic */ SwGutterRepaintRequest access$processMouseEvent(SwVisualEditingLineMarkerRenderer $this, SwEditorMouseEvent event) {
        return $this.processMouseEvent(event);
    }

    public static final /* synthetic */ Object access$repaintGutter(SwVisualEditingLineMarkerRenderer $this, SwEditorMouseEvent event, SwGutterRepaintRequest.RepaintLine repaintRequest, Continuation $completion) {
        return $this.repaintGutter(event, repaintRequest, (Continuation<? super Unit>)$completion);
    }
}

