/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve;

import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbTextMessage;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceWrapper;
import com.intellij.psi.util.PsiTreeUtil;

public class PbTextMessageSetSupportingExtensionNameReference
extends PsiReferenceWrapper {
    public PbTextMessageSetSupportingExtensionNameReference(PsiReference originalPsiReference) {
        super(originalPsiReference);
    }

    public PsiElement resolve() {
        PbField messageSetField;
        PsiElement resolved = super.resolve();
        if (resolved instanceof PbMessageType && (messageSetField = this.getEquivalentMessageSetField((PbMessageType)resolved)) != null) {
            return messageSetField;
        }
        return resolved;
    }

    private PbField getEquivalentMessageSetField(PbMessageType messageType) {
        PbTextMessage parentMessage = (PbTextMessage)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PbTextMessage.class);
        if (parentMessage == null) {
            return null;
        }
        PbMessageType messageSetType = parentMessage.getDeclaredMessage();
        if (messageSetType == null) {
            return null;
        }
        if (!messageSetType.isMessageSet()) {
            return null;
        }
        for (PbField field : messageType.getSymbols(PbField.class)) {
            PbMessageType extendeeMessageType;
            PbMessageType fieldMessageType;
            PbTypeName extendeeTypeName;
            PbTypeName fieldTypeName;
            if (field.getCanonicalLabel() != PbField.CanonicalFieldLabel.OPTIONAL || (fieldTypeName = field.getTypeName()) == null || (extendeeTypeName = field.getExtendee()) == null || !messageType.equals(fieldMessageType = PbPsiUtil.resolveRefToType(fieldTypeName.getEffectiveReference(), PbMessageType.class)) || !messageSetType.equals(extendeeMessageType = PbPsiUtil.resolveRefToType(extendeeTypeName.getEffectiveReference(), PbMessageType.class))) continue;
            return field;
        }
        return null;
    }
}

