/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.diagnostics;

import com.intellij.internal.statistic.collectors.fus.DataContextUtils;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.jetbrains.rd.platform.util.DataContextKt;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u00c6\u0003J7\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0014\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001a\u001a\u00020\u001bH\u00d6\u0081\u0004J\n\u0010\u001c\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rdclient/diagnostics/ActionRequestFusData;", "", "actionId", "", "fileLanguage", "Lcom/intellij/lang/Language;", "injectedLanguage", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "<init>", "(Ljava/lang/String;Lcom/intellij/lang/Language;Lcom/intellij/lang/Language;Lcom/intellij/openapi/fileTypes/FileType;)V", "getActionId", "()Ljava/lang/String;", "getFileLanguage", "()Lcom/intellij/lang/Language;", "getInjectedLanguage", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.rd.client"})
public final class ActionRequestFusData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String actionId;
    @Nullable
    private final Language fileLanguage;
    @Nullable
    private final Language injectedLanguage;
    @Nullable
    private final FileType fileType;

    public ActionRequestFusData(@NotNull String actionId, @Nullable Language fileLanguage, @Nullable Language injectedLanguage, @Nullable FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        this.actionId = actionId;
        this.fileLanguage = fileLanguage;
        this.injectedLanguage = injectedLanguage;
        this.fileType = fileType;
    }

    @NotNull
    public final String getActionId() {
        return this.actionId;
    }

    @Nullable
    public final Language getFileLanguage() {
        return this.fileLanguage;
    }

    @Nullable
    public final Language getInjectedLanguage() {
        return this.injectedLanguage;
    }

    @Nullable
    public final FileType getFileType() {
        return this.fileType;
    }

    @NotNull
    public final String component1() {
        return this.actionId;
    }

    @Nullable
    public final Language component2() {
        return this.fileLanguage;
    }

    @Nullable
    public final Language component3() {
        return this.injectedLanguage;
    }

    @Nullable
    public final FileType component4() {
        return this.fileType;
    }

    @NotNull
    public final ActionRequestFusData copy(@NotNull String actionId, @Nullable Language fileLanguage, @Nullable Language injectedLanguage, @Nullable FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        return new ActionRequestFusData(actionId, fileLanguage, injectedLanguage, fileType);
    }

    public static /* synthetic */ ActionRequestFusData copy$default(ActionRequestFusData actionRequestFusData, String string, Language language, Language language2, FileType fileType, int n, Object object) {
        if ((n & 1) != 0) {
            string = actionRequestFusData.actionId;
        }
        if ((n & 2) != 0) {
            language = actionRequestFusData.fileLanguage;
        }
        if ((n & 4) != 0) {
            language2 = actionRequestFusData.injectedLanguage;
        }
        if ((n & 8) != 0) {
            fileType = actionRequestFusData.fileType;
        }
        return actionRequestFusData.copy(string, language, language2, fileType);
    }

    @NotNull
    public String toString() {
        return "ActionRequestFusData(actionId=" + this.actionId + ", fileLanguage=" + this.fileLanguage + ", injectedLanguage=" + this.injectedLanguage + ", fileType=" + this.fileType + ")";
    }

    public int hashCode() {
        int result2 = this.actionId.hashCode();
        result2 = result2 * 31 + (this.fileLanguage == null ? 0 : this.fileLanguage.hashCode());
        result2 = result2 * 31 + (this.injectedLanguage == null ? 0 : this.injectedLanguage.hashCode());
        result2 = result2 * 31 + (this.fileType == null ? 0 : this.fileType.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ActionRequestFusData)) {
            return false;
        }
        ActionRequestFusData actionRequestFusData = (ActionRequestFusData)other;
        if (!Intrinsics.areEqual((Object)this.actionId, (Object)actionRequestFusData.actionId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fileLanguage, (Object)actionRequestFusData.fileLanguage)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.injectedLanguage, (Object)actionRequestFusData.injectedLanguage)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fileType, (Object)actionRequestFusData.fileType);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdclient/diagnostics/ActionRequestFusData$Companion;", "", "<init>", "()V", "from", "Lcom/jetbrains/rdclient/diagnostics/ActionRequestFusData;", "actionId", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActionRequestFusData from(@NotNull String actionId, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            DataContext dataContext2 = Utils.getCachedOnlyDataContext((DataContext)dataContext);
            Language fileLanguage = DataContextUtils.getFileLanguage((DataContext)dataContext2);
            Language injected = DataContextUtils.INSTANCE.getInjectedOrFileLanguage(DataContextKt.getProject((DataContext)dataContext2), dataContext2);
            Language language = injected;
            if (language == null) {
                language = fileLanguage;
            }
            Language injectedLanguage = language;
            FileType fileType = DataContextUtils.getFileType((DataContext)dataContext2);
            return new ActionRequestFusData(actionId, fileLanguage, injectedLanguage, fileType);
        }

        @NotNull
        public final ActionRequestFusData from(@NotNull String actionId, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            FileType fileType = DocumentUtilKt.getFileTypeByName(document);
            LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
            Language fileLanguage = languageFileType != null ? languageFileType.getLanguage() : null;
            return new ActionRequestFusData(actionId, fileLanguage, null, fileType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

