/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.following;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.following.BackendUserOperations;
import com.intellij.cwm.plugin.following.ClientFollowMeManager;
import com.intellij.cwm.plugin.following.FollowMeManager;
import com.intellij.cwm.plugin.join.JoinLinkData;
import com.intellij.cwm.plugin.session.CodeWithMeSessionListener;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.codeWithMe.model.RdFocusLocation;
import com.jetbrains.codeWithMe.model.RdToolWindowFocusLocation;
import com.jetbrains.codeWithMe.model.UserFocusModel_GeneratedKt;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.codeWithMe.focus.UserFocusManager;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rdserver.core.RemoteClientSessionListener;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.ui.BackendUserFocusHost;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/cwm/plugin/following/CwmFollowingListener;", "Lcom/intellij/cwm/plugin/session/CodeWithMeSessionListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "sessionCreated", "", "joinLinkData", "Lcom/intellij/cwm/plugin/join/JoinLinkData;", "CwmFollowingFocusListener", "CwmLeadFocusHolder", "intellij.cwm.plugin"})
@SourceDebugExtension(value={"SMAP\nCwmFollowingListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CwmFollowingListener.kt\ncom/intellij/cwm/plugin/following/CwmFollowingListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,83:1\n30#2,2:84\n*S KotlinDebug\n*F\n+ 1 CwmFollowingListener.kt\ncom/intellij/cwm/plugin/following/CwmFollowingListener\n*L\n31#1:84,2\n*E\n"})
public final class CwmFollowingListener
implements CodeWithMeSessionListener {
    @NotNull
    private final Project project;

    public CwmFollowingListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public void sessionCreated(@NotNull JoinLinkData joinLinkData) {
        Intrinsics.checkNotNullParameter((Object)joinLinkData, (String)"joinLinkData");
        Lifetime lifetime = joinLinkData.getLifetime();
        MessageBusConnection connection = ApplicationKt.getApplication().getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
        connection.subscribe(RemoteClientSessionListener.Companion.getTOPIC(), (Object)new CwmFollowingFocusListener());
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<CwmLeadFocusHolder> serviceClass$iv = CwmLeadFocusHolder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        CwmLeadFocusHolder focusHolder = (CwmLeadFocusHolder)object;
        FollowMeManager.Companion.getInstance(this.project).getFollowers().advise(lifetime, arg_0 -> CwmFollowingListener.sessionCreated$lambda$0(this, focusHolder, arg_0));
        UserFocusManager.Companion.getInstance(this.project).getCurrentFocus().advise(lifetime, arg_0 -> CwmFollowingListener.sessionCreated$lambda$1(this, focusHolder, arg_0));
    }

    private static final Unit sessionCreated$lambda$0(CwmFollowingListener this$0, CwmLeadFocusHolder $focusHolder, IViewableMap.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ClientId leadId = (ClientId)event.getNewValueOpt();
        if (leadId == null) {
            ClientProjectSession clientProjectSession = ClientSessionsManager.Companion.getProjectSession(this$0.project, (ClientId)event.getKey());
            Intrinsics.checkNotNull((Object)clientProjectSession);
            ClientProjectSession followerSession = clientProjectSession;
            $focusHolder.setLeadFocus(followerSession, null);
        } else {
            ClientProjectSession clientProjectSession = ClientSessionsManager.Companion.getProjectSession(this$0.project, leadId);
            Intrinsics.checkNotNull((Object)clientProjectSession);
            ClientProjectSession leadSession = clientProjectSession;
            $focusHolder.refreshActiveToolWindow(leadSession);
        }
        return Unit.INSTANCE;
    }

    private static final Unit sessionCreated$lambda$1(CwmFollowingListener this$0, CwmLeadFocusHolder $focusHolder, RdFocusLocation it) {
        ClientProjectSession clientProjectSession = ClientSessionsManager.Companion.getProjectSession(this$0.project, ClientId.Companion.getLocalId());
        Intrinsics.checkNotNull((Object)clientProjectSession);
        ClientProjectSession localSession = clientProjectSession;
        $focusHolder.refreshActiveToolWindow(localSession);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/cwm/plugin/following/CwmFollowingListener$CwmFollowingFocusListener;", "Lcom/jetbrains/rdserver/core/RemoteClientSessionListener;", "<init>", "()V", "beforeProjectSessionInitialized", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "intellij.cwm.plugin"})
    @SourceDebugExtension(value={"SMAP\nCwmFollowingListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CwmFollowingListener.kt\ncom/intellij/cwm/plugin/following/CwmFollowingListener$CwmFollowingFocusListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,83:1\n30#2,2:84\n*S KotlinDebug\n*F\n+ 1 CwmFollowingListener.kt\ncom/intellij/cwm/plugin/following/CwmFollowingListener$CwmFollowingFocusListener\n*L\n55#1:84,2\n*E\n"})
    public static final class CwmFollowingFocusListener
    implements RemoteClientSessionListener {
        public void beforeProjectSessionInitialized(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            UserFocusModel_GeneratedKt.getUserFocusModel((Solution)RemoteSessionKt.getProtocolModel((ClientProjectSession)session)).getCurrentFocus().getChange().advise(lifetime, arg_0 -> CwmFollowingFocusListener.beforeProjectSessionInitialized$lambda$0(session, arg_0));
        }

        private static final Unit beforeProjectSessionInitialized$lambda$0(ClientProjectSession $session, RdFocusLocation it) {
            ComponentManager $this$service$iv = (ComponentManager)$session.getProject();
            boolean $i$f$service = false;
            Class<CwmLeadFocusHolder> serviceClass$iv = CwmLeadFocusHolder.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((CwmLeadFocusHolder)object).refreshActiveToolWindow($session);
            return Unit.INSTANCE;
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/cwm/plugin/following/CwmFollowingListener$CwmLeadFocusHolder;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "oldLeadFocus", "", "Lcom/intellij/openapi/client/ClientProjectSession;", "Lcom/jetbrains/codeWithMe/model/RdFocusLocation;", "setLeadFocus", "", "session", "userFocus", "refreshActiveToolWindow", "leadSession", "intellij.cwm.plugin"})
    private static final class CwmLeadFocusHolder {
        @NotNull
        private final Project project;
        @NotNull
        private final Map<ClientProjectSession, RdFocusLocation> oldLeadFocus;

        public CwmLeadFocusHolder(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.oldLeadFocus = new LinkedHashMap();
        }

        public final void setLeadFocus(@NotNull ClientProjectSession session, @Nullable RdFocusLocation userFocus) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            if (Intrinsics.areEqual((Object)this.oldLeadFocus.get(session), (Object)userFocus)) {
                return;
            }
            this.oldLeadFocus.put(session, userFocus);
            if (userFocus instanceof RdToolWindowFocusLocation) {
                BackendUserOperations.INSTANCE.jumpTo(session, (RdToolWindowFocusLocation)userFocus);
            }
        }

        public final void refreshActiveToolWindow(@NotNull ClientProjectSession leadSession) {
            Intrinsics.checkNotNullParameter((Object)leadSession, (String)"leadSession");
            RdFocusLocation userFocus = BackendUserFocusHost.Companion.getCurrentFocus(leadSession);
            for (ClientProjectSession followerSession : ClientFollowMeManager.Companion.getInstance(leadSession).getFollowerSessions()) {
                this.setLeadFocus(followerSession, userFocus);
            }
        }
    }
}

