/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.permissions;

import com.intellij.cwm.plugin.CodeWithMeBackendBundle;
import com.intellij.cwm.plugin.common.CodeWithMeCommonBundle;
import com.intellij.cwm.plugin.common.icons.CwmPluginCommonIcons;
import com.intellij.cwm.plugin.common.toolbar.CWMPopupHandler;
import com.intellij.cwm.plugin.join.CwmFeatureRegistryUtil;
import com.intellij.cwm.plugin.permissions.CwmSharedPermissionManager;
import com.intellij.cwm.plugin.permissions.PermissionUtilKt;
import com.intellij.cwm.plugin.permissions.PermissionsDialog;
import com.intellij.cwm.plugin.permissions.PermissionsFilesDialog;
import com.intellij.cwm.plugin.telephony.BackendTelephonyManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.platform.codeWithMe.permissions.FileAccessLevel;
import com.jetbrains.rd.platform.codeWithMe.permissions.PermissionsMode;
import com.jetbrains.rd.platform.codeWithMe.permissions.RunAccessLevel;
import com.jetbrains.rd.platform.codeWithMe.permissions.TerminalAccessLevel;
import com.jetbrains.rd.platform.codeWithMe.permissions.ToolWindowAccessLevel;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rdserver.permissions.PermissionModel;
import com.jetbrains.rdserver.toolWindow.BackendToolWindowModeProvider;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 L2\u00020\u0001:\u0002KLB#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u000bJ\u0016\u0010!\u001a\u00020\"*\u00020\u00102\b\b\u0001\u0010#\u001a\u00020$H\u0002J\u0012\u0010?\u001a\u00020@2\b\b\u0001\u0010#\u001a\u00020$H\u0002J\b\u0010A\u001a\u00020BH\u0014J\b\u0010C\u001a\u00020DH\u0014J\b\u0010E\u001a\u00020\"H\u0014J\b\u0010F\u001a\u00020\"H\u0016J\b\u0010G\u001a\u00020\"H\u0002J\u0010\u0010H\u001a\u00020\"2\u0006\u0010I\u001a\u00020)H\u0002J\b\u0010J\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010%\u001a\u00070&\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010'\u001a\u001e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(j\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*`+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00100\u001a\u0010\u0012\f\u0012\n 2*\u0004\u0018\u00010-0-01X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00106\u001a\u0010\u0012\f\u0012\n 2*\u0004\u0018\u0001040401X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010:\u001a\u0010\u0012\f\u0012\n 2*\u0004\u0018\u0001080801X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010>\u001a\u0010\u0012\f\u0012\n 2*\u0004\u0018\u00010<0<01X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/intellij/cwm/plugin/permissions/PermissionsDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "isInitialAccess", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/client/ClientProjectSession;Z)V", "(Lcom/intellij/openapi/project/Project;Z)V", "(Lcom/intellij/openapi/client/ClientProjectSession;Z)V", "warningIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "logoPane", "Ljavax/swing/JPanel;", "manager", "Lcom/intellij/cwm/plugin/permissions/CwmSharedPermissionManager;", "maximumAllowedModel", "Lcom/jetbrains/rdserver/permissions/PermissionModel;", "model", "getModel", "()Lcom/jetbrains/rdserver/permissions/PermissionModel;", "excludedFiles", "", "Ljava/nio/file/Path;", "empty", "Lcom/intellij/util/ui/JBEmptyBorder;", "safeStateLabel", "editFilesStateLabel", "unsafeStateLabel", "customStateLabel", "customizePane", "", "text", "", "help", "Lcom/intellij/ui/ContextHelpLabel;", "modeRadioButtons", "Ljava/util/LinkedHashMap;", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/PermissionsMode;", "Lcom/intellij/ui/components/JBRadioButton;", "Lkotlin/collections/LinkedHashMap;", "maximumFileAccessLevel", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/FileAccessLevel;", "fileAccessWarning", "Ljavax/swing/JLabel;", "fileAccessBox", "Lcom/intellij/openapi/ui/ComboBox;", "kotlin.jvm.PlatformType", "maximumTerminalAccessLevel", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/TerminalAccessLevel;", "terminalAccessWarning", "terminalAccessBox", "maximumRunAccessLevel", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/RunAccessLevel;", "runAccessWarning", "runAccessBox", "maximumToolWindowAccessLevel", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/ToolWindowAccessLevel;", "toolWindowAccessWarning", "toolWindowAccessBox", "multiLineLabelPane", "Ljavax/swing/JTextPane;", "createCenterPanel", "Ljavax/swing/JComponent;", "getOKAction", "Ljavax/swing/Action;", "doOKAction", "beforeShowCallback", "updateExcludedFiles", "setMode", "mode", "autoUpdateMode", "PreventAutoUpdateModeCookie", "Companion", "intellij.cwm.plugin"})
@SourceDebugExtension(value={"SMAP\nPermissionsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionsDialog.kt\ncom/intellij/cwm/plugin/permissions/PermissionsDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,463:1\n1068#2:464\n672#2,11:465\n13#3:476\n*S KotlinDebug\n*F\n+ 1 PermissionsDialog.kt\ncom/intellij/cwm/plugin/permissions/PermissionsDialog\n*L\n183#1:464\n434#1:465,11\n460#1:476\n*E\n"})
public final class PermissionsDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final ClientProjectSession session;
    private final boolean isInitialAccess;
    @NotNull
    private final Icon warningIcon;
    @NotNull
    private final JPanel logoPane;
    @NotNull
    private final CwmSharedPermissionManager manager;
    @NotNull
    private final PermissionModel maximumAllowedModel;
    @NotNull
    private final PermissionModel model;
    @NotNull
    private final List<Path> excludedFiles;
    @NotNull
    private final JBEmptyBorder empty;
    @NotNull
    private final JPanel safeStateLabel;
    @NotNull
    private final JPanel editFilesStateLabel;
    @NotNull
    private final JPanel unsafeStateLabel;
    @NotNull
    private final JPanel customStateLabel;
    @NotNull
    private final ContextHelpLabel help;
    @NotNull
    private final LinkedHashMap<PermissionsMode, JBRadioButton> modeRadioButtons;
    @NotNull
    private final FileAccessLevel maximumFileAccessLevel;
    @NotNull
    private final JLabel fileAccessWarning;
    @NotNull
    private final ComboBox<FileAccessLevel> fileAccessBox;
    @NotNull
    private final TerminalAccessLevel maximumTerminalAccessLevel;
    @NotNull
    private final JLabel terminalAccessWarning;
    @NotNull
    private final ComboBox<TerminalAccessLevel> terminalAccessBox;
    @NotNull
    private final RunAccessLevel maximumRunAccessLevel;
    @NotNull
    private final JLabel runAccessWarning;
    @NotNull
    private final ComboBox<RunAccessLevel> runAccessBox;
    @NotNull
    private final ToolWindowAccessLevel maximumToolWindowAccessLevel;
    @NotNull
    private final JLabel toolWindowAccessWarning;
    @NotNull
    private final ComboBox<ToolWindowAccessLevel> toolWindowAccessBox;
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    private PermissionsDialog(Project project, ClientProjectSession session, boolean isInitialAccess) {
        super(project, true);
        String string;
        void $this$toolWindowAccessBox_u24lambda_u240;
        Object $this$runAccessBox_u24lambda_u240;
        Object $this$terminalAccessBox_u24lambda_u240;
        ComboBox $this$fileAccessBox_u24lambda_u240;
        ComboBox $this$customStateLabel_u24lambda_u240;
        JPanel $this$unsafeStateLabel_u24lambda_u240;
        JPanel $this$editFilesStateLabel_u24lambda_u240;
        JPanel $this$safeStateLabel_u24lambda_u240;
        JPanel jPanel;
        JPanel $this$logoPane_u24lambda_u240;
        this.project = project;
        this.session = session;
        this.isInitialAccess = isInitialAccess;
        Icon icon = AllIcons.General.Warning;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
        this.warningIcon = icon;
        Object object = new JPanel((LayoutManager)new MigLayout("ins 0, novisualpadding, gap 0"));
        JPanel jPanel2 = object;
        PermissionsDialog permissionsDialog = this;
        boolean bl = false;
        $this$logoPane_u24lambda_u240.add(new JLabel(CwmPluginCommonIcons.CodeWithMeProduct_64));
        $this$logoPane_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)14, (int)8, (int)0, (int)18));
        permissionsDialog.logoPane = object;
        this.manager = CwmSharedPermissionManager.Companion.getInstance(this.project);
        this.maximumAllowedModel = this.manager.getMaximumPossiblePermissionModel();
        this.model = this.session == null ? this.manager.getProjectPermissionModel(this.project) : this.manager.getClientPermissionModel(this.session);
        this.excludedFiles = CollectionsKt.toMutableList((Collection)this.model.getExcludedFiles());
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)7, (int)20, (int)9, (int)20);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        this.empty = jBEmptyBorder;
        object = new JPanel((LayoutManager)new MigLayout("ins 0, fillx"));
        $this$logoPane_u24lambda_u240 = object;
        permissionsDialog = this;
        boolean bl2 = false;
        String text = this.session == null ? CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.state.safe.guests", new Object[0]) : CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.state.safe.guest", new Object[0]);
        JTextPane label = this.multiLineLabelPane(text);
        JPanel $this$safeStateLabel_u24lambda_u240_u240 = jPanel = new JPanel((LayoutManager)new MigLayout("ins 0, fillx"));
        boolean bl3 = false;
        $this$safeStateLabel_u24lambda_u240_u240.add((Component)label, "growx");
        JPanel pane = jPanel;
        $this$safeStateLabel_u24lambda_u240.add((Component)pane, "growx, wmin 100");
        label.setBorder((Border)this.empty);
        pane.setBackground(JBUI.CurrentTheme.NotificationInfo.backgroundColor());
        pane.setForeground(JBUI.CurrentTheme.NotificationInfo.foregroundColor());
        pane.setBorder((Border)new RoundedLineBorder(JBUI.CurrentTheme.NotificationInfo.borderColor(), 5, 0, 4, null));
        permissionsDialog.safeStateLabel = object;
        object = new JPanel((LayoutManager)new MigLayout("ins 0, fillx"));
        $this$safeStateLabel_u24lambda_u240 = object;
        permissionsDialog = this;
        boolean bl4 = false;
        text = this.session == null ? CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.state.edit.guests", new Object[0]) : CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.state.edit.guest", new Object[0]);
        this.customizePane($this$editFilesStateLabel_u24lambda_u240, text);
        permissionsDialog.editFilesStateLabel = object;
        object = new JPanel((LayoutManager)new MigLayout("ins 0, fillx"));
        $this$editFilesStateLabel_u24lambda_u240 = object;
        permissionsDialog = this;
        boolean bl5 = false;
        text = this.session == null ? CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.state.unsafe.guests", new Object[0]) : CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.state.unsafe.guest", new Object[0]);
        this.customizePane($this$unsafeStateLabel_u24lambda_u240, text);
        permissionsDialog.unsafeStateLabel = object;
        object = new JPanel((LayoutManager)new MigLayout("ins 0, fillx"));
        $this$unsafeStateLabel_u24lambda_u240 = object;
        permissionsDialog = this;
        boolean bl6 = false;
        text = this.session == null ? CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.state.custom.guests", new Object[0]) : CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.state.custom.guest", new Object[0]);
        this.customizePane((JPanel)$this$customStateLabel_u24lambda_u240, text);
        permissionsDialog.customStateLabel = object;
        ContextHelpLabel contextHelpLabel = ContextHelpLabel.createWithLink(null, (String)CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.help.text", new Object[0]), (String)CodeWithMeCommonBundle.INSTANCE.message("code.with.me.learn.more", new Object[0]), PermissionsDialog::help$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)contextHelpLabel, (String)"createWithLink(...)");
        this.help = contextHelpLabel;
        this.modeRadioButtons = new LinkedHashMap();
        this.maximumFileAccessLevel = this.maximumAllowedModel.getFileAccess();
        this.fileAccessWarning = new JLabel(this.warningIcon);
        object = FileAccessLevel.class;
        object = new ComboBox((ComboBoxModel)new EnumComboBoxModel<FileAccessLevel>(this, (Class<FileAccessLevel>)object){
            final /* synthetic */ PermissionsDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            protected EnumSet<FileAccessLevel> createEnumSet(Class<FileAccessLevel> en) {
                EnumSet<FileAccessLevel> enumSet;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter(en, (String)"en");
                EnumSet enumSet2 = super.createEnumSet(en);
                Intrinsics.checkNotNullExpressionValue((Object)enumSet2, (String)"createEnumSet(...)");
                Iterable iterable = enumSet2;
                PermissionsDialog permissionsDialog = this.this$0;
                boolean $i$f$filter = false;
                void var5_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    FileAccessLevel it = (FileAccessLevel)element$iv$iv;
                    boolean bl = false;
                    if (!(it.ordinal() <= PermissionsDialog.access$getMaximumFileAccessLevel$p(permissionsDialog).ordinal())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Set values$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                boolean $i$f$enumSetOf = false;
                EnumSet<FileAccessLevel> $this$enumSetOf_u24lambda_u243$iv = enumSet = EnumSet.noneOf(FileAccessLevel.class);
                boolean bl = false;
                $this$enumSetOf_u24lambda_u243$iv.addAll(values$iv);
                EnumSet<FileAccessLevel> enumSet3 = enumSet;
                Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"noneOf(T::class.java).apply { addAll(values) }");
                return enumSet3;
            }
        });
        $this$customStateLabel_u24lambda_u240 = object;
        permissionsDialog = this;
        boolean bl7 = false;
        $this$fileAccessBox_u24lambda_u240.addActionListener(arg_0 -> PermissionsDialog.fileAccessBox$lambda$0$0(this, arg_0));
        $this$fileAccessBox_u24lambda_u240.setRenderer(PermissionsDialog::fileAccessBox$lambda$0$1);
        permissionsDialog.fileAccessBox = object;
        this.maximumTerminalAccessLevel = this.maximumAllowedModel.getTerminalAccess();
        this.terminalAccessWarning = new JLabel(this.warningIcon);
        object = TerminalAccessLevel.class;
        object = new ComboBox((ComboBoxModel)new EnumComboBoxModel<TerminalAccessLevel>(this, object){
            final /* synthetic */ PermissionsDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            protected EnumSet<TerminalAccessLevel> createEnumSet(Class<TerminalAccessLevel> en) {
                EnumSet<TerminalAccessLevel> enumSet;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter(en, (String)"en");
                EnumSet enumSet2 = super.createEnumSet(en);
                Intrinsics.checkNotNullExpressionValue((Object)enumSet2, (String)"createEnumSet(...)");
                Iterable iterable = enumSet2;
                PermissionsDialog permissionsDialog = this.this$0;
                boolean $i$f$filter = false;
                void var5_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    TerminalAccessLevel it = (TerminalAccessLevel)element$iv$iv;
                    boolean bl = false;
                    if (!(it.ordinal() <= PermissionsDialog.access$getMaximumTerminalAccessLevel$p(permissionsDialog).ordinal())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Set values$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                boolean $i$f$enumSetOf = false;
                EnumSet<TerminalAccessLevel> $this$enumSetOf_u24lambda_u243$iv = enumSet = EnumSet.noneOf(TerminalAccessLevel.class);
                boolean bl = false;
                $this$enumSetOf_u24lambda_u243$iv.addAll(values$iv);
                EnumSet<TerminalAccessLevel> enumSet3 = enumSet;
                Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"noneOf(T::class.java).apply { addAll(values) }");
                return enumSet3;
            }
        });
        $this$fileAccessBox_u24lambda_u240 = object;
        permissionsDialog = this;
        boolean bl8 = false;
        $this$terminalAccessBox_u24lambda_u240.addActionListener(arg_0 -> PermissionsDialog.terminalAccessBox$lambda$0$0(this, arg_0));
        $this$terminalAccessBox_u24lambda_u240.setRenderer(PermissionsDialog::terminalAccessBox$lambda$0$1);
        permissionsDialog.terminalAccessBox = object;
        this.maximumRunAccessLevel = this.maximumAllowedModel.getRunAccess();
        this.runAccessWarning = new JLabel(this.warningIcon);
        object = RunAccessLevel.class;
        object = new ComboBox((ComboBoxModel)new EnumComboBoxModel<RunAccessLevel>(this, (Class<RunAccessLevel>)object){
            final /* synthetic */ PermissionsDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            protected EnumSet<RunAccessLevel> createEnumSet(Class<RunAccessLevel> en) {
                EnumSet<RunAccessLevel> enumSet;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter(en, (String)"en");
                EnumSet enumSet2 = super.createEnumSet(en);
                Intrinsics.checkNotNullExpressionValue((Object)enumSet2, (String)"createEnumSet(...)");
                Iterable iterable = enumSet2;
                PermissionsDialog permissionsDialog = this.this$0;
                boolean $i$f$filter = false;
                void var5_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    RunAccessLevel it = (RunAccessLevel)element$iv$iv;
                    boolean bl = false;
                    if (!(it.ordinal() <= PermissionsDialog.access$getMaximumRunAccessLevel$p(permissionsDialog).ordinal())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Set values$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                boolean $i$f$enumSetOf = false;
                EnumSet<RunAccessLevel> $this$enumSetOf_u24lambda_u243$iv = enumSet = EnumSet.noneOf(RunAccessLevel.class);
                boolean bl = false;
                $this$enumSetOf_u24lambda_u243$iv.addAll(values$iv);
                EnumSet<RunAccessLevel> enumSet3 = enumSet;
                Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"noneOf(T::class.java).apply { addAll(values) }");
                return enumSet3;
            }
        });
        $this$terminalAccessBox_u24lambda_u240 = object;
        permissionsDialog = this;
        boolean bl9 = false;
        $this$runAccessBox_u24lambda_u240.addActionListener(arg_0 -> PermissionsDialog.runAccessBox$lambda$0$0(this, arg_0));
        $this$runAccessBox_u24lambda_u240.setRenderer(PermissionsDialog::runAccessBox$lambda$0$1);
        permissionsDialog.runAccessBox = object;
        this.maximumToolWindowAccessLevel = this.maximumAllowedModel.getToolWindowAccess();
        this.toolWindowAccessWarning = new JLabel(this.warningIcon);
        object = ToolWindowAccessLevel.class;
        object = new ComboBox((ComboBoxModel)new EnumComboBoxModel<ToolWindowAccessLevel>(this, (Class<ToolWindowAccessLevel>)object){
            final /* synthetic */ PermissionsDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            protected EnumSet<ToolWindowAccessLevel> createEnumSet(Class<ToolWindowAccessLevel> en) {
                EnumSet<ToolWindowAccessLevel> enumSet;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter(en, (String)"en");
                EnumSet enumSet2 = super.createEnumSet(en);
                Intrinsics.checkNotNullExpressionValue((Object)enumSet2, (String)"createEnumSet(...)");
                Iterable iterable = enumSet2;
                PermissionsDialog permissionsDialog = this.this$0;
                boolean $i$f$filter = false;
                void var5_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    ToolWindowAccessLevel it = (ToolWindowAccessLevel)element$iv$iv;
                    boolean bl = false;
                    if (!(it.ordinal() <= PermissionsDialog.access$getMaximumToolWindowAccessLevel$p(permissionsDialog).ordinal())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Set values$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                boolean $i$f$enumSetOf = false;
                EnumSet<ToolWindowAccessLevel> $this$enumSetOf_u24lambda_u243$iv = enumSet = EnumSet.noneOf(ToolWindowAccessLevel.class);
                boolean bl = false;
                $this$enumSetOf_u24lambda_u243$iv.addAll(values$iv);
                EnumSet<ToolWindowAccessLevel> enumSet3 = enumSet;
                Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"noneOf(T::class.java).apply { addAll(values) }");
                return enumSet3;
            }
        });
        $this$runAccessBox_u24lambda_u240 = object;
        permissionsDialog = this;
        boolean bl10 = false;
        $this$toolWindowAccessBox_u24lambda_u240.addActionListener(arg_0 -> PermissionsDialog.toolWindowAccessBox$lambda$0$0(this, arg_0));
        $this$toolWindowAccessBox_u24lambda_u240.setRenderer(PermissionsDialog::toolWindowAccessBox$lambda$0$1);
        permissionsDialog.toolWindowAccessBox = object;
        this.fileAccessBox.setItem((Object)this.model.getFileAccess());
        this.terminalAccessBox.setItem((Object)this.model.getTerminalAccess());
        this.runAccessBox.setItem((Object)this.model.getRunAccess());
        this.toolWindowAccessBox.setItem((Object)this.model.getToolWindowAccess());
        Iterable $this$sortedBy$iv = (Iterable)PermissionsMode.getEntries();
        boolean $i$f$sortedBy = false;
        for (PermissionsMode mode : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PermissionsMode it = (PermissionsMode)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.ordinal());
                it = (PermissionsMode)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.ordinal()));
            }
        })) {
            JBRadioButton jBRadioButton;
            Map map2 = this.modeRadioButtons;
            JBRadioButton $this$_init__u24lambda_u241 = jBRadioButton = new JBRadioButton(mode.getTitle());
            boolean bl11 = false;
            $this$_init__u24lambda_u241.addActionListener(arg_0 -> PermissionsDialog.lambda$1$0(this, mode, arg_0));
            map2.put(mode, jBRadioButton);
        }
        this.autoUpdateMode();
        if (this.session == null) {
            string = CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.title", new Object[0]);
        } else {
            object = new Object[]{this.session.getName()};
            string = CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.title.per.user", (Object[])object);
        }
        this.setTitle(string);
        this.init();
    }

    public PermissionsDialog(@NotNull Project project, boolean isInitialAccess) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(project, null, isInitialAccess);
    }

    public PermissionsDialog(@NotNull ClientProjectSession session, boolean isInitialAccess) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this(session.getProject(), session, isInitialAccess);
    }

    @NotNull
    public final PermissionModel getModel() {
        return this.model;
    }

    private final void customizePane(JPanel $this$customizePane, @Nls String text) {
        JPanel jPanel;
        JTextPane label = this.multiLineLabelPane(text);
        JPanel $this$customizePane_u24lambda_u240 = jPanel = new JPanel((LayoutManager)new MigLayout("ins 0, fillx"));
        boolean bl = false;
        $this$customizePane_u24lambda_u240.add((Component)label, "growx");
        JPanel pane = jPanel;
        $this$customizePane.add((Component)pane, "growx, wmin 100");
        label.setBorder((Border)this.empty);
        pane.setBackground(JBUI.CurrentTheme.NotificationError.backgroundColor());
        pane.setForeground(JBUI.CurrentTheme.NotificationError.foregroundColor());
        pane.setBorder((Border)new RoundedLineBorder(JBUI.CurrentTheme.NotificationError.borderColor(), JBUI.scale((int)5), 0, 4, null));
    }

    private final JTextPane multiLineLabelPane(@Nls String text) {
        JTextPane jTextPane;
        JTextPane $this$multiLineLabelPane_u24lambda_u240 = jTextPane = new JTextPane();
        boolean bl = false;
        $this$multiLineLabelPane_u24lambda_u240.setEditable(false);
        $this$multiLineLabelPane_u24lambda_u240.setBackground(null);
        $this$multiLineLabelPane_u24lambda_u240.setFont((Font)JBUI.Fonts.label());
        $this$multiLineLabelPane_u24lambda_u240.setText(text);
        $this$multiLineLabelPane_u24lambda_u240.setMinimumSize(null);
        return jTextPane;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        void $this$createCenterPanel_u24lambda_u246_u240;
        JPanel jPanel;
        JPanel jPanel2;
        String string;
        Object[] $this$createCenterPanel_u24lambda_u243;
        JPanel jPanel3;
        JPanel $this$createCenterPanel_u24lambda_u240 = jPanel3 = new JPanel((LayoutManager)new MigLayout("fillx, ins 0, novisualpadding"));
        boolean bl = false;
        Object object = this.modeRadioButtons.values().iterator();
        while (object.hasNext()) {
            JBRadioButton radioButton;
            Intrinsics.checkNotNullExpressionValue((Object)object.next(), (String)"next(...)");
            $this$createCenterPanel_u24lambda_u240.add((Component)radioButton);
        }
        $this$createCenterPanel_u24lambda_u240.add((Component)this.help, "gapbefore 10");
        JPanel radioPanel = jPanel3;
        JPanel detailsPanel = new JPanel((LayoutManager)new MigLayout("gap 0, fillx, ins 0, wrap 3, novisualpadding, gapx 0, gapy 4", "[min!]15[min!][grow]", "[al baseline]"));
        detailsPanel.add(new JLabel(CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.file.access.label", new Object[0])));
        detailsPanel.add(this.fileAccessWarning);
        detailsPanel.add((Component)this.fileAccessBox, "grow");
        detailsPanel.add((Component)new ActionLink(CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.manage.hidden", new Object[0]), arg_0 -> PermissionsDialog.createCenterPanel$lambda$1(this, arg_0)), "skip 2, alignx left, gapleft 2, gapbottom 5");
        detailsPanel.add((Component)new JLabel(CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.terminal.access.label", new Object[0])), "split 2");
        detailsPanel.add(this.terminalAccessWarning);
        detailsPanel.add((Component)this.terminalAccessBox, "grow");
        detailsPanel.add(new JLabel(CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.run.access.label", new Object[0])));
        detailsPanel.add(this.runAccessWarning);
        detailsPanel.add((Component)this.runAccessBox, "grow");
        detailsPanel.add((Component)new JLabel(CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.toolWindow.access.label", new Object[0])), "split 2");
        detailsPanel.add((Component)ContextHelpLabel.create((String)BackendToolWindowModeProvider.INSTANCE.getSupportedToolWindowsList()));
        detailsPanel.add(this.toolWindowAccessWarning);
        detailsPanel.add((Component)this.toolWindowAccessBox, "grow");
        JPanel hideable = new JPanel((LayoutManager)new MigLayout("novisualpadding, ins 0, flowy, fillx, hidemode 3"));
        object = CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.details", new Object[0]);
        HideableDecorator decorator2 = new HideableDecorator(hideable, (String)object){
            final /* synthetic */ JPanel $hideable;
            {
                this.$hideable = $hideable;
                super($hideable, $super_call_param$1, false);
            }

            protected void on() {
                super.on();
                PermissionsDialog.access$createCenterPanel$pack(this.$hideable);
            }

            protected void off() {
                super.off();
                PermissionsDialog.access$createCenterPanel$pack(this.$hideable);
            }
        };
        decorator2.setOn(false);
        decorator2.setContentComponent((JComponent)detailsPanel);
        hideable.add((Component)detailsPanel, "growx, gaptop 9, gapleft 15");
        JPanel telephony = new JPanel((LayoutManager)new MigLayout("ins 10 0 0 0, novisualpadding, gap 0, flowy"));
        Property<Boolean> isTelephonyEnabled = BackendTelephonyManager.Companion.getInstance(this.project).isTelephonyEnabled();
        JCheckBox telephonyCheckbox = new JCheckBox(CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.auto.start.call", new Object[0]), (boolean)((Boolean)isTelephonyEnabled.getValue()));
        boolean isJcefSupported = JBCefApp.isSupported();
        telephony.add(telephonyCheckbox);
        JLabel micOffLabel = new JLabel(AllIcons.CodeWithMe.CwmMicOff);
        micOffLabel.setToolTipText(CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.auto.start.call.mic.cam", new Object[0]));
        JLabel camOffLabel = new JLabel(AllIcons.CodeWithMe.CwmCamOff);
        camOffLabel.setToolTipText(micOffLabel.getToolTipText());
        Object object2 = CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.call.start.info", new Object[0]);
        Object object3 = object2 = new JLabel((String)object2){

            public Font getFont() {
                JBFont jBFont = JBFont.label().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.NORMAL) - (float)2);
                Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"deriveFont(...)");
                return (Font)jBFont;
            }
        };
        JPanel jPanel4 = telephony;
        boolean bl2 = false;
        $this$createCenterPanel_u24lambda_u243.setForeground(UIUtil.getContextHelpForeground());
        jPanel4.add((Component)object2, "gapleft 15");
        if (isJcefSupported) {
            telephonyCheckbox.addActionListener(arg_0 -> PermissionsDialog.createCenterPanel$lambda$4(isTelephonyEnabled, arg_0));
        } else {
            telephonyCheckbox.setSelected(false);
            telephonyCheckbox.setEnabled(false);
            JEditorPane editorPane = new JEditorPane();
            editorPane.setEditable(false);
            editorPane.setEditorKit(HTMLEditorKitBuilder.Companion.simple());
            editorPane.setText(CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.call.unavailable", new Object[0]));
            editorPane.setBackground(UIUtil.getPanelBackground());
            editorPane.addHyperlinkListener(arg_0 -> PermissionsDialog.createCenterPanel$lambda$5(this, arg_0));
            telephony.add((Component)editorPane, "gaptop 9, wmax 90%");
        }
        if (this.session == null) {
            string = CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.header", new Object[0]);
        } else {
            $this$createCenterPanel_u24lambda_u243 = new Object[]{this.session.getName()};
            string = CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.header.user", $this$createCenterPanel_u24lambda_u243);
        }
        String headerText = string;
        JPanel $this$createCenterPanel_u24lambda_u246 = jPanel2 = new JPanel((LayoutManager)new MigLayout("fillx, ins 0, flowy, novisualpadding, hidemode 3, gapx 0, gapy 9", ""));
        boolean bl3 = false;
        $this$createCenterPanel_u24lambda_u246.add((Component)new JLabel(headerText), "grow");
        $this$createCenterPanel_u24lambda_u246.add((Component)radioPanel, "grow");
        JPanel jPanel5 = jPanel = new JPanel((LayoutManager)new MigLayout("fillx, flowy, ins 0, gap 0, novisualpadding, hidemode 3"));
        JPanel jPanel6 = $this$createCenterPanel_u24lambda_u246;
        boolean bl4 = false;
        $this$createCenterPanel_u24lambda_u246_u240.add((Component)this.safeStateLabel, "grow, w 100");
        $this$createCenterPanel_u24lambda_u246_u240.add((Component)this.editFilesStateLabel, "grow, w 100");
        $this$createCenterPanel_u24lambda_u246_u240.add((Component)this.unsafeStateLabel, "grow, w 100");
        $this$createCenterPanel_u24lambda_u246_u240.add((Component)this.customStateLabel, "grow, w 100");
        $this$createCenterPanel_u24lambda_u246_u240.add((Component)hideable, "growx, gaptop 4");
        jPanel6.add((Component)jPanel, "growx");
        if (!ExperimentalUI.Companion.isNewUI() && CwmFeatureRegistryUtil.INSTANCE.getTelephonyEnabledLocally() && this.session == null) {
            $this$createCenterPanel_u24lambda_u246.add((Component)telephony, "growx");
        }
        $this$createCenterPanel_u24lambda_u246.setBorder((Border)JBUI.Borders.empty((int)11, (int)0, (int)10, (int)0));
        JPanel leftPanel = jPanel2;
        jPanel2 = new MigLayout("ins 0 0 0 5, novisualpadding, gap 0, fill", "[pref!][grow]");
        JPanel $this$createCenterPanel_u24lambda_u247 = jPanel2 = new JPanel(leftPanel, this, hideable, (MigLayout)jPanel2){
            final /* synthetic */ JPanel $leftPanel;
            final /* synthetic */ PermissionsDialog this$0;
            final /* synthetic */ JPanel $hideable;
            {
                this.$leftPanel = $leftPanel;
                this.this$0 = $receiver;
                this.$hideable = $hideable;
                super((LayoutManager)$super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public void addNotify() {
                void $this$forEach$iv;
                super.addNotify();
                this.$leftPanel.addComponentListener(new ComponentAdapter(this.$hideable){
                    final /* synthetic */ JPanel $hideable;
                    {
                        this.$hideable = $hideable;
                    }

                    public void componentResized(ComponentEvent e) {
                        PermissionsDialog.access$createCenterPanel$pack(this.$hideable);
                    }
                });
                Collection<V> collection = PermissionsDialog.access$getModeRadioButtons$p(this.this$0).values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable iterable = collection;
                JPanel jPanel = this.$hideable;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JBRadioButton it = (JBRadioButton)element$iv;
                    boolean bl = false;
                    it.addActionListener(arg_0 -> createCenterPanel.6.addNotify$lambda$0$0(jPanel, arg_0));
                }
                PermissionsDialog.access$createCenterPanel$pack(this.$hideable);
            }

            private static final void addNotify$lambda$0$0(JPanel $hideable, ActionEvent it) {
                PermissionsDialog.access$createCenterPanel$pack($hideable);
            }
        };
        boolean bl5 = false;
        $this$createCenterPanel_u24lambda_u247.add((Component)this.logoPane, "ay top");
        $this$createCenterPanel_u24lambda_u247.add((Component)leftPanel, "grow");
        return jPanel2;
    }

    @NotNull
    protected Action getOKAction() {
        Action action;
        Action $this$getOKAction_u24lambda_u240 = action = super.getOKAction();
        boolean bl = false;
        String message = this.isInitialAccess ? CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.enable.access", new Object[0]) : CodeWithMeBackendBundle.INSTANCE.message("permission.dialog.apply", new Object[0]);
        $this$getOKAction_u24lambda_u240.putValue("Name", message);
        Action action2 = action;
        Intrinsics.checkNotNullExpressionValue((Object)action2, (String)"apply(...)");
        return action2;
    }

    protected void doOKAction() {
        PermissionModel model2 = new PermissionModel(this){
            final /* synthetic */ PermissionsDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public List<Path> getExcludedFiles() {
                return PermissionsDialog.access$getExcludedFiles$p(this.this$0);
            }

            public FileAccessLevel getFileAccess() {
                Object object = PermissionsDialog.access$getFileAccessBox$p(this.this$0).getItem();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
                return (FileAccessLevel)object;
            }

            public TerminalAccessLevel getTerminalAccess() {
                Object object = PermissionsDialog.access$getTerminalAccessBox$p(this.this$0).getItem();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
                return (TerminalAccessLevel)object;
            }

            public RunAccessLevel getRunAccess() {
                Object object = PermissionsDialog.access$getRunAccessBox$p(this.this$0).getItem();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
                return (RunAccessLevel)object;
            }

            public ToolWindowAccessLevel getToolWindowAccess() {
                Object object = PermissionsDialog.access$getToolWindowAccessBox$p(this.this$0).getItem();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
                return (ToolWindowAccessLevel)object;
            }
        };
        if (this.session != null) {
            this.manager.applyClientPermissionModel(this.session, model2);
        } else {
            this.manager.applyProjectPermissionModel(this.project, model2);
        }
        super.doOKAction();
    }

    public void beforeShowCallback() {
        super.beforeShowCallback();
        if (CWMPopupHandler.Companion.getShowNewStartSessionPopup()) {
            logger.warn("Permissions dialog should not be shown in new UI");
        }
    }

    private final void updateExcludedFiles() {
        new PermissionsFilesDialog(this.project, this.excludedFiles).showAndGet();
    }

    private final void setMode(PermissionsMode mode) {
        for (Map.Entry entry : ((Map)this.modeRadioButtons).entrySet()) {
            PermissionsMode radioButtonMode = (PermissionsMode)entry.getKey();
            JBRadioButton radioButton = (JBRadioButton)entry.getValue();
            radioButton.setSelected(radioButtonMode == mode);
        }
        PreventAutoUpdateModeCookie.INSTANCE.using((Function0<Unit>)((Function0)() -> PermissionsDialog.setMode$lambda$0(mode, this)));
        this.fileAccessWarning.setVisible(((FileAccessLevel)this.fileAccessBox.getItem()).compareTo((Enum)FileAccessLevel.Readonly) > 0);
        this.terminalAccessWarning.setVisible(((TerminalAccessLevel)this.terminalAccessBox.getItem()).compareTo((Enum)TerminalAccessLevel.Readonly) > 0);
        this.runAccessWarning.setVisible(((RunAccessLevel)this.runAccessBox.getItem()).compareTo((Enum)RunAccessLevel.Readonly) > 0);
        this.toolWindowAccessWarning.setVisible(((ToolWindowAccessLevel)this.toolWindowAccessBox.getItem()).compareTo((Enum)ToolWindowAccessLevel.Disabled) > 0);
        this.safeStateLabel.setVisible(!this.fileAccessWarning.isVisible() && !this.terminalAccessWarning.isVisible() && !this.runAccessWarning.isVisible());
        this.editFilesStateLabel.setVisible(this.fileAccessWarning.isVisible() && !this.terminalAccessWarning.isVisible() && !this.runAccessWarning.isVisible());
        this.unsafeStateLabel.setVisible(this.fileAccessWarning.isVisible() && this.terminalAccessWarning.isVisible() && this.runAccessWarning.isVisible());
        this.customStateLabel.setVisible(!this.safeStateLabel.isVisible() && !this.editFilesStateLabel.isVisible() && !this.unsafeStateLabel.isVisible());
    }

    private final void autoUpdateMode() {
        PermissionsMode permissionsMode;
        Object v0;
        block4: {
            if (PreventAutoUpdateModeCookie.INSTANCE.get()) {
                return;
            }
            Iterable $this$singleOrNull$iv = (Iterable)PermissionsMode.getEntries();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                PermissionsMode it = (PermissionsMode)element$iv;
                boolean bl = false;
                if (!(it.getFileAccess() == this.fileAccessBox.getItem() && it.getTerminalAccess() == this.terminalAccessBox.getItem() && it.getRunAccess() == this.runAccessBox.getItem() && it.getToolWindowAccess() == this.toolWindowAccessBox.getItem())) continue;
                if (found$iv) {
                    v0 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        if ((permissionsMode = (PermissionsMode)v0) == null) {
            permissionsMode = PermissionsMode.Custom;
        }
        PermissionsMode mode = permissionsMode;
        this.setMode(mode);
    }

    private static final void help$lambda$0() {
        BrowserUtil.browse((String)CodeWithMeCommonBundle.INSTANCE.message("code.with.me.learn.more.link", new Object[0]));
    }

    private static final void fileAccessBox$lambda$0$0(PermissionsDialog this$0, ActionEvent it) {
        this$0.autoUpdateMode();
    }

    private static final Component fileAccessBox$lambda$0$1(JList jList, FileAccessLevel value, int n, boolean bl, boolean bl2) {
        Intrinsics.checkNotNull((Object)value);
        return new JLabel(PermissionUtilKt.present(value));
    }

    private static final void terminalAccessBox$lambda$0$0(PermissionsDialog this$0, ActionEvent it) {
        this$0.autoUpdateMode();
    }

    private static final Component terminalAccessBox$lambda$0$1(JList jList, TerminalAccessLevel value, int n, boolean bl, boolean bl2) {
        Intrinsics.checkNotNull((Object)value);
        return new JLabel(PermissionUtilKt.present(value));
    }

    private static final void runAccessBox$lambda$0$0(PermissionsDialog this$0, ActionEvent it) {
        this$0.autoUpdateMode();
    }

    private static final Component runAccessBox$lambda$0$1(JList jList, RunAccessLevel value, int n, boolean bl, boolean bl2) {
        Intrinsics.checkNotNull((Object)value);
        return new JLabel(PermissionUtilKt.present(value));
    }

    private static final void toolWindowAccessBox$lambda$0$0(PermissionsDialog this$0, ActionEvent it) {
        this$0.autoUpdateMode();
    }

    private static final Component toolWindowAccessBox$lambda$0$1(JList jList, ToolWindowAccessLevel value, int n, boolean bl, boolean bl2) {
        Intrinsics.checkNotNull((Object)value);
        return new JLabel(PermissionUtilKt.present(value));
    }

    private static final void lambda$1$0(PermissionsDialog this$0, PermissionsMode $mode, ActionEvent it) {
        this$0.setMode($mode);
    }

    private static final void createCenterPanel$pack$lambda$2$0(Window $it) {
        $it.pack();
    }

    private static final void createCenterPanel$lambda$5$0(PermissionsDialog this$0) {
        this$0.doCancelAction();
        RuntimeChooserUtil.INSTANCE.showRuntimeChooserPopup();
    }

    private static final Unit createCenterPanel$lambda$1(PermissionsDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateExcludedFiles();
        return Unit.INSTANCE;
    }

    private static final void createCenterPanel$pack(JPanel hideable) {
        block0: {
            Window window = SwingUtilities.getWindowAncestor(hideable);
            if (window == null) break block0;
            Window it = window;
            boolean bl = false;
            SwingUtilities.invokeLater(() -> PermissionsDialog.createCenterPanel$pack$lambda$2$0(it));
        }
    }

    private static final void createCenterPanel$lambda$4(Property $isTelephonyEnabled, ActionEvent it) {
        $isTelephonyEnabled.set((Object)((Boolean)$isTelephonyEnabled.getValue() == false ? 1 : 0));
    }

    private static final void createCenterPanel$lambda$5(PermissionsDialog this$0, HyperlinkEvent it) {
        if (Intrinsics.areEqual((Object)it.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) && Intrinsics.areEqual((Object)it.getDescription(), (Object)"/runtime")) {
            ApplicationKt.getApplication().invokeLater(() -> PermissionsDialog.createCenterPanel$lambda$5$0(this$0));
        }
    }

    private static final Unit setMode$lambda$0(PermissionsMode $mode, PermissionsDialog this$0) {
        if ($mode.getFileAccess() != null) {
            this$0.fileAccessBox.setItem((Object)$mode.getFileAccess());
        }
        if ($mode.getTerminalAccess() != null) {
            this$0.terminalAccessBox.setItem((Object)$mode.getTerminalAccess());
        }
        if ($mode.getRunAccess() != null) {
            this$0.runAccessBox.setItem((Object)$mode.getRunAccess());
        }
        if ($mode.getToolWindowAccess() != null) {
            this$0.toolWindowAccessBox.setItem((Object)$mode.getToolWindowAccess());
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$createCenterPanel$pack(JPanel hideable) {
        PermissionsDialog.createCenterPanel$pack(hideable);
    }

    public static final /* synthetic */ LinkedHashMap access$getModeRadioButtons$p(PermissionsDialog $this) {
        return $this.modeRadioButtons;
    }

    public static final /* synthetic */ List access$getExcludedFiles$p(PermissionsDialog $this) {
        return $this.excludedFiles;
    }

    public static final /* synthetic */ ComboBox access$getFileAccessBox$p(PermissionsDialog $this) {
        return $this.fileAccessBox;
    }

    public static final /* synthetic */ ComboBox access$getTerminalAccessBox$p(PermissionsDialog $this) {
        return $this.terminalAccessBox;
    }

    public static final /* synthetic */ ComboBox access$getRunAccessBox$p(PermissionsDialog $this) {
        return $this.runAccessBox;
    }

    public static final /* synthetic */ ComboBox access$getToolWindowAccessBox$p(PermissionsDialog $this) {
        return $this.toolWindowAccessBox;
    }

    public static final /* synthetic */ FileAccessLevel access$getMaximumFileAccessLevel$p(PermissionsDialog $this) {
        return $this.maximumFileAccessLevel;
    }

    public static final /* synthetic */ TerminalAccessLevel access$getMaximumTerminalAccessLevel$p(PermissionsDialog $this) {
        return $this.maximumTerminalAccessLevel;
    }

    public static final /* synthetic */ RunAccessLevel access$getMaximumRunAccessLevel$p(PermissionsDialog $this) {
        return $this.maximumRunAccessLevel;
    }

    public static final /* synthetic */ ToolWindowAccessLevel access$getMaximumToolWindowAccessLevel$p(PermissionsDialog $this) {
        return $this.maximumToolWindowAccessLevel;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PermissionsDialog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PermissionsDialog.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/cwm/plugin/permissions/PermissionsDialog$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cwm.plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0005J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/cwm/plugin/permissions/PermissionsDialog$PreventAutoUpdateModeCookie;", "", "<init>", "()V", "underCookie", "", "get", "using", "", "action", "Lkotlin/Function0;", "intellij.cwm.plugin"})
    private static final class PreventAutoUpdateModeCookie {
        @NotNull
        public static final PreventAutoUpdateModeCookie INSTANCE = new PreventAutoUpdateModeCookie();
        private static boolean underCookie;

        private PreventAutoUpdateModeCookie() {
        }

        public final boolean get() {
            return underCookie;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void using(@NotNull Function0<Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            underCookie = true;
            try {
                action.invoke();
            }
            finally {
                underCookie = false;
            }
        }
    }
}

