/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BinaryOSProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.LineHandlerHelper;
import com.intellij.vcs.VcsLocaleHelper;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgLineProcessListener;
import org.zmlx.hg4idea.execution.ShellCommandException;

public final class ShellCommand {
    private final GeneralCommandLine myCommandLine;

    public ShellCommand(@NotNull List<@NonNls String> commandLine, @Nullable @NonNls String dir, @Nullable Charset charset) {
        if (commandLine == null) {
            ShellCommand.$$$reportNull$$$0(0);
        }
        if (commandLine.isEmpty()) {
            throw new IllegalArgumentException("commandLine is empty");
        }
        this.myCommandLine = new GeneralCommandLine(commandLine);
        if (dir != null) {
            this.myCommandLine.setWorkDirectory(new File(dir));
        }
        if (charset != null) {
            this.myCommandLine.setCharset(charset);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myCommandLine.getEnvironment().put("HGRCPATH", "");
        }
        this.myCommandLine.withEnvironment(VcsLocaleHelper.getDefaultLocaleEnvironmentVars((String)"hg"));
    }

    @NotNull
    public HgCommandResult execute(boolean showTextOnIndicator, boolean isBinary) throws ShellCommandException {
        CommandResultCollector listener = new CommandResultCollector(isBinary);
        this.execute(showTextOnIndicator, isBinary, listener);
        HgCommandResult hgCommandResult = listener.getResult();
        if (hgCommandResult == null) {
            ShellCommand.$$$reportNull$$$0(1);
        }
        return hgCommandResult;
    }

    public void execute(final boolean showTextOnIndicator, boolean isBinary, final @NotNull HgLineProcessListener listener) throws ShellCommandException {
        if (listener == null) {
            ShellCommand.$$$reportNull$$$0(2);
        }
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        try {
            BinaryOSProcessHandler processHandler = isBinary ? new BinaryOSProcessHandler(this.myCommandLine) : new KillableProcessHandler(this.myCommandLine);
            ProcessListener outputAdapter = new ProcessListener(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    for (String line : LineHandlerHelper.splitText((String)event.getText())) {
                        if (ProcessOutputTypes.STDOUT == outputType && indicator != null && showTextOnIndicator) {
                            indicator.setText2(line);
                        }
                        listener.onLineAvailable(line, outputType);
                    }
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    listener.setExitCode(event.getExitCode());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "org/zmlx/hg4idea/execution/ShellCommand$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            processHandler.addProcessListener(outputAdapter);
            processHandler.startNotify();
            while (!processHandler.waitFor(300L)) {
                try {
                    ProgressManager.checkCanceled();
                }
                catch (ProcessCanceledException pce) {
                    processHandler.destroyProcess();
                    listener.setExitCode(255);
                    throw pce;
                }
            }
            if (isBinary) {
                listener.setBinaryOutput(processHandler.getOutput());
            }
        }
        catch (ExecutionException e) {
            throw new ShellCommandException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/execution/ShellCommand";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/execution/ShellCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class CommandResultCollector
    extends HgLineProcessListener {
        @NotNull
        private final ProcessOutput myOutput;
        private final boolean myIsBinary;

        public CommandResultCollector(boolean binary) {
            this.myIsBinary = binary;
            this.myOutput = new ProcessOutput();
        }

        @Override
        protected void processOutputLine(@NotNull String line) {
            if (line == null) {
                CommandResultCollector.$$$reportNull$$$0(0);
            }
            this.myOutput.appendStdout(line);
        }

        @Override
        protected void processErrorLine(@NotNull String line) {
            if (line == null) {
                CommandResultCollector.$$$reportNull$$$0(1);
            }
            super.processErrorLine(line);
            this.myOutput.appendStderr(line);
        }

        @Override
        public void setExitCode(int exitCode) {
            super.setExitCode(exitCode);
            this.myOutput.setExitCode(exitCode);
        }

        public HgCommandResult getResult() {
            return this.myIsBinary ? new HgCommandResult(this.myOutput, this.getBinaryOutput()) : new HgCommandResult(this.myOutput);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "line";
            objectArray2[1] = "org/zmlx/hg4idea/execution/ShellCommand$CommandResultCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processOutputLine";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processErrorLine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

