/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables.panel.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.scientific.tables.api.DSTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.panel.DSTable;
import com.intellij.scientific.tables.panel.DSTableKt;
import com.intellij.scientific.tables.panel.DSTableWithStatistics;
import com.intellij.scientific.tables.panel.filtering.DSFilterController;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import java.awt.Component;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/scientific/tables/panel/actions/DSOpenFilterAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "findFilterController", "Lcom/intellij/scientific/tables/panel/filtering/DSFilterController;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "getOrCreateFilterController", "dataContext", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "isFiltersSupported", "intellij.scientific.tables"})
public final class DSOpenFilterAction
extends DumbAwareToggleAction
implements ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(this.isFiltersSupported(e));
        super.update(e);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DSFilterController dSFilterController = this.findFilterController(dataContext);
        return dSFilterController != null ? dSFilterController.isFiltersApplied() : false;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DSTable dSTable = (DSTable)e.getData(DSTableKt.getDS_TABLE_DATA_KEY());
        if (dSTable == null) {
            return;
        }
        DSTable table = dSTable;
        DSTableWithStatistics dSTableWithStatistics = table instanceof DSTableWithStatistics ? (DSTableWithStatistics)table : null;
        if (dSTableWithStatistics == null || (dSTableWithStatistics = dSTableWithStatistics.getGrid()) == null) {
            return;
        }
        DSTableWithStatistics grid2 = dSTableWithStatistics;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DSFilterController controller = this.getOrCreateFilterController(dataContext, (DataGrid)grid2);
        JBPopup jBPopup = controller.createFiltersPopup();
        AbstractPopup abstractPopup = jBPopup instanceof AbstractPopup ? (AbstractPopup)jBPopup : null;
        if (abstractPopup == null) {
            return;
        }
        AbstractPopup popup = abstractPopup;
        Component component = grid2.getPanel().getTopComponent();
        int heightDelta = component != null ? component.getHeight() : 10;
        int widthDelta = Math.max(Math.max(popup.getPreferredContentSize().width + 100, popup.getMinimumSize().width), controller.getContentPreferredWidth());
        Point relativePointCoordinates = new Point(((DSTableWithStatistics)table).getComponent().getSize().width - widthDelta, heightDelta);
        RelativePoint relativePointToTable = new RelativePoint((Component)grid2.getPanel().getComponent(), relativePointCoordinates);
        popup.show(relativePointToTable);
    }

    private final DSFilterController findFilterController(DataContext context) {
        DataGrid dataGrid = (DataGrid)context.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            return null;
        }
        DataGrid grid2 = dataGrid;
        return (DSFilterController)grid2.getUserData(DSFilterController.DS_TABLES_FILTER_CONTROLLER);
    }

    private final DSFilterController getOrCreateFilterController(DataContext dataContext, DataGrid grid2) {
        DSFilterController dSFilterController = this.findFilterController(dataContext);
        if (dSFilterController == null) {
            dSFilterController = new DSFilterController(grid2);
        }
        return dSFilterController;
    }

    private final boolean isFiltersSupported(AnActionEvent e) {
        DSTableDataRetrieverFromDataSource tableDataRetriever;
        DSTable table;
        DSTable dSTable = table = (DSTable)e.getData(DSTableKt.getDS_TABLE_DATA_KEY());
        DSTableDataRetrieverFromDataSource dSTableDataRetrieverFromDataSource = tableDataRetriever = dSTable != null ? dSTable.getTableDataRetrieverFromDataSource() : null;
        if (dSTableDataRetrieverFromDataSource == null) {
            return false;
        }
        return dSTableDataRetrieverFromDataSource.isFiltersSupported();
    }
}

