/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class InjectedDataKeys {
    private static final String ourInjectedPrefix = "$injected$.";
    private static final Map<String, String> ourInjectableIds = new HashMap<String, String>();
    public static final DataKey<Editor> EDITOR = InjectedDataKeys.injectedKey(CommonDataKeys.EDITOR);
    public static final DataKey<Caret> CARET = InjectedDataKeys.injectedKey(CommonDataKeys.CARET);
    public static final DataKey<VirtualFile> VIRTUAL_FILE = InjectedDataKeys.injectedKey(CommonDataKeys.VIRTUAL_FILE);
    public static final DataKey<PsiFile> PSI_FILE = InjectedDataKeys.injectedKey(CommonDataKeys.PSI_FILE);
    public static final DataKey<PsiElement> PSI_ELEMENT = InjectedDataKeys.injectedKey(CommonDataKeys.PSI_ELEMENT);
    public static final DataKey<Language> LANGUAGE = InjectedDataKeys.injectedKey(CommonDataKeys.LANGUAGE);

    private InjectedDataKeys() {
    }

    @ApiStatus.Internal
    @Nullable
    public static String injectedId(@NotNull String dataId) {
        if (dataId == null) {
            InjectedDataKeys.$$$reportNull$$$0(0);
        }
        return ourInjectableIds.get(dataId);
    }

    @ApiStatus.Internal
    @Nullable
    public static String uninjectedId(@NotNull String dataId) {
        if (dataId == null) {
            InjectedDataKeys.$$$reportNull$$$0(1);
        }
        return InjectedDataKeys.isInjected(dataId) ? dataId.substring(ourInjectedPrefix.length()) : null;
    }

    private static boolean isInjected(@NotNull String dataId) {
        if (dataId == null) {
            InjectedDataKeys.$$$reportNull$$$0(2);
        }
        return dataId.startsWith(ourInjectedPrefix);
    }

    @ApiStatus.Internal
    @NotNull
    public static <T> DataKey<T> injectedKey(@NotNull DataKey<T> key) {
        if (key == null) {
            InjectedDataKeys.$$$reportNull$$$0(3);
        }
        String injectedId = ourInjectedPrefix + key.getName();
        ourInjectableIds.put(key.getName(), injectedId);
        DataKey dataKey = DataKey.create((String)injectedId);
        if (dataKey == null) {
            InjectedDataKeys.$$$reportNull$$$0(4);
        }
        return dataKey;
    }

    @ApiStatus.Internal
    @Nullable
    public static Object getInjectedData(@NotNull String dataId, @NotNull DataProvider dataProvider) {
        String injectedId;
        if (dataId == null) {
            InjectedDataKeys.$$$reportNull$$$0(5);
        }
        if (dataProvider == null) {
            InjectedDataKeys.$$$reportNull$$$0(6);
        }
        Object injected = (injectedId = InjectedDataKeys.injectedId(dataId)) == null ? null : dataProvider.getData(injectedId);
        return injected == null || injected == CustomizedDataContext.EXPLICIT_NULL ? dataProvider.getData(dataId) : injected;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/InjectedDataKeys";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/InjectedDataKeys";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "injectedKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "injectedId";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "uninjectedId";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInjected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "injectedKey";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

