/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.impl.PersistentRangeHighlighterImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterTree;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.impl.NonCancelableIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import java.awt.Color;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public sealed class RangeHighlighterImpl
extends RangeMarkerImpl
implements RangeHighlighterEx
permits PersistentRangeHighlighterImpl {
    private static final Logger LOG = Logger.getInstance(RangeHighlighterImpl.class);
    private static final Color NULL_COLOR = new Color(0, 0, 0);
    private boolean visibleIfFolded;
    private final MarkupModelImpl myModel;
    private TextAttributes myForcedTextAttributes;
    private TextAttributesKey myTextAttributesKey;
    private LineMarkerRenderer myLineMarkerRenderer;
    private Color myErrorStripeColor;
    private Color myLineSeparatorColor;
    private SeparatorPlacement mySeparatorPlacement;
    private GutterIconRenderer myGutterIconRenderer;
    private volatile Object myErrorStripeTooltip;
    private MarkupEditorFilter myFilter;
    private CustomHighlighterRenderer myCustomRenderer;
    private LineSeparatorRenderer myLineSeparatorRenderer;
    @Mask
    private byte myFlags;
    private static final byte AFTER_END_OF_LINE_MASK = 1;
    private static final byte ERROR_STRIPE_IS_THIN_MASK = 2;
    private static final byte TARGET_AREA_IS_EXACT_MASK = 4;
    private static final byte IN_BATCH_CHANGE_MASK = 8;
    static final byte CHANGED_MASK = 16;
    static final byte RENDERERS_CHANGED_MASK = 32;
    static final byte FONT_STYLE_CHANGED_MASK = 64;
    static final byte FOREGROUND_COLOR_CHANGED_MASK = -128;

    RangeHighlighterImpl(@NotNull MarkupModelImpl model2, int start, int end, int layer, @NotNull HighlighterTargetArea target, @Nullable TextAttributesKey textAttributesKey, boolean greedyToLeft, boolean greedyToRight) {
        if (model2 == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(0);
        }
        if (target == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(1);
        }
        super((DocumentEx)model2.getDocument(), start, end, false, true);
        this.myFilter = MarkupEditorFilter.EMPTY;
        this.myTextAttributesKey = textAttributesKey;
        this.setFlag((byte)4, target == HighlighterTargetArea.EXACT_RANGE);
        this.myModel = model2;
        this.registerInTree((DocumentEx)model2.getDocument(), start, end, greedyToLeft, greedyToRight, layer);
        if (LOG.isTraceEnabled()) {
            LOG.trace("RangeHighlighterImpl: create " + String.valueOf(this) + "; " + this.getId() + (String)(ProgressIndicatorProvider.getGlobalProgressIndicator() == null ? "" : "; progress=" + String.valueOf(ProgressIndicatorProvider.getGlobalProgressIndicator())));
        }
    }

    private boolean isFlagSet(@Flag byte mask) {
        return BitUtil.isSet((byte)this.myFlags, (byte)mask);
    }

    private void setFlag(@Flag byte mask, boolean value) {
        this.myFlags = BitUtil.set((byte)this.myFlags, (byte)mask, (boolean)value);
    }

    private void setMask(@Mask int mask, @Mask int value) {
        this.myFlags = (byte)(this.myFlags & ~mask | value);
    }

    @Override
    public TextAttributesKey getTextAttributesKey() {
        return this.myTextAttributesKey;
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public TextAttributes getForcedTextAttributes() {
        return this.myForcedTextAttributes;
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public Color getForcedErrorStripeMarkColor() {
        return this.myErrorStripeColor;
    }

    @Override
    @Nullable
    public TextAttributes getTextAttributes(@Nullable(value="when null, the global scheme will be used") @Nullable(value="when null, the global scheme will be used") EditorColorsScheme scheme) {
        if (this.myForcedTextAttributes != null) {
            return this.myForcedTextAttributes;
        }
        if (this.myTextAttributesKey == null) {
            return null;
        }
        EditorColorsScheme colorScheme = scheme == null ? EditorColorsManager.getInstance().getGlobalScheme() : scheme;
        return colorScheme.getAttributes(this.myTextAttributesKey);
    }

    private void runUnderWriteLock(Runnable runnable) {
        RangeMarkerTree.RMNode node = this.myNode;
        if (node == null) {
            runnable.run();
        } else {
            node.getTree().runUnderWriteLock(runnable);
        }
    }

    @Override
    public void setTextAttributes(@Nullable TextAttributes textAttributes) {
        boolean attributesChanged;
        TextAttributes old = this.myForcedTextAttributes;
        if (old == textAttributes) {
            return;
        }
        this.myForcedTextAttributes = textAttributes;
        boolean erasedChanged = old == TextAttributes.ERASE_MARKER || textAttributes == TextAttributes.ERASE_MARKER || old == null && this.myTextAttributesKey != null;
        boolean bl = attributesChanged = !Objects.equals(old, textAttributes);
        if (erasedChanged || attributesChanged) {
            boolean fontStyleChanged = erasedChanged || RangeHighlighterImpl.getFontStyle(old) != RangeHighlighterImpl.getFontStyle(textAttributes);
            boolean foregroundColorChanged = erasedChanged || !Objects.equals(RangeHighlighterImpl.getForegroundColor(old), RangeHighlighterImpl.getForegroundColor(textAttributes));
            this.fireChanged(false, fontStyleChanged, foregroundColorChanged);
        }
    }

    @Override
    public void setTextAttributesKey(@NotNull TextAttributesKey textAttributesKey) {
        if (textAttributesKey == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(2);
        }
        TextAttributesKey old = this.myTextAttributesKey;
        this.myTextAttributesKey = textAttributesKey;
        if (!textAttributesKey.equals((Object)old)) {
            this.fireChanged(false, this.myForcedTextAttributes == null, this.myForcedTextAttributes == null);
        }
    }

    @Override
    public void setVisibleIfFolded(boolean value) {
        if (this.isVisibleIfFolded() != value) {
            this.runUnderWriteLock(() -> {
                this.visibleIfFolded = value;
            });
        }
    }

    @Override
    public boolean isVisibleIfFolded() {
        return this.visibleIfFolded;
    }

    private static int getFontStyle(@Nullable TextAttributes textAttributes) {
        return textAttributes == null ? 0 : textAttributes.getFontType();
    }

    private static Color getForegroundColor(TextAttributes textAttributes) {
        return textAttributes == null ? null : textAttributes.getForegroundColor();
    }

    @Override
    @NotNull
    public HighlighterTargetArea getTargetArea() {
        HighlighterTargetArea highlighterTargetArea = this.isFlagSet((byte)4) ? HighlighterTargetArea.EXACT_RANGE : HighlighterTargetArea.LINES_IN_RANGE;
        if (highlighterTargetArea == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(3);
        }
        return highlighterTargetArea;
    }

    @Override
    public LineMarkerRenderer getLineMarkerRenderer() {
        return this.myLineMarkerRenderer;
    }

    @Override
    public void setLineMarkerRenderer(LineMarkerRenderer renderer) {
        LineMarkerRenderer old = this.myLineMarkerRenderer;
        this.myLineMarkerRenderer = renderer;
        if (!Objects.equals(old, renderer)) {
            this.fireChanged(true, false, false);
        }
    }

    @Override
    public CustomHighlighterRenderer getCustomRenderer() {
        return this.myCustomRenderer;
    }

    @Override
    public void setCustomRenderer(CustomHighlighterRenderer renderer) {
        CustomHighlighterRenderer old = this.myCustomRenderer;
        this.myCustomRenderer = renderer;
        if (!Objects.equals(old, renderer)) {
            this.fireChanged(true, false, false);
        }
    }

    @Override
    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    @Override
    public void setGutterIconRenderer(GutterIconRenderer renderer) {
        GutterIconRenderer old = this.myGutterIconRenderer;
        this.myGutterIconRenderer = renderer;
        if (!Objects.equals(old, renderer)) {
            this.fireChanged(true, false, false);
            if (old instanceof Disposable) {
                Disposable oldDisposableRenderer = (Disposable)old;
                Disposer.dispose((Disposable)oldDisposableRenderer);
            }
        }
    }

    @Override
    public Color getErrorStripeMarkColor(@Nullable(value="when null, the global scheme will be used") @Nullable(value="when null, the global scheme will be used") EditorColorsScheme scheme) {
        if (this.myErrorStripeColor == NULL_COLOR) {
            return null;
        }
        if (this.myErrorStripeColor != null) {
            return this.myErrorStripeColor;
        }
        if (this.myForcedTextAttributes != null) {
            return this.myForcedTextAttributes.getErrorStripeColor();
        }
        TextAttributes textAttributes = this.getTextAttributes(scheme);
        return textAttributes != null ? textAttributes.getErrorStripeColor() : null;
    }

    @Override
    public void setErrorStripeMarkColor(@Nullable Color color) {
        if (color == null) {
            color = NULL_COLOR;
        }
        Color old = this.myErrorStripeColor;
        this.myErrorStripeColor = color;
        if (!Objects.equals(old, color)) {
            this.fireChanged(false, false, false);
        }
    }

    @Override
    public Object getErrorStripeTooltip() {
        return this.myErrorStripeTooltip;
    }

    @Override
    public void setErrorStripeTooltip(Object tooltipObject) {
        Object old = this.myErrorStripeTooltip;
        this.myErrorStripeTooltip = tooltipObject;
        if (!Objects.equals(old, tooltipObject)) {
            this.fireChanged(false, false, false);
        }
    }

    @Override
    public boolean isThinErrorStripeMark() {
        return this.isFlagSet((byte)2);
    }

    @Override
    public void setThinErrorStripeMark(boolean value) {
        boolean old = this.isThinErrorStripeMark();
        if (old != value) {
            this.setFlag((byte)2, value);
            this.fireChanged(false, false, false);
        }
    }

    @Override
    public Color getLineSeparatorColor() {
        return this.myLineSeparatorColor;
    }

    @Override
    public void setLineSeparatorColor(Color color) {
        Color old = this.myLineSeparatorColor;
        this.myLineSeparatorColor = color;
        if (!Objects.equals(old, color)) {
            this.fireChanged(false, false, false);
        }
    }

    @Override
    public SeparatorPlacement getLineSeparatorPlacement() {
        return this.mySeparatorPlacement;
    }

    @Override
    public void setLineSeparatorPlacement(@Nullable SeparatorPlacement placement) {
        SeparatorPlacement old = this.mySeparatorPlacement;
        this.mySeparatorPlacement = placement;
        if (!Objects.equals((Object)old, (Object)placement)) {
            this.fireChanged(false, false, false);
        }
    }

    @Override
    public void setEditorFilter(@NotNull MarkupEditorFilter filter) {
        if (filter == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(4);
        }
        this.myFilter = filter;
        this.fireChanged(false, false, false);
    }

    @Override
    @NotNull
    public MarkupEditorFilter getEditorFilter() {
        MarkupEditorFilter markupEditorFilter = this.myFilter;
        if (markupEditorFilter == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(5);
        }
        return markupEditorFilter;
    }

    @Override
    public boolean isAfterEndOfLine() {
        return this.isFlagSet((byte)1);
    }

    @Override
    public void setAfterEndOfLine(boolean afterEndOfLine) {
        boolean old = this.isAfterEndOfLine();
        if (old != afterEndOfLine) {
            this.setFlag((byte)1, afterEndOfLine);
            this.fireChanged(false, false, false);
        }
    }

    public void setGreedyToLeft(boolean greedy) {
        boolean old = this.isGreedyToLeft();
        if (old != greedy) {
            super.setGreedyToLeft(greedy);
            this.fireChanged(false, false, false);
        }
    }

    public void setGreedyToRight(boolean greedy) {
        boolean old = this.isGreedyToRight();
        if (old != greedy) {
            super.setGreedyToRight(greedy);
            this.fireChanged(false, false, false);
        }
    }

    public void setStickingToRight(boolean value) {
        boolean old = this.isStickingToRight();
        if (old != value) {
            super.setStickingToRight(value);
            this.fireChanged(false, false, false);
        }
    }

    @Override
    public void fireChanged(boolean renderersChanged, boolean fontStyleChanged, boolean foregroundColorChanged) {
        this.myNode.getTree().assertMayModify();
        if (this.isFlagSet((byte)8)) {
            int changedFlags = -16;
            int value = 0x10 | (renderersChanged ? 32 : 0) | (fontStyleChanged ? 64 : 0) | (foregroundColorChanged ? -128 : 0);
            this.setMask(changedFlags, value | this.myFlags);
        } else {
            this.myModel.fireAttributesChanged(this, renderersChanged, fontStyleChanged, foregroundColorChanged);
        }
        this.myNode.attributesChanged();
    }

    @Override
    public int getAffectedAreaStartOffset() {
        int startOffset = this.getStartOffset();
        return switch (this.getTargetArea()) {
            default -> throw new MatchException(null, null);
            case HighlighterTargetArea.EXACT_RANGE -> startOffset;
            case HighlighterTargetArea.LINES_IN_RANGE -> {
                Document document = this.myModel.getDocument();
                int textLength = document.getTextLength();
                if (startOffset >= textLength) {
                    yield textLength;
                }
                yield document.getLineStartOffset(document.getLineNumber(startOffset));
            }
        };
    }

    @Override
    public int getAffectedAreaEndOffset() {
        int endOffset = this.getEndOffset();
        return switch (this.getTargetArea()) {
            default -> throw new MatchException(null, null);
            case HighlighterTargetArea.EXACT_RANGE -> endOffset;
            case HighlighterTargetArea.LINES_IN_RANGE -> {
                Document document = this.myModel.getDocument();
                int textLength = document.getTextLength();
                if (endOffset >= textLength) {
                    yield endOffset;
                }
                yield Math.min(textLength, document.getLineEndOffset(document.getLineNumber(endOffset)) + 1);
            }
        };
    }

    @Mask
    synchronized byte changeAttributesNoEvents(@NotNull Consumer<? super RangeHighlighterEx> change) {
        byte result2;
        if (change == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(6);
        }
        assert (!this.isFlagSet((byte)8));
        assert (!this.isFlagSet((byte)16));
        this.setMask(-24, 8);
        try {
            change.consume((Object)this);
        }
        finally {
            result2 = this.myFlags;
            this.setMask(-8, 0);
        }
        return result2;
    }

    @NotNull
    private MarkupModel getMarkupModel() {
        MarkupModelImpl markupModelImpl = this.myModel;
        if (markupModelImpl == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(7);
        }
        return markupModelImpl;
    }

    @Override
    public void setLineSeparatorRenderer(LineSeparatorRenderer renderer) {
        LineSeparatorRenderer old = this.myLineSeparatorRenderer;
        this.myLineSeparatorRenderer = renderer;
        if (!Objects.equals(old, renderer)) {
            this.fireChanged(true, false, false);
        }
    }

    @Override
    public LineSeparatorRenderer getLineSeparatorRenderer() {
        return this.myLineSeparatorRenderer;
    }

    protected void registerInTree(@NotNull DocumentEx document, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (document == null) {
            RangeHighlighterImpl.$$$reportNull$$$0(8);
        }
        this.myModel.addRangeHighlighter(this, start, end, greedyToLeft, greedyToRight, layer);
    }

    protected void unregisterInTree() {
        this.getMarkupModel().removeHighlighter(this);
    }

    public void dispose() {
        if (LOG.isTraceEnabled()) {
            ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
            LOG.trace("RangeHighlighterImpl: dispose " + String.valueOf(this) + "; (" + this.myId + ")" + (String)(progress == null || progress instanceof NonCancelableIndicator ? "" : "; progress=" + String.valueOf(progress)));
        }
        super.dispose();
        GutterIconRenderer renderer = this.getGutterIconRenderer();
        if (renderer instanceof Disposable) {
            Disposable disposableRenderer = (Disposable)renderer;
            Disposer.dispose((Disposable)disposableRenderer);
        }
    }

    @Override
    public int getLayer() {
        RangeHighlighterTree.RHNode node = (RangeHighlighterTree.RHNode)this.myNode;
        return node == null ? -1 : node.myLayer;
    }

    @NonNls
    public String toString() {
        return "RangeHighlighter: " + (this.isValid() ? "" : "(invalid)") + "(" + this.getStartOffset() + "," + this.getEndOffset() + "); layer:" + this.getLayer() + (String)(this.getErrorStripeTooltip() == null ? "" : "; tooltip: " + String.valueOf(this.getErrorStripeTooltip())) + (String)(this.getTextAttributesKey() == null ? "" : "; textAttributeKey: " + String.valueOf(this.getTextAttributesKey()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributesKey";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/RangeHighlighterImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/RangeHighlighterImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetArea";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorFilter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkupModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTextAttributesKey";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setEditorFilter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "changeAttributesNoEvents";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerInTree";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7 -> new IllegalStateException(string);
        };
    }

    private static @interface Mask {
    }

    private static @interface Flag {
    }
}

