/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.downloader;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.remoteDev.downloader.JetBrainsClientDownloaderConfigurationProvider;
import com.intellij.remoteDev.util.LifetimeExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Signal;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010B\u001a\u00020%2\u0006\u0010C\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020)H\u0016J\u0016\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020HJ\u0018\u0010L\u001a\u00020%2\u0006\u0010M\u001a\u00020\u000b2\b\b\u0002\u0010N\u001a\u00020\u0005J\u001e\u0010O\u001a\u00020%2\u0006\u0010I\u001a\u00020J2\u0006\u0010P\u001a\u00020\u000b2\u0006\u0010Q\u001a\u00020\u000bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010(\u001a\u00020)X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020)X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R\u001a\u00101\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\r\"\u0004\b3\u0010\u000fR\u001a\u00104\u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0018\"\u0004\b6\u0010\u001aR\u0014\u00107\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0018R\u001a\u00109\u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0018\"\u0004\b;\u0010\u001aR\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00020%0=X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u0018R\u0010\u0010E\u001a\u0004\u0018\u00010FX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/intellij/remoteDev/downloader/TestJetBrainsClientDownloaderConfigurationProvider;", "Lcom/intellij/remoteDev/downloader/JetBrainsClientDownloaderConfigurationProvider;", "<init>", "()V", "x11DisplayForClient", "", "getX11DisplayForClient", "()Ljava/lang/String;", "setX11DisplayForClient", "(Ljava/lang/String;)V", "guestConfigFolder", "Ljava/nio/file/Path;", "getGuestConfigFolder", "()Ljava/nio/file/Path;", "setGuestConfigFolder", "(Ljava/nio/file/Path;)V", "guestSystemFolder", "getGuestSystemFolder", "setGuestSystemFolder", "guestLogFolder", "getGuestLogFolder", "setGuestLogFolder", "isDebugEnabled", "", "()Z", "setDebugEnabled", "(Z)V", "debugSuspendOnStart", "getDebugSuspendOnStart", "setDebugSuspendOnStart", "debugPort", "", "getDebugPort", "()I", "setDebugPort", "(I)V", "modifyClientCommandLine", "", "clientCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "clientDownloadUrl", "Ljava/net/URI;", "getClientDownloadUrl", "()Ljava/net/URI;", "setClientDownloadUrl", "(Ljava/net/URI;)V", "jreDownloadUrl", "getJreDownloadUrl", "setJreDownloadUrl", "clientCachesDir", "getClientCachesDir", "setClientCachesDir", "clientVersionManagementEnabled", "getClientVersionManagementEnabled", "setClientVersionManagementEnabled", "modifiedDateInManifestIncluded", "getModifiedDateInManifestIncluded", "verifySignature", "getVerifySignature", "setVerifySignature", "clientLaunched", "Lcom/jetbrains/rd/util/reactive/Signal;", "getClientLaunched", "()Lcom/jetbrains/rd/util/reactive/Signal;", "downloadLatestBuildFromCDNForSnapshotHost", "getDownloadLatestBuildFromCDNForSnapshotHost", "patchVmOptions", "vmOptionsFile", "connectionUri", "tarGzServer", "Lcom/sun/net/httpserver/HttpServer;", "mockClientDownloadsServer", "Ljava/net/InetSocketAddress;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "ipv4Address", "serveFile", "file", "httpPath", "startServerAndServeClient", "clientDistribution", "clientJdkBuildTxt", "intellij.remoteDev.util"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nJetBrainsClientDownloaderConfigurationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetBrainsClientDownloaderConfigurationProvider.kt\ncom/intellij/remoteDev/downloader/TestJetBrainsClientDownloaderConfigurationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,258:1\n1#2:259\n13#3:260\n23#3:261\n23#3:262\n23#3:263\n23#3:264\n23#3:265\n23#3:266\n23#3:267\n23#3:268\n*S KotlinDebug\n*F\n+ 1 JetBrainsClientDownloaderConfigurationProvider.kt\ncom/intellij/remoteDev/downloader/TestJetBrainsClientDownloaderConfigurationProvider\n*L\n134#1:260\n155#1:261\n189#1:262\n192#1:263\n195#1:264\n201#1:265\n204#1:266\n207#1:267\n236#1:268\n*E\n"})
public final class TestJetBrainsClientDownloaderConfigurationProvider
implements JetBrainsClientDownloaderConfigurationProvider {
    @Nullable
    private String x11DisplayForClient;
    @Nullable
    private Path guestConfigFolder;
    @Nullable
    private Path guestSystemFolder;
    @Nullable
    private Path guestLogFolder;
    private boolean isDebugEnabled;
    private boolean debugSuspendOnStart;
    private int debugPort = -1;
    @NotNull
    private URI clientDownloadUrl = new URI("https://download.jetbrains.com/idea/code-with-me/");
    @NotNull
    private URI jreDownloadUrl = new URI("https://download.jetbrains.com/idea/jbr/");
    @NotNull
    private Path clientCachesDir;
    private boolean clientVersionManagementEnabled;
    private final boolean modifiedDateInManifestIncluded;
    private boolean verifySignature;
    @NotNull
    private final Signal<Unit> clientLaunched;
    @Nullable
    private HttpServer tarGzServer;

    public TestJetBrainsClientDownloaderConfigurationProvider() {
        Path path = Files.createTempDirectory("jbc-test-storage", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        this.clientCachesDir = path;
        this.clientVersionManagementEnabled = true;
        this.modifiedDateInManifestIncluded = true;
        this.verifySignature = true;
        this.clientLaunched = new Signal();
    }

    @Nullable
    public final String getX11DisplayForClient() {
        return this.x11DisplayForClient;
    }

    public final void setX11DisplayForClient(@Nullable String string) {
        this.x11DisplayForClient = string;
    }

    @Nullable
    public final Path getGuestConfigFolder() {
        return this.guestConfigFolder;
    }

    public final void setGuestConfigFolder(@Nullable Path path) {
        this.guestConfigFolder = path;
    }

    @Nullable
    public final Path getGuestSystemFolder() {
        return this.guestSystemFolder;
    }

    public final void setGuestSystemFolder(@Nullable Path path) {
        this.guestSystemFolder = path;
    }

    @Nullable
    public final Path getGuestLogFolder() {
        return this.guestLogFolder;
    }

    public final void setGuestLogFolder(@Nullable Path path) {
        this.guestLogFolder = path;
    }

    public final boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public final void setDebugEnabled(boolean bl) {
        this.isDebugEnabled = bl;
    }

    public final boolean getDebugSuspendOnStart() {
        return this.debugSuspendOnStart;
    }

    public final void setDebugSuspendOnStart(boolean bl) {
        this.debugSuspendOnStart = bl;
    }

    public final int getDebugPort() {
        return this.debugPort;
    }

    public final void setDebugPort(int n) {
        this.debugPort = n;
    }

    @Override
    public void modifyClientCommandLine(@NotNull GeneralCommandLine clientCommandLine) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)clientCommandLine, (String)"clientCommandLine");
            String string = this.x11DisplayForClient;
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            if (!SystemInfo.isLinux) {
                boolean bl2 = false;
                String string2 = "X11 display property makes sense only on Linux";
                throw new IllegalArgumentException(string2.toString());
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Setting env var DISPLAY for Guest process=" + it);
            Map map = clientCommandLine.getEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
            Map map2 = map;
            map2.put("DISPLAY", it);
        }
    }

    @Override
    @NotNull
    public URI getClientDownloadUrl() {
        return this.clientDownloadUrl;
    }

    public void setClientDownloadUrl(@NotNull URI uRI) {
        Intrinsics.checkNotNullParameter((Object)uRI, (String)"<set-?>");
        this.clientDownloadUrl = uRI;
    }

    @Override
    @NotNull
    public URI getJreDownloadUrl() {
        return this.jreDownloadUrl;
    }

    public void setJreDownloadUrl(@NotNull URI uRI) {
        Intrinsics.checkNotNullParameter((Object)uRI, (String)"<set-?>");
        this.jreDownloadUrl = uRI;
    }

    @Override
    @NotNull
    public Path getClientCachesDir() {
        return this.clientCachesDir;
    }

    public void setClientCachesDir(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.clientCachesDir = path;
    }

    @Override
    public boolean getClientVersionManagementEnabled() {
        return this.clientVersionManagementEnabled;
    }

    public void setClientVersionManagementEnabled(boolean bl) {
        this.clientVersionManagementEnabled = bl;
    }

    @Override
    public boolean getModifiedDateInManifestIncluded() {
        return this.modifiedDateInManifestIncluded;
    }

    @Override
    public boolean getVerifySignature() {
        return this.verifySignature;
    }

    public void setVerifySignature(boolean bl) {
        this.verifySignature = bl;
    }

    @Override
    @NotNull
    public Signal<Unit> getClientLaunched() {
        return this.clientLaunched;
    }

    @Override
    public boolean getDownloadLatestBuildFromCDNForSnapshotHost() {
        Boolean envVar;
        Boolean bl = envVar = JetBrainsClientDownloaderConfigurationProvider.Companion.getThinClientDownloadLatestBuildFromCDNForSnapshotValue();
        return bl != null ? bl : false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void patchVmOptions(@NotNull Path vmOptionsFile, @NotNull URI connectionUri) {
        Intrinsics.checkNotNullParameter((Object)vmOptionsFile, (String)"vmOptionsFile");
        Intrinsics.checkNotNullParameter((Object)connectionUri, (String)"connectionUri");
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        v0 = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
        v0.info("Patching " + vmOptionsFile);
        $i$f$thisLogger = new String[]{"#com.jetbrains.rdserver.joinLinks", "#com.jetbrains.rd.platform.codeWithMe.network"};
        traceCategories = CollectionsKt.listOf((Object[])$i$f$thisLogger);
        if (this.isDebugEnabled) {
            suspendOnStart = this.debugSuspendOnStart != false ? "y" : "n";
            v1 = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspendOnStart + ",address=*:" + this.debugPort;
        } else {
            v1 = "";
        }
        debugOptions = v1;
        var6_7 = new String[17];
        var6_7[0] = "-Djb.consents.confirmation.enabled=false";
        var6_7[1] = "-Djb.privacy.policy.text=\"<!--999.999-->\"";
        var6_7[2] = "-Didea.initially.ask.config=never";
        var6_7[3] = "-Dfus.internal.test.mode=true";
        var6_7[4] = "-Didea.suppress.statistics.report=true";
        var6_7[5] = "-Drsch.send.usage.stat=false";
        var6_7[6] = "-Duse.linux.keychain=false";
        var6_7[7] = "-Didea.is.internal=true";
        var6_7[8] = "-DcodeWithMe.memory.only.certificate=true";
        var6_7[9] = "-Dide.slow.operations.assertion=false";
        var6_7[10] = "-Deap.login.enabled=false";
        var6_7[11] = "-Didea.updates.url=http://127.0.0.1";
        v2 = this.guestConfigFolder;
        Intrinsics.checkNotNull((Object)v2);
        var6_7[12] = "-Didea.config.path=" + v2.toAbsolutePath().toString();
        v3 = this.guestSystemFolder;
        Intrinsics.checkNotNull((Object)v3);
        var6_7[13] = "-Didea.system.path=" + v3.toAbsolutePath().toString();
        v4 = this.guestLogFolder;
        Intrinsics.checkNotNull((Object)v4);
        var6_7[14] = "-Didea.log.path=" + v4.toAbsolutePath().toString();
        var6_7[15] = "-Didea.log.trace.categories=" + CollectionsKt.joinToString$default((Iterable)traceCategories, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        var6_7[16] = debugOptions;
        testVmOptions = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])var6_7), (CharSequence)"\n", (CharSequence)"\n", null, (int)0, null, null, (int)60, null);
        v5 = new LinkOption[]{};
        if (!Files.isRegularFile(vmOptionsFile, Arrays.copyOf(v5, v5.length))) ** GOTO lbl-1000
        v6 = new LinkOption[]{};
        if (Files.exists(vmOptionsFile, Arrays.copyOf(v6, v6.length))) {
            v7 = true;
        } else lbl-1000:
        // 2 sources

        {
            v7 = false;
        }
        if (!v7) {
            var7_8 = "Failed requirement.";
            throw new IllegalArgumentException(var7_8.toString());
        }
        originalContent = PathsKt.readText((Path)vmOptionsFile, (Charset)Charsets.UTF_8);
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        v8 = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getInstance(...)");
        v8.info("Original .vmoptions=\n" + originalContent);
        patchedContent = originalContent + testVmOptions;
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        v9 = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getInstance(...)");
        v9.info("Patched .vmoptions=" + patchedContent);
        PathsKt.writeText$default((Path)vmOptionsFile, (CharSequence)patchedContent, null, (OpenOption[])new OpenOption[0], (int)2, null);
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        v10 = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getInstance(...)");
        v10.info("Patched " + vmOptionsFile + " successfully");
    }

    @NotNull
    public final InetSocketAddress mockClientDownloadsServer(@NotNull Lifetime lifetime, @NotNull InetSocketAddress ipv4Address) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)ipv4Address, (String)"ipv4Address");
        if (!(this.tarGzServer == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        TestJetBrainsClientDownloaderConfigurationProvider $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Initializing HTTP server to download distributions as if from outer world");
        HttpServer server = HttpServer.create(ipv4Address, 0);
        TestJetBrainsClientDownloaderConfigurationProvider $this$thisLogger$iv2 = this;
        boolean $i$f$thisLogger2 = false;
        Logger logger2 = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger2.info("HTTP server is bound to " + server.getAddress());
        server.createContext("/");
        $this$thisLogger$iv2 = this;
        $i$f$thisLogger2 = false;
        Logger logger3 = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
        logger3.info("Starting http server at " + server.getAddress());
        this.setClientDownloadUrl(new URI("http:/" + server.getAddress() + "/"));
        this.setVerifySignature(false);
        LifetimeExKt.onTerminationOrNow(lifetime, (Function0<Unit>)((Function0)() -> TestJetBrainsClientDownloaderConfigurationProvider.mockClientDownloadsServer$lambda$0(this, server)));
        server.start();
        this.tarGzServer = server;
        InetSocketAddress inetSocketAddress = server.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetSocketAddress, (String)"getAddress(...)");
        return inetSocketAddress;
    }

    public final void serveFile(@NotNull Path file, @NotNull String httpPath) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)httpPath, (String)"httpPath");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile(file, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        HttpServer server = this.tarGzServer;
        if (!(server != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        TestJetBrainsClientDownloaderConfigurationProvider $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Serving file " + file + " from " + server.getAddress());
        server.createContext("/" + httpPath, arg_0 -> TestJetBrainsClientDownloaderConfigurationProvider.serveFile$lambda$0(file, arg_0));
    }

    public static /* synthetic */ void serveFile$default(TestJetBrainsClientDownloaderConfigurationProvider testJetBrainsClientDownloaderConfigurationProvider, Path path, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = PathsKt.getName((Path)path);
        }
        testJetBrainsClientDownloaderConfigurationProvider.serveFile(path, string);
    }

    public final void startServerAndServeClient(@NotNull Lifetime lifetime, @NotNull Path clientDistribution, @NotNull Path clientJdkBuildTxt) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)clientDistribution, (String)"clientDistribution");
        Intrinsics.checkNotNullParameter((Object)clientJdkBuildTxt, (String)"clientJdkBuildTxt");
        if (!StringsKt.endsWith$default((String)PathsKt.getName((Path)clientJdkBuildTxt), (String)".txt", (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string = "Do not mix-up client archive and client jdk build txt arguments";
            throw new IllegalArgumentException(string.toString());
        }
        this.mockClientDownloadsServer(lifetime, new InetSocketAddress(Inet4Address.getLoopbackAddress(), 0));
        TestJetBrainsClientDownloaderConfigurationProvider.serveFile$default(this, clientDistribution, null, 2, null);
        TestJetBrainsClientDownloaderConfigurationProvider.serveFile$default(this, clientJdkBuildTxt, null, 2, null);
    }

    private static final Unit mockClientDownloadsServer$lambda$0(TestJetBrainsClientDownloaderConfigurationProvider this$0, HttpServer $server) {
        this$0.setClientDownloadUrl(new URI("INVALID"));
        this$0.setVerifySignature(true);
        this$0.tarGzServer = null;
        $server.stop(10);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void serveFile$lambda$0(Path $file, HttpExchange httpExchange) {
        httpExchange.sendResponseHeaders(200, Files.size($file));
        Closeable closeable = httpExchange.getResponseBody();
        Throwable throwable = null;
        try {
            OutputStream responseBody = (OutputStream)closeable;
            boolean bl = false;
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream($file, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            Closeable closeable2 = inputStream;
            Throwable throwable2 = null;
            try {
                InputStream it = (InputStream)closeable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)responseBody);
                ByteStreamsKt.copyTo((InputStream)it, (OutputStream)responseBody, (int)0x100000);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

