/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.CompactGroupHelper;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.rules.UsageGroupingRulesDefaultRanks;
import com.intellij.usages.rules.SingleParentUsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleEx;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.IconUtil;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DirectoryGroupingRule
extends SingleParentUsageGroupingRule
implements DumbAware,
UsageGroupingRuleEx {
    protected final Project myProject;
    protected final boolean myFlattenDirs;
    protected final boolean compactMiddleDirectories;

    public static DirectoryGroupingRule getInstance(Project project) {
        return (DirectoryGroupingRule)project.getService(DirectoryGroupingRule.class);
    }

    public DirectoryGroupingRule(@NotNull Project project) {
        if (project == null) {
            DirectoryGroupingRule.$$$reportNull$$$0(0);
        }
        this(project, true, false);
    }

    DirectoryGroupingRule(@NotNull Project project, boolean flattenDirs, boolean compactMiddleDirectories) {
        if (project == null) {
            DirectoryGroupingRule.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFlattenDirs = flattenDirs;
        this.compactMiddleDirectories = compactMiddleDirectories;
    }

    @Override
    @Nullable
    protected UsageGroup getParentGroupFor(@NotNull Usage usage, UsageTarget @NotNull [] targets) {
        UsageInFile usageInFile;
        VirtualFile file;
        if (usage == null) {
            DirectoryGroupingRule.$$$reportNull$$$0(2);
        }
        if (targets == null) {
            DirectoryGroupingRule.$$$reportNull$$$0(3);
        }
        if (usage instanceof UsageInFile && (file = (usageInFile = (UsageInFile)usage).getFile()) != null) {
            VirtualFile dir;
            if (file instanceof VirtualFileWindow) {
                file = ((VirtualFileWindow)file).getDelegate();
            }
            if ((dir = file.getParent()) == null) {
                return null;
            }
            return this.getGroupForFile(dir);
        }
        return null;
    }

    protected UsageGroup getGroupForFile(@NotNull VirtualFile dir) {
        if (dir == null) {
            DirectoryGroupingRule.$$$reportNull$$$0(4);
        }
        return new DirectoryGroup(dir);
    }

    @Override
    public int getRank() {
        return UsageGroupingRulesDefaultRanks.DIRECTORY_STRUCTURE.getAbsoluteRank();
    }

    @Override
    @NotNull
    public String getGroupingActionId() {
        return "UsageGrouping.Directory";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        objectArray2[1] = "com/intellij/usages/impl/rules/DirectoryGroupingRule";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentGroupFor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroupForFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class DirectoryGroup
    implements UsageGroup,
    UiDataProvider {
        protected final VirtualFile myDir;
        private Icon myIcon;
        @NlsSafe
        private final String relativePathText;

        protected DirectoryGroup(VirtualFile dir) {
            if (dir == null) {
                DirectoryGroup.$$$reportNull$$$0(0);
            }
            this.myDir = dir;
            this.relativePathText = this.myDir.getPath();
            this.update();
        }

        @Override
        public void update() {
            if (this.isValid()) {
                this.myIcon = IconUtil.getIcon((VirtualFile)this.myDir, (int)0, (Project)DirectoryGroupingRule.this.myProject);
            }
        }

        @Override
        public Icon getIcon() {
            return this.myIcon;
        }

        @Override
        @NotNull
        public String getPresentableGroupText() {
            if (DirectoryGroupingRule.this.compactMiddleDirectories) {
                String rel;
                List<String> parentPathList = CompactGroupHelper.pathToPathList(this.myDir.getPath());
                List<String> relativePathList = CompactGroupHelper.pathToPathList(this.relativePathText);
                String string = rel = this.relativePathText.startsWith("/") ? this.relativePathText.substring(1) : this.relativePathText;
                if (parentPathList.size() == relativePathList.size()) {
                    VirtualFile baseDir = ProjectUtil.guessProjectDir((Project)DirectoryGroupingRule.this.myProject);
                    String relativePath = null;
                    if (baseDir != null && baseDir.getParent() != null) {
                        relativePath = VfsUtilCore.getRelativePath((VirtualFile)this.myDir, (VirtualFile)baseDir.getParent(), (char)File.separatorChar);
                    }
                    String string2 = relativePath == null ? rel : relativePath.replace("\\", "/");
                    if (string2 == null) {
                        DirectoryGroup.$$$reportNull$$$0(1);
                    }
                    return string2;
                }
                String string3 = rel;
                if (string3 == null) {
                    DirectoryGroup.$$$reportNull$$$0(2);
                }
                return string3;
            }
            if (DirectoryGroupingRule.this.myFlattenDirs || this.myDir.getParent() == null) {
                VirtualFile baseDir = ProjectUtil.guessProjectDir((Project)DirectoryGroupingRule.this.myProject);
                String relativePath = baseDir == null ? null : VfsUtilCore.getRelativePath((VirtualFile)this.myDir, (VirtualFile)baseDir, (char)File.separatorChar);
                String string = relativePath == null ? this.myDir.getPresentableUrl() : relativePath;
                if (string == null) {
                    DirectoryGroup.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = this.myDir.getName();
            if (string == null) {
                DirectoryGroup.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public FileStatus getFileStatus() {
            return this.isValid() ? FileStatusManager.getInstance(DirectoryGroupingRule.this.myProject).getStatus(this.myDir) : null;
        }

        @Override
        public boolean isValid() {
            return this.myDir.isValid();
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            PsiDirectory directory = this.getDirectory();
            if (directory != null && directory.canNavigate()) {
                directory.navigate(focus);
            }
        }

        private PsiDirectory getDirectory() {
            return this.myDir.isValid() ? PsiManager.getInstance((Project)DirectoryGroupingRule.this.myProject).findDirectory(this.myDir) : null;
        }

        public boolean canNavigate() {
            PsiDirectory directory = this.getDirectory();
            return directory != null && directory.canNavigate();
        }

        @Override
        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                DirectoryGroup.$$$reportNull$$$0(5);
            }
            return this.getPresentableGroupText().compareToIgnoreCase(usageGroup.getPresentableGroupText());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DirectoryGroup)) {
                return false;
            }
            return this.myDir.equals(((DirectoryGroup)o).myDir);
        }

        public int hashCode() {
            return this.myDir.hashCode();
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                DirectoryGroup.$$$reportNull$$$0(6);
            }
            sink.set(CommonDataKeys.VIRTUAL_FILE, (Object)this.myDir);
            sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> this.getDirectory());
        }

        public String toString() {
            return UsageViewBundle.message("directory.0", this.myDir.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/DirectoryGroupingRule$DirectoryGroup";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageGroup";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/DirectoryGroupingRule$DirectoryGroup";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableGroupText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

