/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.customization.console;

import com.intellij.analysis.customization.console.ClassInfoResolver;
import com.intellij.analysis.customization.console.ProbableClassName;
import com.intellij.codeInspection.logging.LoggerTypeSearcher;
import com.intellij.codeInspection.logging.LoggingPlaceholderUtilKt;
import com.intellij.codeInspection.logging.LoggingStringPartEvaluator;
import com.intellij.codeInspection.logging.LoggingUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/analysis/customization/console/LogVisitor;", "Lcom/intellij/psi/PsiRecursiveElementVisitor;", "probableClassName", "Lcom/intellij/analysis/customization/console/ProbableClassName;", "<init>", "(Lcom/intellij/analysis/customization/console/ProbableClassName;)V", "similarClasses", "", "Lorg/jetbrains/uast/UClass;", "getSimilarClasses", "()Ljava/util/Set;", "similarCalls", "Lorg/jetbrains/uast/UCallExpression;", "getSimilarCalls", "shortClassNames", "", "visitElement", "", "element", "Lcom/intellij/psi/PsiElement;", "checkCalls", "", "uCall", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nLogFinderHyperlinkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogFinderHyperlinkHandler.kt\ncom/intellij/analysis/customization/console/LogVisitor\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 UResolvable.kt\norg/jetbrains/uast/UResolvableKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n171#2:178\n171#2:179\n43#3:180\n2792#4,3:181\n*S KotlinDebug\n*F\n+ 1 LogFinderHyperlinkHandler.kt\ncom/intellij/analysis/customization/console/LogVisitor\n*L\n124#1:178\n128#1:179\n142#1:180\n163#1:181,3\n*E\n"})
public final class LogVisitor
extends PsiRecursiveElementVisitor {
    @NotNull
    private final ProbableClassName probableClassName;
    @NotNull
    private final Set<UClass> similarClasses;
    @NotNull
    private final Set<UCallExpression> similarCalls;
    @NotNull
    private final Set<String> shortClassNames;

    public LogVisitor(@NotNull ProbableClassName probableClassName) {
        Intrinsics.checkNotNullParameter((Object)probableClassName, (String)"probableClassName");
        this.probableClassName = probableClassName;
        this.similarClasses = new LinkedHashSet();
        this.similarCalls = new LinkedHashSet();
        this.shortClassNames = new LinkedHashSet();
        String shortClassName = StringsKt.substringAfterLast$default((String)this.probableClassName.getFullClassName(), (char)'.', null, (int)2, null);
        this.shortClassNames.add(shortClassName);
        String subclassName = ClassInfoResolver.Companion.findSubclassName$intellij_jvm_analysis_impl(shortClassName);
        CharSequence charSequence = subclassName;
        if (!(charSequence == null || charSequence.length() == 0)) {
            this.shortClassNames.add(subclassName);
            if (Character.isDigit(subclassName.charAt(0))) {
                String string = shortClassName.substring(0, shortClassName.length() - subclassName.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.shortClassNames.add(string);
            }
        }
    }

    @NotNull
    public final Set<UClass> getSimilarClasses() {
        return this.similarClasses;
    }

    @NotNull
    public final Set<UCallExpression> getSimilarCalls() {
        return this.similarCalls;
    }

    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$toUElementOfType$iv = element;
        boolean $i$f$toUElementOfType = false;
        UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UClass.class);
        if (uClass != null && CollectionsKt.contains((Iterable)this.shortClassNames, (Object)uClass.getJavaPsi().getName())) {
            this.similarClasses.add(uClass);
        }
        PsiElement $this$toUElementOfType$iv2 = element;
        boolean $i$f$toUElementOfType2 = false;
        UCallExpression uCall = (UCallExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv2, UCallExpression.class);
        if (uCall != null && this.checkCalls(uCall, this.probableClassName)) {
            this.similarCalls.add(uCall);
        }
        super.visitElement(element);
    }

    private final boolean checkCalls(UCallExpression uCall, ProbableClassName probableClassName) {
        String[] it;
        boolean bl;
        int startPoint;
        String fullLine;
        List<LoggingStringPartEvaluator.PartHolder> calculateValue;
        block17: {
            boolean isLogger;
            boolean bl2 = isLogger = LoggingUtil.Companion.getLOG_MATCHERS$intellij_jvm_analysis_impl().uCallMatches(uCall) || LoggingUtil.Companion.getLEGACY_LOG_MATCHERS$intellij_jvm_analysis_impl().uCallMatches(uCall) || LoggingUtil.Companion.getIDEA_LOG_MATCHER$intellij_jvm_analysis_impl().uCallMatches(uCall);
            if (!isLogger) {
                return false;
            }
            UResolvable $this$resolveToUElementOfType$iv = (UResolvable)uCall;
            boolean $i$f$resolveToUElementOfType = false;
            UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
            if (!(uElement instanceof UMethod)) {
                uElement = null;
            }
            UMethod uMethod = (UMethod)((UElement)((UMethod)uElement));
            if (uMethod == null) {
                return false;
            }
            UMethod method = uMethod;
            List arguments = uCall.getValueArguments();
            List parameters = method.getUastParameters();
            Integer index = LoggingPlaceholderUtilKt.getLogStringIndex(parameters);
            UExpression logStringArgument = null;
            if (index == null) {
                LoggerTypeSearcher searcher = (LoggerTypeSearcher)LoggingPlaceholderUtilKt.getLOGGER_TYPE_SEARCHERS().mapFirst(uCall);
                if (searcher != null) {
                    logStringArgument = LoggingPlaceholderUtilKt.findMessageSetterStringArg(uCall, searcher);
                }
            } else {
                logStringArgument = (UExpression)arguments.get(index - 1);
            }
            if (logStringArgument == null && !((Collection)parameters).isEmpty()) {
                logStringArgument = (UExpression)arguments.get(0);
            }
            if (logStringArgument == null) {
                return false;
            }
            List<LoggingStringPartEvaluator.PartHolder> list = LoggingStringPartEvaluator.Companion.calculateValue$intellij_jvm_analysis_impl(logStringArgument);
            if (list == null) {
                return false;
            }
            calculateValue = list;
            fullLine = probableClassName.getFullLine();
            startPoint = StringsKt.indexOf$default((CharSequence)probableClassName.getFullLine(), (String)probableClassName.getFullClassName(), (int)0, (boolean)false, (int)6, null);
            if (startPoint == -1) {
                return false;
            }
            startPoint += probableClassName.getFullClassName().length();
            Iterable $this$none$iv = calculateValue;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (String[])element$iv;
                    boolean bl3 = false;
                    if (!(it.isConstant() && it.getText() != null)) continue;
                    bl = false;
                    break block17;
                }
                bl = true;
            }
        }
        if (bl) {
            return false;
        }
        for (LoggingStringPartEvaluator.PartHolder value : calculateValue) {
            String text = value.getText();
            if (!value.isConstant() || text == null) continue;
            it = new String[]{"{}"};
            for (String part : StringsKt.split$default((CharSequence)text, (String[])it, (boolean)false, (int)0, (int)6, null)) {
                startPoint = StringsKt.indexOf$default((CharSequence)fullLine, (String)part, (int)startPoint, (boolean)false, (int)4, null);
                if (startPoint == -1) {
                    return false;
                }
                startPoint += part.length();
            }
        }
        return true;
    }
}

