/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EnumFieldFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            EnumFieldFixer.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof PsiEnumConstant) {
            int insertionOffset = psiElement.getTextRange().getEndOffset();
            Document doc = editor.getDocument();
            CharSequence text = doc.getCharsSequence();
            int probableCommaOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)insertionOffset, (String)" \t");
            if (probableCommaOffset >= text.length() || text.charAt(probableCommaOffset) != ',') {
                doc.insertString(insertionOffset, (CharSequence)",");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/smartEnter/EnumFieldFixer", "apply"));
    }
}

