/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class TernaryColonFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            TernaryColonFixer.$$$reportNull$$$0(0);
        }
        if (!(psiElement instanceof PsiConditionalExpression)) {
            return;
        }
        PsiConditionalExpression ternary = (PsiConditionalExpression)psiElement;
        if (ternary.getThenExpression() == null || ternary.getNode().findChildByType(JavaTokenType.COLON) != null) {
            return;
        }
        editor.getCaretModel().moveToOffset(ternary.getTextRange().getEndOffset());
        EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)": ");
        processor.setSkipEnter(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/smartEnter/TernaryColonFixer", "apply"));
    }
}

